/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGVirtualRepository;
import com.franz.util.Closeable;
import com.franz.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResult;

public class AGServer
implements Closeable {
    private final String serverURL;
    private final AGHTTPClient httpClient;
    private final AGCatalog rootCatalog;

    public AGServer(String serverURL, String username, String password) {
        this.serverURL = serverURL;
        this.httpClient = new AGHTTPClient(serverURL);
        this.httpClient.setUsernameAndPassword(username, password);
        this.rootCatalog = new AGCatalog(this, 0);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    AGHTTPClient getHTTPClient() {
        return this.httpClient;
    }

    public AGCatalog getRootCatalog() {
        return this.rootCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCatalogs() throws OpenRDFException {
        String url = AGProtocol.getNamedCatalogsURL(this.serverURL);
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        ArrayList<String> result = new ArrayList<String>(5);
        try {
            while (tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value id = bindingSet.getValue("id");
                result.add(id.stringValue());
            }
        }
        finally {
            tqresult.close();
        }
        return result;
    }

    public AGCatalog getCatalog(String catalogID) {
        AGCatalog catalog = AGCatalog.isRootID(catalogID) ? this.getRootCatalog() : new AGCatalog(this, catalogID);
        return catalog;
    }

    public AGCatalog getCatalog() {
        return this.rootCatalog;
    }

    public AGVirtualRepository virtualRepository(String spec) {
        return new AGVirtualRepository(this, spec, null);
    }

    public AGVirtualRepository federate(AGAbstractRepository ... repositories) {
        String[] specstrings = new String[repositories.length];
        for (int i = 0; i < repositories.length; ++i) {
            specstrings[i] = repositories[i].getSpec();
        }
        String spec = AGVirtualRepository.federatedSpec(specstrings);
        return new AGVirtualRepository(this, spec, null);
    }

    @Override
    public void close() {
        Util.close(this.httpClient);
    }
}

