/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class AGModel
extends ModelCom
implements Model,
Closeable {
    public AGModel(AGGraph base) {
        super((Graph)base);
    }

    public AGGraph getGraph() {
        return (AGGraph)this.graph;
    }

    public AGModel read(InputStream reader, String base) {
        return this.read(reader, base, "RDF/XML");
    }

    public AGModel read(InputStream reader, String base, String lang) {
        RDFFormat format;
        if (lang.contains("TRIPLE")) {
            format = RDFFormat.NTRIPLES;
        } else if (lang.contains("RDF")) {
            format = RDFFormat.RDFXML;
        } else {
            throw new IllegalArgumentException("Unsupported format: " + lang + " (expected RDF/XML or N-TRIPLE).");
        }
        try {
            this.getGraph().getConnection().add(reader, base, format, new Resource[]{this.getGraph().getGraphContext()});
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public com.hp.hpl.jena.rdf.model.Resource createResource() {
        AGValueFactory vf = this.getGraph().getConnection().getValueFactory();
        BNode blank = vf.createBNode();
        return this.createResource(new AnonId(blank.stringValue()));
    }
}

