/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.AGResponseHandler;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.StatementCollector;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class AGRepositoryConnection
extends RepositoryConnectionBase
implements RepositoryConnection,
Closeable {
    private final AGAbstractRepository repository;
    private final AGHttpRepoClient repoclient;

    public AGRepositoryConnection(AGAbstractRepository repository, AGHttpRepoClient client) {
        super((Repository)repository);
        this.repository = repository;
        this.repoclient = client;
    }

    public AGAbstractRepository getRepository() {
        return this.repository;
    }

    public AGHttpRepoClient getHttpRepoClient() {
        return this.repoclient;
    }

    public AGValueFactory getValueFactory() {
        return this.getRepository().getValueFactory();
    }

    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        StatementImpl st = new StatementImpl(subject, predicate, object);
        JSONArray rows = this.encodeJSON((Statement)st, contexts);
        this.getHttpRepoClient().uploadJSON(rows, new Resource[0]);
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            JSONArray rows_st = this.encodeJSON(statement, new Resource[0]);
            this.append(rows, rows_st);
        }
        this.getHttpRepoClient().uploadJSON(rows, contexts);
    }

    private void append(JSONArray rows, JSONArray rowsSt) {
        for (int i = 0; i < rowsSt.length(); ++i) {
            try {
                rows.put(rowsSt.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statementIter.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statementIter.next(), contexts));
        }
        this.getHttpRepoClient().uploadJSON(rows, new Resource[0]);
    }

    private JSONArray encodeJSON(Statement st, Resource ... contexts) {
        JSONArray rows = new JSONArray();
        if (contexts.length == 0) {
            JSONArray row = new JSONArray().put((Object)NTriplesUtil.toNTriplesString((Resource)st.getSubject())).put((Object)NTriplesUtil.toNTriplesString((URI)st.getPredicate())).put((Object)NTriplesUtil.toNTriplesString((Value)st.getObject()));
            if (st.getContext() != null) {
                row.put((Object)NTriplesUtil.toNTriplesString((Resource)st.getContext()));
            }
            rows.put((Object)row);
        } else {
            for (Resource c : contexts) {
                JSONArray row = new JSONArray().put((Object)NTriplesUtil.toNTriplesString((Resource)st.getSubject())).put((Object)NTriplesUtil.toNTriplesString((URI)st.getPredicate())).put((Object)NTriplesUtil.toNTriplesString((Value)st.getObject()));
                if (c != null) {
                    row.put((Object)NTriplesUtil.toNTriplesString((Resource)c));
                }
                rows.put((Object)row);
            }
        }
        return rows;
    }

    protected void addInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (inputStreamOrReader instanceof InputStream) {
            this.getHttpRepoClient().upload((InputStream)inputStreamOrReader, baseURI, dataFormat, false, contexts);
        } else if (inputStreamOrReader instanceof Reader) {
            this.getHttpRepoClient().upload((Reader)inputStreamOrReader, baseURI, dataFormat, false, contexts);
        } else {
            throw new IllegalArgumentException("inputStreamOrReader must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
        }
    }

    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.getHttpRepoClient().deleteStatements(subject, predicate, object, contexts);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            this.append(rows, this.encodeJSON(statement, contexts));
        }
        this.getHttpRepoClient().deleteJSON(rows, new Resource[0]);
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statements.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statements.next(), contexts));
        }
        this.getHttpRepoClient().deleteJSON(rows, new Resource[0]);
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        this.getHttpRepoClient().setAutoCommit(autoCommit);
    }

    public boolean isAutoCommit() throws RepositoryException {
        return this.getHttpRepoClient().isAutoCommit();
    }

    public void commit() throws RepositoryException {
        this.getHttpRepoClient().commit();
    }

    public void rollback() throws RepositoryException {
        this.getHttpRepoClient().rollback();
    }

    protected void autoCommit() throws RepositoryException {
    }

    public void clearNamespaces() throws RepositoryException {
        this.getHttpRepoClient().clearNamespaces();
    }

    @Override
    public void close() throws RepositoryException {
        if (this.isOpen()) {
            this.getHttpRepoClient().close();
            super.close();
        }
    }

    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        try {
            this.getHttpRepoClient().getStatements(subj, pred, obj, includeInferred, handler, contexts);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            TupleQueryResult contextIDs = this.getHttpRepoClient().getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            finally {
                contextIDs.close();
            }
            return this.createRepositoryResult(contextList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(elements.iterator()));
    }

    public String getNamespace(String prefix) throws RepositoryException {
        try {
            return this.getHttpRepoClient().getNamespace(prefix);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<NamespaceImpl> namespaceList = new ArrayList<NamespaceImpl>();
            TupleQueryResult namespaces = this.getHttpRepoClient().getNamespaces();
            try {
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace).getLabel();
                    namespaceList.add(new NamespaceImpl(prefixStr, namespaceStr));
                }
            }
            finally {
                namespaces.close();
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, (RDFHandler)collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public AGQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        throw new UnsupportedOperationException();
    }

    public AGTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString) {
        return this.prepareTupleQuery(ql, queryString, null);
    }

    public AGTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGTupleQuery q = new AGTupleQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public AGGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString) {
        return this.prepareGraphQuery(ql, queryString, null);
    }

    public AGGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGGraphQuery q = new AGGraphQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public AGBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString) {
        return this.prepareBooleanQuery(ql, queryString, null);
    }

    public AGBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGBooleanQuery q = new AGBooleanQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.getHttpRepoClient().removeNamespacePrefix(prefix);
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.getHttpRepoClient().setNamespacePrefix(prefix, name);
    }

    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.getHttpRepoClient().size(contexts);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void createFreetextIndex(String name, URI[] predicates) throws RepositoryException {
        this.getHttpRepoClient().createFreetextIndex(name, predicates);
    }

    public String[] getFreetextPredicates(String index) throws RepositoryException {
        return this.getHttpRepoClient().getFreetextPredicates(index);
    }

    public String[] getFreetextIndices() throws RepositoryException {
        return this.getHttpRepoClient().getFreetextIndices();
    }

    public void registerPredicateMapping(URI predicate, URI primtype) throws RepositoryException {
        this.getHttpRepoClient().registerPredicateMapping(predicate, primtype);
    }

    public void deletePredicateMapping(URI predicate) throws RepositoryException {
        this.getHttpRepoClient().deletePredicateMapping(predicate);
    }

    public String[] getPredicateMappings() throws RepositoryException {
        return this.getHttpRepoClient().getPredicateMappings();
    }

    public void registerDatatypeMapping(URI datatype, URI primtype) throws RepositoryException {
        this.getHttpRepoClient().registerDatatypeMapping(datatype, primtype);
    }

    public void deleteDatatypeMapping(URI datatype) throws RepositoryException {
        this.getHttpRepoClient().deleteDatatypeMapping(datatype);
    }

    public String[] getDatatypeMappings() throws RepositoryException {
        return this.getHttpRepoClient().getDatatypeMappings();
    }

    public void clearMappings() throws RepositoryException {
        this.getHttpRepoClient().clearMappings();
    }

    public void addRules(String rules) throws RepositoryException {
        this.getHttpRepoClient().addRules(rules);
    }

    public void addRules(InputStream rulestream) throws RepositoryException {
        this.getHttpRepoClient().addRules(rulestream);
    }

    public String evalInServer(String lispForm) throws RepositoryException {
        return this.getHttpRepoClient().evalInServer(lispForm);
    }

    public String evalInServer(InputStream stream) throws RepositoryException {
        return this.getHttpRepoClient().evalInServer(stream);
    }

    public void load(URI source, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException {
        try {
            this.getHttpRepoClient().load(source, baseURI, dataFormat, contexts);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void load(String absoluteServerPath, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException {
        try {
            this.getHttpRepoClient().load(absoluteServerPath, baseURI, dataFormat, contexts);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void ping() throws RepositoryException {
        this.getHttpRepoClient().ping();
    }

    public String[] getGeoTypes() throws RepositoryException {
        return this.getHttpRepoClient().getGeoTypes();
    }

    public URI registerCartesianType(float stripWidth, float xmin, float xmax, float ymin, float ymax) throws RepositoryException {
        String nTriplesURI = this.getHttpRepoClient().registerCartesianType(stripWidth, xmin, xmax, ymin, ymax);
        return NTriplesUtil.parseURI((String)nTriplesURI, (ValueFactory)this.getValueFactory());
    }

    public URI registerSphericalType(float stripWidth, String unit, float latmin, float lonmin, float latmax, float lonmax) throws RepositoryException {
        String nTriplesURI = this.getHttpRepoClient().registerSphericalType(stripWidth, unit, latmin, lonmin, latmax, lonmax);
        return NTriplesUtil.parseURI((String)nTriplesURI, (ValueFactory)this.getValueFactory());
    }

    public URI registerSphericalType(float stripWidth, String unit) throws RepositoryException {
        return this.registerSphericalType(stripWidth, unit, -90.0f, -180.0f, 90.0f, 180.0f);
    }

    public void registerPolygon(URI polygon, List<Literal> points) throws RepositoryException {
        ArrayList<String> nTriplesPoints = new ArrayList<String>(points.size());
        for (Literal point : points) {
            nTriplesPoints.add(NTriplesUtil.toNTriplesString((Literal)point));
        }
        this.getHttpRepoClient().registerPolygon(NTriplesUtil.toNTriplesString((URI)polygon), nTriplesPoints);
    }

    public RepositoryResult<Statement> getStatementsInBox(URI type, URI predicate, float xmin, float xmax, float ymin, float ymax, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGResponseHandler handler = new AGResponseHandler(this.getRepository(), (RDFHandler)collector, this.getHttpRepoClient().getPreferredRDFFormat());
        this.getHttpRepoClient().getGeoBox(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), xmin, xmax, ymin, ymax, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getStatementsInCircle(URI type, URI predicate, float x, float y, float radius, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGResponseHandler handler = new AGResponseHandler(this.getRepository(), (RDFHandler)collector, this.getHttpRepoClient().getPreferredRDFFormat());
        this.getHttpRepoClient().getGeoCircle(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), x, y, radius, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getGeoHaversine(URI type, URI predicate, float lat, float lon, float radius, String unit, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGResponseHandler handler = new AGResponseHandler(this.getRepository(), (RDFHandler)collector, this.getHttpRepoClient().getPreferredRDFFormat());
        this.getHttpRepoClient().getGeoHaversine(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), lat, lon, radius, unit, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getStatementsInPolygon(URI type, URI predicate, URI polygon, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGResponseHandler handler = new AGResponseHandler(this.getRepository(), (RDFHandler)collector, this.getHttpRepoClient().getPreferredRDFFormat());
        this.getHttpRepoClient().getGeoPolygon(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), NTriplesUtil.toNTriplesString((URI)polygon), limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public void registerSNAGenerator(String generator, List<URI> objectOfs, List<URI> subjectOfs, List<URI> undirecteds, String query) throws RepositoryException {
        ArrayList<String> objOfs = new ArrayList<String>();
        if (objectOfs != null) {
            for (URI objectOf : objectOfs) {
                objOfs.add(NTriplesUtil.toNTriplesString((URI)objectOf));
            }
        }
        ArrayList<String> subjOfs = new ArrayList<String>();
        if (subjectOfs != null) {
            for (URI subjectOf : subjectOfs) {
                subjOfs.add(NTriplesUtil.toNTriplesString((URI)subjectOf));
            }
        }
        ArrayList<String> undirs = new ArrayList<String>();
        if (undirecteds != null) {
            for (URI undirected : undirecteds) {
                undirs.add(NTriplesUtil.toNTriplesString((URI)undirected));
            }
        }
        this.getHttpRepoClient().registerSNAGenerator(generator, objOfs, subjOfs, undirs, query);
    }

    public void registerSNANeighborMatrix(String matrix, String generator, List<URI> group, int depth) throws RepositoryException {
        if (group == null || group.size() == 0) {
            throw new IllegalArgumentException("group must be non-empty.");
        }
        ArrayList<String> grp = new ArrayList<String>(3);
        for (URI node : group) {
            grp.add(NTriplesUtil.toNTriplesString((URI)node));
        }
        this.getHttpRepoClient().registerSNANeighborMatrix(matrix, generator, grp, depth);
    }
}

