/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGErrorType;
import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpException;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;

public class AGCatalog {
    private AGServer server;
    private final String catalogName;
    private final int catalogType;
    private final String catalogURL;
    private final String repositoriesURL;
    public static final int ROOT_CATALOG = 0;
    public static final int NAMED_CATALOG = 2;

    public AGCatalog(AGServer server, String catalogName) {
        this.server = server;
        this.catalogName = catalogName;
        this.catalogType = 2;
        this.catalogURL = AGProtocol.getNamedCatalogLocation(server.getServerURL(), catalogName);
        this.repositoriesURL = AGProtocol.getNamedCatalogRepositoriesLocation(this.catalogURL);
    }

    public AGCatalog(AGServer server, int catalogType) {
        switch (catalogType) {
            case 0: {
                this.catalogName = "/";
                this.catalogURL = AGProtocol.getRootCatalogURL(server.getServerURL());
                this.repositoriesURL = AGProtocol.getRootCatalogRepositoriesLocation(this.catalogURL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Catalog Type: " + catalogType);
            }
        }
        this.server = server;
        this.catalogType = catalogType;
    }

    public AGServer getServer() {
        return this.server;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public int getCatalogType() {
        return this.catalogType;
    }

    public String getCatalogURL() {
        return this.catalogURL;
    }

    public String getRepositoriesURL() {
        return this.repositoriesURL;
    }

    protected String getCatalogPrefixedRepositoryID(String repositoryID) {
        String catalogPrefixedRepositoryID;
        switch (this.getCatalogType()) {
            case 0: {
                catalogPrefixedRepositoryID = repositoryID;
                break;
            }
            case 2: {
                catalogPrefixedRepositoryID = this.getCatalogName() + ":" + repositoryID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Catalog Type: " + this.catalogType);
            }
        }
        return catalogPrefixedRepositoryID;
    }

    public String getRepositoryURL(String repositoryID) {
        return this.repositoriesURL + "/" + AGProtocol.encode(repositoryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listRepositories() throws OpenRDFException {
        String url = this.getRepositoriesURL();
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        ArrayList<String> result = new ArrayList<String>(5);
        try {
            while (tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value id = bindingSet.getValue("id");
                result.add(id.stringValue());
            }
        }
        finally {
            tqresult.close();
        }
        return result;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getServer().getHTTPClient();
    }

    public AGRepository createRepository(String repositoryID) throws RepositoryException {
        block3: {
            String repoURL = AGProtocol.getRepositoryLocation((String)this.getCatalogURL(), (String)repositoryID);
            try {
                this.getHTTPClient().putRepository(repoURL);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (AGHttpException e) {
                if (AGErrorType.PRECONDITION_FAILED == e.getErrorInfo().getErrorType()) break block3;
                throw new RepositoryException((Throwable)e);
            }
        }
        return new AGRepository(this, repositoryID);
    }

    public void deleteRepository(String repositoryID) throws RepositoryException {
        String repoURL = AGProtocol.getRepositoryLocation((String)this.getCatalogURL(), (String)repositoryID);
        try {
            this.getHTTPClient().deleteRepository(repoURL);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

