/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;

public class AGResponseHandler {
    private final Repository repository;
    private final RDFHandler rdfhandler;
    private final TupleQueryResultHandler tqrhandler;
    private final boolean bqrHandler;
    private final boolean longHandler;
    private final boolean stringHandler;
    private boolean bqrresult;
    private long longresult;
    private String stringresult = null;
    private String requestMIMEType;

    public AGResponseHandler(Repository repository, RDFHandler rdfhandler, RDFFormat rdfformat) {
        this.repository = repository;
        this.rdfhandler = rdfhandler;
        this.tqrhandler = null;
        this.bqrHandler = false;
        this.longHandler = false;
        this.stringHandler = false;
        this.requestMIMEType = rdfformat.getDefaultMIMEType();
    }

    public AGResponseHandler(Repository repository, TupleQueryResultHandler tqrhandler) {
        this.repository = repository;
        this.rdfhandler = null;
        this.tqrhandler = tqrhandler;
        this.bqrHandler = false;
        this.longHandler = false;
        this.stringHandler = false;
        this.requestMIMEType = TupleQueryResultFormat.SPARQL.getDefaultMIMEType();
    }

    public AGResponseHandler(boolean bqrresponse) {
        this.repository = null;
        this.rdfhandler = null;
        this.tqrhandler = null;
        this.bqrHandler = true;
        this.longHandler = false;
        this.stringHandler = false;
        this.requestMIMEType = BooleanQueryResultFormat.TEXT.getDefaultMIMEType();
    }

    public AGResponseHandler(long l) {
        this.repository = null;
        this.rdfhandler = null;
        this.tqrhandler = null;
        this.bqrHandler = false;
        this.longHandler = true;
        this.stringHandler = false;
        this.requestMIMEType = "text/integer";
    }

    public AGResponseHandler(String s) {
        this.repository = null;
        this.rdfhandler = null;
        this.tqrhandler = null;
        this.bqrHandler = false;
        this.longHandler = false;
        this.stringHandler = true;
        this.requestMIMEType = null;
    }

    public String getRequestMIMEType() {
        return this.requestMIMEType;
    }

    public boolean getBoolean() {
        return this.bqrresult;
    }

    public long getLong() {
        return this.longresult;
    }

    public String getString() {
        return this.stringresult;
    }

    public void handleResponse(HttpMethod method) throws IOException, RepositoryException {
        block13: {
            InputStream response = AGResponseHandler.getInputStream(method);
            String mimeType = this.getResponseMIMEType(method);
            try {
                if (this.rdfhandler != null) {
                    RDFFormat format = RDFFormat.forMIMEType((String)mimeType, (RDFFormat)RDFFormat.TRIX);
                    RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)this.repository.getValueFactory());
                    parser.setPreserveBNodeIDs(true);
                    parser.setRDFHandler(this.rdfhandler);
                    parser.parse(response, method.getURI().getURI());
                    break block13;
                }
                if (this.tqrhandler != null) {
                    TupleQueryResultFormat format = TupleQueryResultFormat.SPARQL;
                    TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)format, (ValueFactory)this.repository.getValueFactory());
                    parser.setTupleQueryResultHandler(this.tqrhandler);
                    parser.parse(response);
                    break block13;
                }
                if (this.bqrHandler) {
                    BooleanQueryResultFormat format = BooleanQueryResultFormat.TEXT;
                    BooleanQueryResultParser parser = QueryResultIO.createParser((BooleanQueryResultFormat)format);
                    this.bqrresult = parser.parse(response);
                    break block13;
                }
                if (this.longHandler) {
                    try {
                        String str = AGResponseHandler.streamToString(response);
                        this.longresult = Long.parseLong(str);
                        break block13;
                    }
                    catch (NumberFormatException e) {
                        throw new RepositoryException("Server responded with invalid long value", (Throwable)e);
                    }
                }
                if (this.stringHandler) {
                    this.stringresult = AGResponseHandler.streamToString(response);
                    break block13;
                }
                throw new RuntimeException("Cannot handle response, unexpected type.");
            }
            catch (UnsupportedRDFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
            catch (RDFParseException e) {
                throw new RepositoryException("Malformed query result from server", (Throwable)e);
            }
            catch (RDFHandlerException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (QueryResultParseException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (TupleQueryResultHandlerException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    protected String getResponseMIMEType(HttpMethod method) throws IOException {
        Header[] headers;
        for (Header header : headers = method.getResponseHeaders("Content-Type")) {
            HeaderElement[] headerElements;
            for (HeaderElement headerEl : headerElements = header.getElements()) {
                String mimeType = headerEl.getName();
                if (mimeType == null) continue;
                return mimeType;
            }
        }
        return null;
    }

    protected static InputStream getInputStream(HttpMethod method) throws IOException {
        InputStream is = method.getResponseBodyAsStream();
        Header h = method.getResponseHeader("Content-Encoding");
        if (h != null && h.getValue().equals("gzip")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    protected static String streamToString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

