/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.franz.agbase.AllegroGraphException;
import com.franz.agsail.AGSailCursor;
import com.knowledgereefsystems.agsail.AllegroSailException;
import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.SailException;

public class StatementIteration
implements CloseableIteration<Statement, SailException> {
    private AGSailCursor[] cursors;
    private int cursorIndex;
    private ValueFactory valueFactory;

    public StatementIteration(AGSailCursor[] c, ValueFactory vf) {
        this.cursors = c;
        this.cursorIndex = 0;
        this.valueFactory = vf;
    }

    public void close() throws SailException {
        try {
            for (int i = this.cursorIndex; i < this.cursors.length; ++i) {
                this.cursors[i].close();
            }
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
    }

    public boolean hasNext() throws SailException {
        if (this.cursorIndex >= this.cursors.length) {
            return false;
        }
        try {
            if (this.cursors[this.cursorIndex].hasNext()) {
                return true;
            }
            this.cursors[this.cursorIndex].close();
            ++this.cursorIndex;
            if (this.cursorIndex < this.cursors.length) {
                return this.cursors[this.cursorIndex].hasNext();
            }
            return false;
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
    }

    public Statement next() throws SailException {
        try {
            AGSailCursor c = this.cursors[this.cursorIndex];
            c.step();
            Statement st = this.createStatement(c);
            return st;
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
    }

    public void remove() throws SailException {
        try {
            this.cursors[this.cursorIndex].remove();
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
    }

    private Statement createStatement(AGSailCursor c) throws AllegroGraphException {
        Resource context = c.getContext();
        return null == context ? this.valueFactory.createStatement(c.getSubject(), c.getPredicate(), c.getObject()) : this.valueFactory.createStatement(c.getSubject(), c.getPredicate(), c.getObject(), context);
    }
}

