/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agsail.util;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.BlankNode;
import com.franz.agbase.DefaultGraph;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agsail.AGForSail;
import com.franz.agsail.AGSailCursor;
import com.franz.agsail.AGSailTriple;
import com.franz.agsail.impl.AGSailBlankNodeImpl;
import com.franz.agsail.impl.AGSailFactory;
import com.franz.agsail.impl.AGSailValueObjectImpl;
import java.util.Hashtable;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class AGSInternal {
    private AllegroGraph directInstance = null;
    private Hashtable<UPI, BNode> agToSail = new Hashtable();
    private Hashtable<BNode, BlankNode> sailToAG = new Hashtable();

    public AGSInternal(AllegroGraph d) {
        this.directInstance = d;
    }

    public AllegroGraph getDirectInstance() {
        return this.directInstance;
    }

    public Object coerceToAGPart(Object openrdfPart) {
        AGSailValueObjectImpl impl;
        ValueObject di;
        if (openrdfPart == null) {
            return null;
        }
        if (openrdfPart instanceof AGSailValueObjectImpl && (di = (impl = (AGSailValueObjectImpl)openrdfPart).getDirectInstance()) != null) {
            return di;
        }
        if (openrdfPart instanceof URI) {
            return this.directInstance.createURI(openrdfPart.toString());
        }
        if (openrdfPart instanceof Literal) {
            Literal lit = (Literal)openrdfPart;
            String lang = lit.getLanguage();
            if (lang != null) {
                return this.directInstance.createLiteral(lit.getLabel(), lang);
            }
            URI dt = lit.getDatatype();
            if (dt != null) {
                return this.directInstance.createTypedLiteral(lit.getLabel(), dt.toString());
            }
            return this.directInstance.createLiteral(lit.getLabel());
        }
        if (openrdfPart instanceof BNode) {
            return this.lookupBNode((BNode)openrdfPart);
        }
        if (openrdfPart instanceof String) {
            return openrdfPart;
        }
        throw new IllegalArgumentException("Cannot coerce to AGPart " + openrdfPart);
    }

    public AGSailCursor coerceToSailCursor(TriplesIterator agcursor) {
        return AGSailFactory.makeCursor((AGForSail)this, agcursor);
    }

    public AGSailTriple coerceToSailTriple(Triple tr) {
        return AGSailFactory.makeTriple((AGForSail)this, tr);
    }

    public Value coerceToSailValue(ValueNode agInstance) {
        if (agInstance == null) {
            return null;
        }
        if (agInstance instanceof URINode) {
            return AGSailFactory.makeNode((AGForSail)this, (URINode)agInstance);
        }
        if (agInstance instanceof BlankNode) {
            return this.registerBlankNode((BlankNode)agInstance, null);
        }
        if (agInstance instanceof LiteralNode) {
            return AGSailFactory.makeLiteral((AGForSail)this, (LiteralNode)agInstance);
        }
        if (agInstance instanceof DefaultGraph) {
            return null;
        }
        throw new IllegalArgumentException("Cannot coerce to Sesame Part " + agInstance);
    }

    public BlankNode lookupBNode(BNode sb) {
        if (sb instanceof AGSailBlankNodeImpl) {
            AGSailBlankNodeImpl bn = (AGSailBlankNodeImpl)sb;
            return (BlankNode)bn.getDirectInstance();
        }
        BlankNode agb = null;
        if (sb != null) {
            agb = this.sailToAG.get(sb);
        }
        if (agb != null) {
            return agb;
        }
        agb = this.directInstance.createBNode();
        if (sb == null) {
            sb = AGSailFactory.makeBlankNode((AGForSail)this, agb);
        }
        this.agToSail.put(agb.queryAGId(), sb);
        this.sailToAG.put(sb, agb);
        return agb;
    }

    public BNode registerBlankNode(BlankNode agb, BNode sb) {
        BNode old = this.agToSail.get(agb.queryAGId());
        if (old != null) {
            return old;
        }
        old = sb == null ? AGSailFactory.makeBlankNode((AGForSail)this, agb) : sb;
        this.agToSail.put(agb.queryAGId(), old);
        this.sailToAG.put(old, agb);
        return old;
    }
}

