/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.util;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.BlankNode;
import com.franz.agbase.DefaultGraph;
import com.franz.agbase.NamespaceRegistry;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.DefaultGraphImpl;
import com.franz.agbase.impl.EncodedLiteralImpl;
import com.franz.agbase.impl.LiteralNodeImpl;
import com.franz.agbase.impl.NamedAttributeList;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.URINodeImpl;
import com.franz.agbase.impl.ValueNodeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import java.util.ArrayList;

public class AGInternals
extends AGBase {
    public AllegroGraphConnection ags = null;
    private static final Object[] accessOptions = new Object[]{"expected-unique-resources", Long.class, "with-indices", String[].class, "include-standard-parts", Boolean.class, "read-only", Boolean.class, "indirect-host", String.class, "indirect-port", Integer.class, "read-only-p", Boolean.class};
    public NamedAttributeList accOpts = new NamedAttributeList(accessOptions);
    protected NamespaceRegistry nsregs = null;
    public int defaultLookAhead = 0;
    private DefaultGraph dgraph = null;
    private ArrayList<Object> dgraphs = null;

    protected NamespaceRegistry nsregsInit() {
        if (this.nsregs == null) {
            this.nsregs = new NamespaceRegistry();
        }
        return this.nsregs;
    }

    public TriplesIterator emptyCursor() {
        return TriplesIteratorImpl.emptyCursor();
    }

    public AllegroGraphConnection getConnection() {
        return this.ags;
    }

    @Override
    public AGConnector verifyEnabled() {
        if (this.ags == null) {
            throw new IllegalStateException("AllegroGraph server is not set.");
        }
        return this.ags.getServer();
    }

    public void discardCursor(Object ref) throws AllegroGraphException {
        this.verifyEnabled().discardCursor(this, ref);
    }

    public ValueObject newValue(UPI id, int type, String val, String mod) {
        switch (type) {
            case 1: {
                return AGFactory.makeBlankNode((AllegroGraph)this, id, val);
            }
            case 2: {
                if (mod != null) {
                    val = val + mod;
                }
                return AGFactory.makeNode((AllegroGraph)this, id, val);
            }
            case 3: {
                return AGFactory.makeLiteral((AllegroGraph)this, id, val, null, null, LiteralNodeImpl.LANG_NONE, null);
            }
            case 4: {
                return AGFactory.makeLiteral((AllegroGraph)this, id, val, null, null, LiteralNodeImpl.LANG_KNOWN, mod);
            }
            case 5: {
                return AGFactory.makeLiteral((AllegroGraph)this, id, val, null, mod, LiteralNodeImpl.LANG_NONE, null);
            }
            case 6: {
                long idn;
                if (id instanceof UPIImpl && (idn = ((UPIImpl)id).getCode()) > -1L) {
                    return AGFactory.makeTriple((AllegroGraph)this, idn, null, null, null);
                }
            }
            case 7: {
                return this.getDefaultGraph(id);
            }
            case 8: {
                ValueNodeImpl newInstance = (ValueNodeImpl)((Object)AGFactory.makeEncodedLiteral((AllegroGraph)this, val, mod));
                newInstance.nodeUPI = id;
                return newInstance;
            }
            case 9: {
                ValueNodeImpl newInstance = (ValueNodeImpl)((Object)AGFactory.makeEncodedLiteral((AllegroGraph)this, Long.parseLong(val), mod));
                newInstance.nodeUPI = id;
                return newInstance;
            }
            case 10: {
                ValueNodeImpl newInstance = (ValueNodeImpl)((Object)AGFactory.makeEncodedLiteral((AllegroGraph)this, Double.parseDouble(val), mod));
                newInstance.nodeUPI = id;
                return newInstance;
            }
        }
        throw new IllegalArgumentException("Unknown node type " + type + "  " + val + "  " + mod);
    }

    public synchronized DefaultGraph getDefaultGraph(UPI id) {
        DefaultGraph temp;
        if (id == null) {
            return null;
        }
        if (null == this.dgraphs) {
            if (null == this.dgraph) {
                this.dgraph = AGFactory.makeDefaultGraph((AllegroGraph)this, id);
                return this.dgraph;
            }
            if (id.equals(((DefaultGraphImpl)this.dgraph).nodeUPI)) {
                return this.dgraph;
            }
            this.dgraphs = new ArrayList();
            this.dgraphs.add(this.dgraph);
            this.dgraph = null;
            DefaultGraph temp2 = AGFactory.makeDefaultGraph((AllegroGraph)this, id);
            this.dgraphs.add(temp2);
            return temp2;
        }
        for (int i = 0; i < this.dgraphs.size(); ++i) {
            temp = (DefaultGraphImpl)this.dgraphs.get(i);
            if (!id.equals(((DefaultGraphImpl)temp).nodeUPI)) continue;
            return temp;
        }
        temp = AGFactory.makeDefaultGraph((AllegroGraph)this, id);
        this.dgraphs.add(temp);
        return temp;
    }

    public synchronized boolean isDefaultGraph(UPI id) {
        if (id == null) {
            return false;
        }
        if (null == this.dgraphs) {
            if (null == this.dgraph) {
                return false;
            }
            return id.equals(((DefaultGraphImpl)this.dgraph).nodeUPI);
        }
        for (int i = 0; i < this.dgraphs.size(); ++i) {
            DefaultGraphImpl temp = (DefaultGraphImpl)this.dgraphs.get(i);
            if (!id.equals(temp.nodeUPI)) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultGraph(ValueNode x) {
        if (x instanceof DefaultGraphImpl) {
            return this.isDefaultGraph(((ValueNodeImpl)x).nodeUPI);
        }
        return false;
    }

    public boolean isDefaultGraph(int type) {
        return type == 7;
    }

    public void getPartsInternal(UPI[] ids, int[] tnums, String[] vals, String[] mods) throws AllegroGraphException {
        this.verifyEnabled().getParts(this, ids, tnums, vals, mods);
    }

    public static String refEncToString(EncodedLiteralImpl v) {
        UPI u = v.queryAGId();
        if (null != u && UPIImpl.canReference(u)) {
            return AGInternals.refUPIToString(u);
        }
        return "%E" + v.encoding + ";" + v.stringValue();
    }

    public UPI queryAGId(ValueNode x) {
        if (x == null) {
            return null;
        }
        return x.queryAGId();
    }

    public static String refValueToString(ValueNode node) {
        if (node instanceof ValueNodeImpl) {
            ValueNodeImpl nd = (ValueNodeImpl)node;
            UPI n = nd.queryAGId();
            if (UPIImpl.canReference(n)) {
                UPIImpl nn = (UPIImpl)n;
                if (UPIImpl.isNullContext(n)) {
                    return "-2";
                }
                if (nn.isWild()) {
                    return "-1";
                }
                return "" + nn.asChars("%Z");
            }
            if (nd instanceof URINodeImpl) {
                return AGInternals.refNodeToString(((URINode)((Object)nd)).queryURI());
            }
            if (nd instanceof BlankNode) {
                return AGInternals.refAnonToString(((BlankNode)((Object)nd)).getID());
            }
            if (node instanceof LiteralNodeImpl) {
                String lang;
                LiteralNodeImpl lt = (LiteralNodeImpl)nd;
                String label = lt.queryLabel();
                if (label == null) {
                    AGInternals.notValRef(node);
                }
                if ((lang = lt.queryLanguage()) != null) {
                    return AGInternals.refLitToString(label, lang, null);
                }
                String type = lt.queryType();
                if (type != null) {
                    return AGInternals.refLitToString(label, null, type);
                }
                UPI tid = lt.typeId;
                if (tid == null) {
                    return AGInternals.refLitToString(label, null, null);
                }
                if (UPIImpl.canReference(tid)) {
                    return AGInternals.refLitToString(label, tid);
                }
                AGInternals.notValRef(node);
            } else {
                if (node instanceof DefaultGraphImpl) {
                    return "";
                }
                AGInternals.notValRef(node);
            }
        }
        AGInternals.notValRef(node);
        return "";
    }

    public String refToString(Object node) {
        if (node instanceof UPIImpl) {
            return AGInternals.refUPIToString((UPIImpl)node);
        }
        if (node instanceof EncodedLiteralImpl) {
            return AGInternals.refEncToString((EncodedLiteralImpl)node);
        }
        if (node instanceof ValueNode) {
            return AGInternals.refValueToString((ValueNode)node);
        }
        if (node instanceof String) {
            return AGInternals.refNtripleString((String)node);
        }
        throw new IllegalArgumentException("Cannot map this object to a Value ref" + node);
    }

    private static Object validRefEnc(EncodedLiteralImpl x) {
        UPI u = x.queryAGId();
        if (null != u && UPIImpl.canReference(u)) {
            return AGInternals.validUPI(u);
        }
        return AGInternals.refEncToString(x);
    }

    public static Object validRefOb(Object x) {
        if (x instanceof UPIImpl) {
            return AGInternals.validUPI((UPIImpl)x);
        }
        if (x instanceof EncodedLiteralImpl) {
            return AGInternals.validRefEnc((EncodedLiteralImpl)x);
        }
        if (x instanceof ValueNode) {
            return AGInternals.refValueToString((ValueNode)x);
        }
        if (x instanceof String) {
            return AGInternals.refNtripleString((String)x);
        }
        throw new IllegalArgumentException("Not a valid part reference: " + x);
    }

    public Object validRef(Object x) {
        return AGInternals.validRefOb(x);
    }

    public static Object validRefOb(Object x, Object ifNull) {
        if (x == null) {
            return ifNull;
        }
        if (x instanceof UPIImpl && ((UPIImpl)x).isWild()) {
            return ifNull;
        }
        return AGInternals.validRefOb(x);
    }

    public Object validRef(Object x, Object ifNull) {
        return AGInternals.validRefOb(x, ifNull);
    }

    public static Object validRefOrWild(Object x) {
        return AGInternals.validRefOb(x, UPIImpl.wildUPI());
    }

    private String[] validRefObjects(Object[] nodes) {
        String[] v = new String[nodes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.refToString(nodes[i]);
        }
        return v;
    }

    public static Object validRangeRef(Object ref) {
        Object v = AGInternals.minMaxRef(ref);
        if (v != null) {
            return v;
        }
        return AGInternals.validRefOrWild(ref);
    }

    private String[] validRefValues(ValueNode[] nodes) {
        String[] v = new String[nodes.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.refToString(nodes[i]);
        }
        return v;
    }

    public Object validRefsOrWild(Object nodes) {
        if (nodes == null) {
            return null;
        }
        return this.validRefs(nodes);
    }

    public Object validRefs(Object nodes) {
        if (nodes instanceof String) {
            return this.refToString(nodes);
        }
        if (nodes instanceof ValueNode) {
            return this.refToString(nodes);
        }
        if (nodes instanceof UPIImpl) {
            return nodes;
        }
        if (nodes instanceof ValueNode[]) {
            return this.validRefValues((ValueNode[])nodes);
        }
        if (nodes instanceof String[]) {
            return this.validRefStrings((String[])nodes);
        }
        if (nodes instanceof UPI[]) {
            return nodes;
        }
        if (nodes instanceof Object[]) {
            return this.validRefObjects((Object[])nodes);
        }
        throw new IllegalArgumentException("Cannot map this object to a Value ref or array " + nodes);
    }

    public static Object anyContextRef(Object x, int wildok) throws AllegroGraphException {
        if (x == null) {
            switch (wildok) {
                case 1: {
                    return UPIImpl.nullUPI();
                }
                case 2: 
                case 3: 
                case 5: {
                    return UPIImpl.wildUPI();
                }
                case 4: 
                case 6: {
                    return null;
                }
            }
            throw new AllegroGraphException("Null is not a valid context");
        }
        if ("".equals(x)) {
            switch (wildok) {
                case 1: 
                case 3: 
                case 5: {
                    return UPIImpl.nullUPI();
                }
            }
            throw new AllegroGraphException("\"\" is not a valid context");
        }
        switch (wildok) {
            case 5: 
            case 6: {
                Object v = AGInternals.minMaxRef(x);
                if (v == null) break;
                return v;
            }
        }
        return AGInternals.validRefOb(x);
    }

    private UPI[] anyContextUPIs(UPI[] x, int wildok) throws AllegroGraphException {
        UPI[] y = new UPI[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (UPI)AGInternals.anyContextRef(x[i], wildok);
        }
        return y;
    }

    private String[] anyContextStrings(String[] x, int wildok) throws AllegroGraphException {
        String[] y = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (String)AGInternals.anyContextRef(x[i], wildok);
        }
        return y;
    }

    private String[] anyContextValues(ValueNode[] x, int wildok) throws AllegroGraphException {
        String[] y = new String[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (String)AGInternals.anyContextRef(x[i], wildok);
        }
        return y;
    }

    public Object anyContextRefs(Object x, int wildok) throws AllegroGraphException {
        if (x instanceof UPI[]) {
            return this.anyContextUPIs((UPI[])x, wildok);
        }
        if (x instanceof String[]) {
            return this.anyContextStrings((String[])x, wildok);
        }
        if (x instanceof ValueNode[]) {
            return this.anyContextValues((ValueNode[])x, wildok);
        }
        return AGInternals.anyContextRef(x, wildok);
    }

    public synchronized void discardOldTokens(boolean force) throws AllegroGraphException {
        if (this.ags == null) {
            return;
        }
        if (this.ags.oldTokens.size() < this.ags.oldBatch) {
            return;
        }
        int n = this.ags.oldTokens.size();
        if (n >= this.ags.oldBatch) {
            n = this.ags.oldBatch;
        } else if (!force) {
            return;
        }
        Object[] r = new Object[n];
        for (int i = 0; i < n; ++i) {
            r[i] = this.ags.oldTokens.remove(0);
        }
        this.verifyEnabled().discardCursors(this, r);
    }

    public Object selectNull(boolean one) {
        if (one) {
            return new ValueObject[0];
        }
        return new ValueObject[0][0];
    }

    public ValueObject newSelectValue(boolean nullOk, UPIImpl id, int type, String label, String mod) {
        if (type > 0) {
            return this.newValue(id, type, label, mod);
        }
        if (nullOk) {
            return null;
        }
        throw new IllegalArgumentException("Unknown node type " + type + "  " + label + "  " + mod);
    }

    public void connect(AllegroGraphConnection conn, String key) throws AllegroGraphException {
        if (this.ags != null) {
            throw new IllegalStateException("Allready connected");
        }
        this.ags = conn;
        this.connect(key);
    }

    public void connect(String key) throws AllegroGraphException {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.tsx = this.verifyEnabled().access(key, this.storeName, this.storeDirectory, this.accOpts.getList());
        this.ags.addTS(this);
        this.initNamespaces();
    }

    public void initNamespaces() throws AllegroGraphException {
        if (this.nsregs == null) {
            this.nsregs = this.ags.nsregs;
        }
        if (this.nsregs != null) {
            this.verifyEnabled().namespaces(this, this.nsregs.toArray());
        }
    }

    protected static class valueMapEntry {
        Object savedToken;
        public int savedMore;
        AllegroGraph savedAG;
        Object savedVal = null;
        int savedPlimit;
        boolean savedNullOk;

        public valueMapEntry(AllegroGraph ag, Object token, int more, int pl, Object sv, boolean nullOk) {
            this.savedToken = token;
            this.savedMore = more;
            this.savedAG = ag;
            this.savedPlimit = pl;
            this.savedVal = sv;
            this.savedNullOk = nullOk;
        }

        protected synchronized void finalize() throws Throwable {
            if (this.savedAG.ags == null) {
                return;
            }
            if (null != this.savedToken) {
                this.savedAG.ags.oldTokens.add(this.savedToken);
            }
        }
    }
}

