/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.ag.UPI;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.TripleImpl;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.ValueNodeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.transport.AGDirectLink;
import com.franz.agbase.transport.AGDirectLinkDebug;
import com.franz.agbase.util.AGBase;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class AGDirectConnector
extends AGConnector {
    AGDirectLink trs = null;

    AGDirectLink verifyLink() {
        if (this.trs == null) {
            throw new IllegalStateException("Cannot use disabled link.");
        }
        return this.trs;
    }

    @Override
    public int transportVersion() {
        return 2;
    }

    Object tsApply0(AGBase ag, String fn, Object[] args) throws AllegroGraphException {
        AGDirectConnector.testIndex(ag);
        try {
            return this.verifyLink().sendOp3n(":call", 1, 0, "db.agraph.servers::ag-apply", ag.tsx, fn, args);
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
    }

    Object[] tsApplyA(AGBase ag, String fn, Object[] args) throws AllegroGraphException {
        AGDirectConnector.testIndex(ag);
        try {
            return (Object[])this.verifyLink().sendOp3n(":call", 1, -1, "db.agraph.servers::ag-apply", ag.tsx, fn, args);
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
    }

    Object[] applyA(String fn, Object[] args) throws AllegroGraphException {
        try {
            return (Object[])this.verifyLink().sendOp1n(":call", 1, -1, fn, args);
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
    }

    int intValue(Object r) {
        if (r instanceof Long) {
            return (int)((Long)r).longValue();
        }
        if (r instanceof Integer) {
            return (Integer)r;
        }
        throw new IllegalArgumentException("Cannot convert to int " + r);
    }

    @Override
    int access(String createCode, String name, String dir) throws AllegroGraphException {
        return this.access(createCode, name, dir, new Object[0]);
    }

    @Override
    public int access(String createCode, String name, String dir, Object[] more) throws AllegroGraphException {
        Object r;
        Object[] args = new Object[3 + more.length];
        args[0] = createCode;
        args[1] = name;
        args[2] = dir;
        if (0 < more.length && !this.serverLevel(1)) {
            throw new IllegalStateException("Server level < 1");
        }
        for (int i = 0; i < more.length; ++i) {
            args[3 + i] = more[i];
        }
        try {
            r = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::ag-access-triple-store", args);
        }
        catch (IOException e) {
            String m = e.getMessage();
            int p = m.indexOf("AGErr");
            if (p < 0) {
                throw new AllegroGraphException(e);
            }
            throw new AllegroGraphException(m.substring(p));
        }
        return (int)AGConnector.longValue(r);
    }

    @Override
    public Object[] addTriple(AGBase ag, Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "ag-add-triple", new Object[]{s, p, o, c, "with-parts", new Integer(1), "sync", ag.sync ? "" : null});
        Object[] v = new Object[5];
        v[0] = new Long(AGConnector.longValue(r[2]));
        for (int i = 1; i < 5; ++i) {
            v[i] = r[i + 2];
        }
        return v;
    }

    @Override
    public Object[] addTriples(AGBase ag, Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-add-triples", new Object[]{s, p, o, c, "with-parts", new Integer(1), "sync", ag.sync ? "" : null});
        long[] ids = AGDirectConnector.longArray(v[2]);
        Object[] rr = new Object[]{ids, null, null, null, null};
        rr[1] = v[3];
        rr[2] = v[4];
        rr[3] = v[5];
        rr[4] = v[6];
        return rr;
    }

    @Override
    public boolean closeTripleStore(AGBase ag, boolean doClose) throws AllegroGraphException {
        return 1L == AGDirectConnector.longValue(this.tsApply0(ag, "ag-close", new Object[]{doClose ? "" : null}));
    }

    @Override
    public void delete(AGBase ag, Object s, Object p, Object o, Object c, boolean wildOk) throws AllegroGraphException {
        this.tsApply0(ag, "ag-delete", new Object[]{s, p, o, c, new Integer(wildOk ? 1 : 0)});
    }

    @Override
    public void disable() {
        try {
            this.verifyLink().disconnect();
            this.trs = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void discardCursor(AGBase ag, Object ref) throws AllegroGraphException {
        this.tsApply0(ag, "ag-discard-cursor", new Object[]{ref});
    }

    @Override
    public void discardCursors(AGBase ag, Object[] refs) throws AllegroGraphException {
        if (16000 < refs.length) {
            throw new AllegroGraphException("Too many arguments in call.");
        }
        this.tsApply0(ag, "ag-discard-cursor", refs);
    }

    @Override
    public void enable() throws IOException {
        if (this.trs != null) {
            return;
        }
        AGDirectLink.debug(this.debug);
        this.trs = this.debug > 0 ? new AGDirectLinkDebug(this.host, this.port, this.pollCount, this.pollInterval, this.timeout) : new AGDirectLink(this.host, this.port, this.pollCount, this.pollInterval, this.timeout);
    }

    @Override
    public boolean exists(String name, String directory) throws AllegroGraphException {
        Object r;
        try {
            r = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::ag-exists-p", new Object[]{name, directory});
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
        return 1L == AGConnector.longValue(r);
    }

    @Override
    public String getLangPart(AGBase ag, UPI id) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-get-node-parts", new Object[]{id});
        switch ((int)AGConnector.longValue(v[2])) {
            case 4: {
                if (4 >= v.length) break;
                return (String)v[4];
            }
        }
        return null;
    }

    @Override
    public Object[] getParts(AGBase ag, UPI id) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-get-node-parts", new Object[]{id});
        return new Object[]{new Integer((int)AGConnector.longValue(v[2])), (String)v[3], (String)v[4]};
    }

    @Override
    public void getParts(AGBase ag, UPI[] ids, int[] types, String[] vals, String[] mods) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-get-node-parts", new Object[]{ids});
        AGDirectConnector.copy(AGDirectConnector.intArray(v[2]), types);
        AGDirectConnector.copy(AGDirectConnector.stringArray(v[3]), vals);
        AGDirectConnector.copy(AGDirectConnector.stringArray(v[4]), mods);
    }

    @Override
    public String getTextPart(AGBase ag, UPI id) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-get-node-parts", new Object[]{id});
        switch ((int)AGConnector.longValue(v[2])) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                if (3 >= v.length) break;
                return (String)v[3];
            }
        }
        return null;
    }

    @Override
    public TriplesIterator getTriples(AllegroGraph ag, Object s, Object p, Object o, Object c, int lh) throws AllegroGraphException {
        Object[] v;
        if (lh < 1) {
            lh = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (v = this.tsApplyA(ag, "ag-get-triples", new Object[]{s, p, o, c, new Integer(lh), new Integer(1)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == v.length) {
            AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]));
        }
        return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]), (String[])v[4]);
    }

    @Override
    public TriplesIterator getInfTriples(AllegroGraph ag, Object s, Object p, Object o, Object c, int lh, boolean infer) throws AllegroGraphException {
        Object[] v;
        if (lh < 1) {
            lh = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (v = this.tsApplyA(ag, "ag-infer-triples", new Object[]{s, p, o, c, new Integer(lh), "infer", new Integer(infer ? 1 : 0)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        return AGFactory.makeCursor(ag, v[3], AGDirectConnector.toUPIArray(v[2]));
    }

    @Override
    public TriplesIterator getTriples(AllegroGraph ag, Object s, Object p, Object o, Object c, Object subend, Object predend, Object obend, Object cxend, int lh) throws AllegroGraphException {
        Object[] v;
        if (lh < 1) {
            lh = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (v = this.tsApplyA(ag, "ag-get-triple-range", new Object[]{s, p, o, c, subend, predend, obend, cxend, new Integer(lh), new Integer(1)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == v.length) {
            return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]));
        }
        return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]), (String[])v[4]);
    }

    @Override
    public Object getTriples(AllegroGraph ag, Object s, Object p, Object o, Object c, Object subend, Object predend, Object obend, Object cxend, int lh, Object[] options) throws AllegroGraphException {
        if (!this.serverLevel(8)) {
            throw new UnsupportedOperationException("AllegroGraph server is too old.");
        }
        Object[] args = new Object[9 + options.length];
        args[0] = s;
        args[1] = p;
        args[2] = o;
        args[3] = c;
        args[4] = subend;
        args[5] = predend;
        args[6] = obend;
        args[7] = cxend;
        args[8] = lh;
        for (int i = 0; i < options.length; ++i) {
            args[9 + i] = options[i];
        }
        Object[] v = this.tsApplyA(ag, "ag-get-triple-range", args);
        switch (lh) {
            case -1: {
                if (3 > v.length) {
                    return false;
                }
                return true;
            }
            case -5: 
            case -4: 
            case -3: {
                if (3 > v.length) {
                    return 0;
                }
                return AGDirectConnector.longValue(v[2]);
            }
        }
        if (4 > v.length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == v.length) {
            return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]));
        }
        return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]), (String[])v[4]);
    }

    @Override
    public TriplesIterator getInfTriples(AllegroGraph ag, Object s, Object p, Object o, Object c, Object subend, Object predend, Object obend, Object cxend, int lh, boolean infer) throws AllegroGraphException {
        Object[] v;
        if (lh < 1) {
            lh = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (v = this.tsApplyA(ag, "ag-infer-triple-range", new Object[]{s, p, o, c, subend, predend, obend, cxend, new Integer(lh), "infer", new Integer(infer ? 1 : 0)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        return AGFactory.makeCursor(ag, v[3], AGDirectConnector.toUPIArray(v[2]));
    }

    @Override
    public String getTypePart(AGBase ag, UPI id) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-get-node-parts", new Object[]{id});
        switch ((int)AGConnector.longValue(v[2])) {
            case 5: {
                if (4 >= v.length) break;
                return (String)v[4];
            }
        }
        return null;
    }

    @Override
    public boolean hasTriple(AGBase ag, Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-get-triples", new Object[]{s, p, o, c, new Integer(-1)});
        return 3 <= v.length;
    }

    @Override
    public boolean hasInfTriple(AGBase ag, Object s, Object p, Object o, Object c, boolean infer) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-infer-triples", new Object[]{s, p, o, c, new Integer(-1), "infer", new Integer(infer ? 1 : 0)});
        return 3 <= v.length;
    }

    @Override
    public void indexAll(AGBase ag, boolean wait) throws AllegroGraphException {
        this.tsApply0(ag, "ag-all", new Object[]{new Integer(wait ? 1 : 0)});
    }

    @Override
    public void indexTriples(AGBase ag, boolean wait) throws AllegroGraphException {
        this.tsApply0(ag, "ag-index", new Object[]{new Integer(wait ? 1 : 0)});
    }

    @Override
    public void indexStore(AGBase ag, boolean wait, Boolean all) throws AllegroGraphException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("wait");
        args.add(wait ? 1 : 0);
        args.add("index");
        args.add(all == null ? "merge" : (all != false ? "all" : "new"));
        this.tsApply0(ag, "ag-index", args.toArray());
    }

    @Override
    public long loadNTriples(AGBase ag, Object name, Object context, String from, Object[] place, Boolean save, String ext) throws AllegroGraphException {
        return this.loadNTriples(ag, name, context, from, place, save, ext, false);
    }

    @Override
    public long loadNTriples(AGBase ag, Object name, Object context, String from, Object[] place, Boolean save, String ext, boolean unzip) throws AllegroGraphException {
        Object[] r;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(name);
        args.add(context);
        args.add(from);
        Integer gt = null;
        if (null != save) {
            gt = save != false ? Integer.valueOf(8) : Integer.valueOf(4);
        }
        args.add(gt);
        if (null != ext) {
            args.add("external-format");
            args.add(ext);
        }
        if (unzip) {
            args.add("data-format");
            args.add("gzip");
        }
        if ((r = this.tsApplyA(ag, "ag-load", args.toArray())) == null) {
            return 0L;
        }
        if (4 > r.length) {
            return AGDirectConnector.longValue(r[2]);
        }
        if (place != null && 0 < place.length) {
            place[0] = r[3];
        }
        return AGDirectConnector.longValue(r[2]);
    }

    @Override
    public long loadRDF(AGBase ag, Object filePath, Object context, String baseURI, Object useRapper) throws AllegroGraphException {
        return this.loadRDF(ag, filePath, context, baseURI, useRapper, null, null);
    }

    @Override
    public long loadRDF(AGBase ag, Object filePath, Object context, String baseURI, Object useRapper, String from, Boolean save) throws AllegroGraphException {
        Object[] r;
        int gt;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(filePath);
        args.add(context);
        if (useRapper instanceof Boolean && !((Boolean)useRapper).booleanValue()) {
            useRapper = null;
        }
        int n = gt = null == useRapper ? 0 : 1;
        if (null != save) {
            gt += save != false ? 8 : 4;
        }
        args.add(gt);
        if (null != useRapper) {
            args.add("use-rapper-p");
            if (useRapper instanceof String) {
                args.add(useRapper);
            } else {
                args.add("");
            }
        }
        if (null != baseURI) {
            args.add("base-uri");
            args.add(baseURI);
        }
        if (null != from) {
            args.add("from-string");
            args.add(from);
        }
        if ((r = this.tsApplyA(ag, "ag-rdf", args.toArray())) == null) {
            return 0L;
        }
        if (2 < r.length) {
            return AGDirectConnector.longValue(r[2]);
        }
        return -1L;
    }

    @Override
    public UPIImpl newBlankNode(AGBase ag) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-new-node", new Object[0]);
        return AGDirectConnector.toUPI(v);
    }

    @Override
    public UPIImpl newBlankNode(AGBase ag, String name) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-new-node", new Object[]{name});
        return AGDirectConnector.toUPI(v);
    }

    @Override
    public UPIImpl[] newBlankNodes(AGBase ag, int n) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-new-node", new Object[]{new Integer(n)});
        return AGDirectConnector.toUPIArray(v);
    }

    @Override
    public UPIImpl newLiteral(AGBase ag, String text, String type, String lang) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-intern-lit", new Object[]{text, type, lang});
        return AGDirectConnector.toUPI(v);
    }

    @Override
    public UPIImpl newLiteral(AGBase ag, String text, UPI type, String lang) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-intern-lit", new Object[]{text, type, lang});
        return AGDirectConnector.toUPI(v);
    }

    @Override
    public UPIImpl[] newLiteral(AGBase ag, String[] text, String[] type, String[] lang) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-intern-lit", new Object[]{text, type, lang});
        return AGDirectConnector.toUPIArray(v);
    }

    @Override
    public UPIImpl newResource(AGBase ag, String uri) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-intern-res", new Object[]{uri});
        return AGDirectConnector.toUPI(v);
    }

    @Override
    public UPIImpl[] newResources(AGBase ag, String[] uri) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-intern-res", new Object[]{uri});
        return AGDirectConnector.toUPIArray(v);
    }

    @Override
    public UPIImpl[] nextCursor(AGBase ag, Object source, int lh) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-next", new Object[]{source, new Integer(lh)});
        if (3 > v.length) {
            return null;
        }
        return AGDirectConnector.toUPIArray(v[2]);
    }

    @Override
    public Object[] nextCursorAndParts(AGBase ag, Object source, int lh) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-next-with-parts", new Object[]{source, new Integer(lh)});
        if (4 > v.length) {
            return null;
        }
        return new Object[]{v[2], v[3]};
    }

    @Override
    public long numberOfTriples(AGBase ag) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-number", new Object[0]);
        return AGConnector.longValue(v);
    }

    @Override
    public int query() {
        if (this.trs == null) {
            return -1;
        }
        if (null == this.trs.softLock) {
            return 0;
        }
        return 1;
    }

    @Override
    public void syncTripleStore(AGBase ag) throws AllegroGraphException {
        this.tsApplyA(ag, "ag-sync", new Object[0]);
    }

    static String[] stringArray(Object x) {
        if (x == null) {
            return new String[0];
        }
        if (x instanceof String[]) {
            return (String[])x;
        }
        if (x instanceof String) {
            return new String[]{(String)x};
        }
        if (x instanceof Object[]) {
            Object[] y = (Object[])x;
            String[] r = new String[y.length];
            for (int i = 0; i < y.length; ++i) {
                Object e = y[i];
                r[i] = e == null ? null : (e instanceof String ? (String)e : "Coerced " + e.toString() + " to String");
            }
            return r;
        }
        if (x.getClass().isArray()) {
            int ln = Array.getLength(x);
            String[] r = new String[ln];
            for (int i = 0; i < ln; ++i) {
                Object e = Array.get(x, i);
                r[i] = e == null ? null : (e instanceof String ? (String)e : "Coerced " + e.toString() + " to String");
            }
            return r;
        }
        return new String[]{"Coerced " + x.toString() + " to String"};
    }

    @Override
    public TriplesIterator selectTriples(AllegroGraph ag, String query, Object preset, String pvar, int limit, boolean infer, boolean distinct) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-select-triples", new Object[]{query, new Integer(limit), "presets", preset, "pvars", pvar, "use-reasoner", new Boolean(infer), "distinct", new Boolean(distinct)});
        return AGFactory.makeCursor(ag, v[3], AGDirectConnector.toUPIArray(v[2]));
    }

    @Override
    public TriplesIterator selectTriples(AllegroGraph ag, String query, Object[] presets, String pvars, int limit, boolean infer, boolean distinct) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, "ag-select-triples", new Object[]{query, new Integer(limit), "presets", presets, "pvars", pvars, "use-reasoner", new Boolean(infer), "distinct", new Boolean(distinct)});
        return AGFactory.makeCursor(ag, v[3], AGDirectConnector.toUPIArray(v[2]));
    }

    @Override
    public Object[] selectValues(AGBase ag, String query, Object[] presets, String pvars, boolean infer, boolean distinct) throws AllegroGraphException {
        return this.selectValues(ag, query, presets, pvars, infer, distinct, null);
    }

    @Override
    public Object[] selectValues(AGBase ag, String query, Object[] presets, String pvars, boolean infer, boolean distinct, Object[] more) throws AllegroGraphException {
        Object inval;
        int i;
        Object[] iv;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(pvars);
        if (presets == null) {
            args.add(new String[0]);
        } else if (0 == presets.length) {
            args.add(new String[0]);
        } else if (presets[0] instanceof Long) {
            iv = new int[presets.length];
            for (i = 0; i < iv.length; ++i) {
                iv[i] = (int)((Long)presets[i]).longValue();
            }
            args.add(iv);
        } else if (presets[0] instanceof String) {
            iv = new String[presets.length];
            for (i = 0; i < iv.length; ++i) {
                inval = presets[i];
                iv[i] = (int)AGBase.refNtripleString((String)inval);
            }
            args.add(iv);
        } else if (presets[0] instanceof ValueNodeImpl) {
            iv = new UPI[presets.length];
            for (i = 0; i < iv.length; ++i) {
                inval = (ValueNodeImpl)presets[i];
                iv[i] = (int)((ValueNodeImpl)inval).getAGId();
            }
            args.add(iv);
        } else if (presets[0] instanceof TripleImpl) {
            iv = new int[presets.length];
            for (i = 0; i < iv.length; ++i) {
                inval = (Triple)presets[i];
                iv[i] = (int)inval.getAGId();
            }
            args.add(iv);
        } else {
            throw new IllegalArgumentException("presets object contains unsuitable type");
        }
        args.add(query);
        args.add(ag.selectLimit);
        args.add("use-reasoner");
        args.add(infer);
        args.add("distinct");
        args.add(distinct);
        if (more != null) {
            for (int i2 = 0; i2 < more.length; ++i2) {
                args.add(more[i2]);
            }
        }
        Object[] r = this.tsApplyA(ag, "ag-select-values", args.toArray());
        return this.valuesResults(r);
    }

    @Override
    public Object[] nextValuesArray(AGBase ag, Object source, int lh) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "ag-next", new Object[]{source, new Integer(lh)});
        return this.valuesResults(r);
    }

    Object[] valuesResults(Object[] r) {
        if (10 > r.length) {
            if (3 == r.length && AGDirectConnector.hasLongValue(r[2])) {
                return new Object[]{r[2]};
            }
            return null;
        }
        Object ex = null;
        if (10 < r.length) {
            ex = r[10];
        }
        Object ex2 = null;
        if (11 < r.length) {
            ex2 = r[11];
        }
        UPIImpl[] ids = AGDirectConnector.toUPIArray(r[2]);
        int[] types = AGDirectConnector.intArray(r[3]);
        String[] labels = AGDirectConnector.stringArray(r[4]);
        String[] mods = AGDirectConnector.stringArray(r[5]);
        int more = (int)AGConnector.longValue(r[6]);
        int width = (int)AGConnector.longValue(r[7]);
        Object token = r[8];
        int plimit = (int)AGConnector.longValue(r[9]);
        return new Object[]{ids, types, labels, mods, new Integer(more), new Integer(width), token, new Integer(plimit), ex, ex2};
    }

    @Override
    public void serverTrace(boolean onoff, String outFile) throws AllegroGraphException {
        String arg = outFile != null ? outFile : (onoff ? new Integer(1) : new Integer(0));
        try {
            this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-trace-int", new Object[]{arg});
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
    }

    @Override
    public void serverTrace(AGBase ag, boolean onoff, String outFile) throws AllegroGraphException {
        String arg = outFile != null ? outFile : (onoff ? new Integer(1) : new Integer(0));
        this.tsApply0(ag, "agj-trace-int", new Object[]{arg});
    }

    @Override
    public void serverTimers(AGBase ag, boolean onoff, boolean perStore) throws AllegroGraphException {
        int arg;
        int n = onoff ? (perStore ? 3 : 2) : (arg = 0);
        if (ag == null) {
            try {
                this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-trace-int", new Object[]{arg});
            }
            catch (IOException e) {
                throw new AllegroGraphException(e);
            }
            return;
        }
        this.tsApply0(ag, "agj-trace-int", new Object[]{arg});
    }

    @Override
    public long[] getTimers(AGBase ag) throws AllegroGraphException {
        return AGDirectConnector.longArray(this.serverOptionAll("timers", ag == null ? null : Integer.valueOf(ag.tsx)));
    }

    @Override
    public long serverId() throws AllegroGraphException {
        try {
            Object r = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::agj-trace-int", new Object[]{new Integer(-2)});
            return AGConnector.longValue(r);
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
    }

    @Override
    public int interruptServer(long id) throws AllegroGraphException {
        if (id < 101L) {
            return -4;
        }
        try {
            Object r = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::agj-trace-int", new Object[]{new Long(id)});
            return AGConnector.toInt(r);
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
    }

    @Override
    public boolean serverLevel(int level) throws AllegroGraphException {
        if (this.currentServerLevel < 0) {
            this.getVersion();
        }
        return level <= this.currentServerLevel;
    }

    @Override
    public String getVersion() throws AllegroGraphException {
        if (this.serverVersions == null) {
            try {
                Object r = this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-trace-int", new Object[]{new Integer(100)});
                if (!(r instanceof Object[])) {
                    throw new AllegroGraphException("Unknown server level.");
                }
                Object[] ra = (Object[])r;
                this.serverVersions = new Object[ra.length - 2];
                for (int i = 0; i < this.serverVersions.length; ++i) {
                    this.serverVersions[i] = ra[i + 2];
                }
                this.currentServerLevel = (int)AGConnector.longValue(ra[2]);
            }
            catch (IOException e) {
                throw new AllegroGraphException(e);
            }
        }
        String s = "";
        for (int i = 0; i < this.serverVersions.length; ++i) {
            s = s + this.serverVersions[i] + " ";
        }
        return s;
    }

    Object[] valuesOnly(Object[] r) {
        Object[] s = new Object[r.length - 2];
        for (int i = 0; i < s.length; ++i) {
            s[i] = r[i + 2];
        }
        return s;
    }

    @Override
    public Object[] evalInServer(AGBase ag, String expression) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "agj-eval", new Object[]{expression});
        return this.valuesOnly(r);
    }

    @Override
    public Object[] evalInServer(String expression) throws AllegroGraphException {
        Object v;
        try {
            v = this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-eval", new Object[]{expression});
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
        return this.valuesOnly((Object[])v);
    }

    @Override
    public UPIImpl[] getTripleParts(AGBase ag, long id) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "ag-get-triple-parts", new Object[]{new Long(id)});
        if (6 > r.length) {
            return null;
        }
        return new UPIImpl[]{AGDirectConnector.toUPI(r[2]), AGDirectConnector.toUPI(r[3]), AGDirectConnector.toUPI(r[4]), AGDirectConnector.toUPI(r[5])};
    }

    @Override
    public boolean twinqlAsk(AGBase ag, String query, boolean infer) throws AllegroGraphException {
        return this.twinqlAsk(ag, query, infer, null);
    }

    @Override
    public boolean twinqlAsk(AGBase ag, String query, boolean infer, Object[] more) throws AllegroGraphException {
        int ml = null == more ? 0 : more.length;
        Object[] args = new Object[3 + ml];
        args[0] = query;
        args[1] = "use-reasoner";
        args[2] = new Boolean(infer);
        for (int i = 0; i < ml; ++i) {
            args[3 + i] = more[i];
        }
        Object r = this.tsApply0(ag, "ag-twinql-ask", args);
        return 1L == AGConnector.longValue(r);
    }

    @Override
    public Object[] twinqlSelect(AGBase ag, String query, String vars, int limit, int offset, int slimit, boolean infer) throws AllegroGraphException {
        return this.twinqlSelect(ag, query, vars, limit, offset, slimit, infer, null);
    }

    @Override
    public Object[] twinqlSelect(AGBase ag, String query, String vars, int limit, int offset, int slimit, boolean infer, Object[] more) throws AllegroGraphException {
        int ml = null == more ? 0 : more.length;
        Object[] args = new Object[8 + ml];
        args[0] = query;
        args[1] = vars;
        args[2] = new Integer(limit);
        args[3] = new Integer(offset);
        args[4] = "slimit";
        args[5] = new Integer(slimit);
        args[6] = "use-reasoner";
        args[7] = new Boolean(infer);
        for (int i = 0; i < ml; ++i) {
            args[8 + i] = more[i];
        }
        Object[] r = this.tsApplyA(ag, "ag-twinql-select", args);
        if (slimit == -1) {
            return this.valuesOnly(r);
        }
        return this.valuesResults(r);
    }

    @Override
    public TriplesIterator twinqlFind(AllegroGraph ag, String query, int limit, int offset, int slimit, boolean infer) throws AllegroGraphException {
        return this.twinqlFind(ag, query, limit, offset, slimit, infer, null);
    }

    @Override
    public TriplesIterator twinqlFind(AllegroGraph ag, String query, int limit, int offset, int slimit, boolean infer, Object[] more) throws AllegroGraphException {
        return this.twinqlFindTriples("ag-twinql-find", ag, query, limit, offset, slimit, infer, more);
    }

    @Override
    public TriplesIterator twinqlConstruct(AllegroGraph ag, String query, int limit, int offset, int slimit, boolean infer, Object[] more) throws AllegroGraphException {
        return this.twinqlFindTriples("ag-twinql-construct", ag, query, limit, offset, slimit, infer, more);
    }

    @Override
    public TriplesIterator twinqlDescribe(AllegroGraph ag, String query, int limit, int offset, int slimit, boolean infer, Object[] more) throws AllegroGraphException {
        return this.twinqlFindTriples("ag-twinql-describe", ag, query, limit, offset, slimit, infer, more);
    }

    TriplesIterator twinqlFindTriples(String finder, AllegroGraph ag, String query, int limit, int offset, int slimit, boolean infer, Object[] more) throws AllegroGraphException {
        int ml = null == more ? 0 : more.length;
        Object[] args = new Object[7 + ml];
        args[0] = query;
        args[1] = new Integer(limit);
        args[2] = new Integer(offset);
        args[3] = "slimit";
        args[4] = new Integer(slimit);
        args[5] = "use-reasoner";
        args[6] = new Boolean(infer);
        for (int i = 0; i < ml; ++i) {
            args[7 + i] = more[i];
        }
        Object[] v = this.tsApplyA(ag, finder, args);
        String token = null;
        if (3 < v.length) {
            token = (String)v[3];
        }
        return AGFactory.makeCursor(ag, token, AGDirectConnector.toUPIArray(v[2]));
    }

    @Override
    public String twinqlQuery(AGBase ag, String query, String format, int limit, int offset, boolean infer) throws AllegroGraphException {
        return this.twinqlQuery(ag, query, format, limit, offset, infer, null);
    }

    @Override
    public String twinqlQuery(AGBase ag, String query, String format, int limit, int offset, boolean infer, Object[] more) throws AllegroGraphException {
        int ml = null == more ? 0 : more.length;
        Object[] args = new Object[6 + ml];
        args[0] = query;
        args[1] = format;
        args[2] = new Integer(limit);
        args[3] = new Integer(offset);
        args[4] = "use-reasoner";
        args[5] = new Boolean(infer);
        for (int i = 0; i < ml; ++i) {
            args[6 + i] = more[i];
        }
        Object r = this.tsApply0(ag, "ag-twinql-query", args);
        return (String)r;
    }

    @Override
    public Object indexing(AGBase ag, int mode, int value, String[] flavors) throws AllegroGraphException {
        return this.tsApply0(ag, "ag-indexing", new Object[]{new Integer(mode), new Integer(value), flavors});
    }

    @Override
    public Object mapping(AGBase ag, int mode, String[] map) throws AllegroGraphException {
        return this.tsApply0(ag, "ag-mapping", new Object[]{new Integer(mode), map});
    }

    @Override
    public String[] namespaces(AGBase ag, String[] map) throws AllegroGraphException {
        Object r = this.tsApply0(ag, "agj-namespaces", new Object[]{map});
        String[] rs = AGDirectConnector.stringArray(r);
        return rs;
    }

    @Override
    public Object[] addPart(AGBase ag, String part) throws AllegroGraphException {
        if (this.serverLevel(2)) {
            Object[] v = this.tsApplyA(ag, "ag-add-part", new Object[]{part});
            return this.valuesOnly(v);
        }
        throw new IllegalStateException("Server does not support addPart()");
    }

    @Override
    public String[] freetextPredicates(AGBase ag, Object defs) throws AllegroGraphException {
        Object v = this.tsApply0(ag, "ag-freetext-predicates", new Object[]{defs});
        if (v instanceof String[]) {
            return (String[])v;
        }
        return new String[0];
    }

    @Override
    public TriplesIterator getFreetextStatements(AllegroGraph ag, String pattern, int lh) throws AllegroGraphException {
        if (lh == 0) {
            lh = TriplesIteratorImpl.defaultLookAhead;
        }
        Object[] v = this.tsApplyA(ag, "ag-freetext-statements", new Object[]{pattern, new Integer(lh), new Integer(1)});
        if (lh < 0) {
            if (2 == v.length) {
                return null;
            }
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 > v.length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == v.length) {
            return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]));
        }
        return AGFactory.makeCursor(ag, v[2], AGDirectConnector.toUPIArray(v[3]), (String[])v[4]);
    }

    @Override
    public Object[] getFreetextSubjects(AGBase ag, String pattern, int limit) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "ag-freetext-subjects", new Object[]{pattern, new Integer(limit)});
        return this.valuesResults(r);
    }

    @Override
    public int federate(String name, int[] parts, boolean supersede) throws AllegroGraphException {
        Object r;
        try {
            r = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::ag-federate", new Object[]{name, parts, "if-exists", supersede ? "supersede" : null});
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
        return (int)AGDirectConnector.longValue(r);
    }

    @Override
    public Object[] findStore(String name, String directory, Object delete) throws AllegroGraphException {
        Object r;
        try {
            r = this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::ag-find-store", new Object[]{name, directory, null, delete == null ? "ignore" : "delete", delete == null ? null : "delete"});
        }
        catch (IOException e) {
            throw new AllegroGraphException(e);
        }
        Object[] ra = (Object[])r;
        if (5 > ra.length) {
            return null;
        }
        return new Object[]{new Integer((int)AGDirectConnector.longValue(ra[2])), ra[3], ra[4]};
    }

    @Override
    public Object[] getStores(AGBase ag) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "ag-get-stores", new Object[0]);
        if (3 == r.length) {
            return null;
        }
        Object[] ra = new Object[r.length - 2];
        for (int i = 0; i < ra.length; ++i) {
            ra[i] = 0 == i % 3 ? new Integer((int)AGDirectConnector.longValue(r[i + 2])) : r[i + 2];
        }
        return ra;
    }

    @Override
    public Object serializeTriples(AGBase ag, Object[] args) throws AllegroGraphException {
        Object[] r = this.tsApplyA(ag, "ag-serialize-triples", args);
        if (2 < r.length) {
            return r[2];
        }
        return null;
    }

    @Override
    public Object[] applyAGFn(AGBase ag, String fn, Object[] args) throws AllegroGraphException {
        Object[] v = this.tsApplyA(ag, fn, args);
        if (null == v) {
            return new Object[0];
        }
        if (3 > v.length) {
            return new Object[0];
        }
        Object[] w = new Object[v.length - 2];
        for (int i = 0; i < w.length; ++i) {
            w[i] = v[i + 2];
        }
        return w;
    }

    @Override
    public Object[] applyFn(String fn, Object[] args) throws AllegroGraphException {
        Object[] v = this.applyA(fn, args);
        if (null == v) {
            return new Object[0];
        }
        if (3 > v.length) {
            return new Object[0];
        }
        Object[] w = new Object[v.length - 2];
        for (int i = 0; i < w.length; ++i) {
            w[i] = v[i + 2];
        }
        return w;
    }

    @Override
    public Object serverOptionOne(Object ... args) throws AllegroGraphException {
        Object[] v = this.applyA("db.agraph.servers::agj-server-options", args);
        if (null == v) {
            return null;
        }
        if (3 > v.length) {
            return null;
        }
        return v[2];
    }

    @Override
    public Object serverOptionAll(Object ... args) throws AllegroGraphException {
        return this.applyFn("db.agraph.servers::agj-server-options", args);
    }

    @Override
    public Object[] clientOption(AGBase ag, Object ... more) throws AllegroGraphException {
        return this.applyAGFn(ag, "ag-client-options", more);
    }
}

