/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.ag.UPI;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.transport.AGDirectConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGC;
import java.io.IOException;
import java.lang.reflect.Array;

public abstract class AGConnector
extends AGC {
    boolean connected = false;
    int port = 3456;
    int jport = -3457;
    String host = "";
    int pollCount = 3;
    int pollInterval = 1000;
    int timeout = 5000;
    int debug = 0;
    int currentServerLevel = -1;
    Object[] serverVersions = null;

    public abstract String getVersion() throws AllegroGraphException;

    public void init(int port, int port2, String host, int pollCount, int pollInterval, int debug, int timeout) {
        this.port = port;
        if (port2 < 0) {
            this.jport = port2;
        } else if (port2 > 0) {
            this.jport = -port2;
        }
        this.host = host;
        this.pollCount = pollCount;
        this.pollInterval = pollInterval;
        this.debug = debug;
        this.timeout = timeout;
    }

    public static AGConnector createConnector(String mode) {
        if (mode == null) {
            mode = "";
        }
        if ("direct".equalsIgnoreCase(mode)) {
            return new AGDirectConnector();
        }
        throw new IllegalStateException("Unknown mode: " + mode);
    }

    static void copy(long[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            b[i] = (int)a[i];
        }
    }

    static void copy(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
    }

    static void copy(String[] a, String[] b) {
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
    }

    static void testIndex(AGBase ag) {
        if (ag.tsx < 0) {
            throw new IllegalStateException("Attempting to access closed AllegroGraph database.");
        }
    }

    public abstract int transportVersion();

    public abstract void enable() throws IOException;

    public abstract void disable();

    public abstract int query();

    abstract int access(String var1, String var2, String var3) throws AllegroGraphException;

    public abstract int access(String var1, String var2, String var3, Object[] var4) throws AllegroGraphException;

    public abstract boolean exists(String var1, String var2) throws AllegroGraphException;

    public abstract void syncTripleStore(AGBase var1) throws AllegroGraphException;

    public abstract boolean closeTripleStore(AGBase var1, boolean var2) throws AllegroGraphException;

    public abstract long loadNTriples(AGBase var1, Object var2, Object var3, String var4, Object[] var5, Boolean var6, String var7) throws AllegroGraphException;

    public abstract long loadNTriples(AGBase var1, Object var2, Object var3, String var4, Object[] var5, Boolean var6, String var7, boolean var8) throws AllegroGraphException;

    public abstract long loadRDF(AGBase var1, Object var2, Object var3, String var4, Object var5) throws AllegroGraphException;

    public abstract long loadRDF(AGBase var1, Object var2, Object var3, String var4, Object var5, String var6, Boolean var7) throws AllegroGraphException;

    public abstract long numberOfTriples(AGBase var1) throws AllegroGraphException;

    public abstract void indexTriples(AGBase var1, boolean var2) throws AllegroGraphException;

    public abstract void indexAll(AGBase var1, boolean var2) throws AllegroGraphException;

    public abstract void indexStore(AGBase var1, boolean var2, Boolean var3) throws AllegroGraphException;

    public abstract TriplesIterator getTriples(AllegroGraph var1, Object var2, Object var3, Object var4, Object var5, int var6) throws AllegroGraphException;

    public abstract TriplesIterator getTriples(AllegroGraph var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, int var10) throws AllegroGraphException;

    public abstract Object getTriples(AllegroGraph var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, int var10, Object[] var11) throws AllegroGraphException;

    public abstract TriplesIterator getInfTriples(AllegroGraph var1, Object var2, Object var3, Object var4, Object var5, int var6, boolean var7) throws AllegroGraphException;

    public abstract TriplesIterator getInfTriples(AllegroGraph var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, int var10, boolean var11) throws AllegroGraphException;

    public abstract TriplesIterator getFreetextStatements(AllegroGraph var1, String var2, int var3) throws AllegroGraphException;

    public abstract boolean hasTriple(AGBase var1, Object var2, Object var3, Object var4, Object var5) throws AllegroGraphException;

    public abstract boolean hasInfTriple(AGBase var1, Object var2, Object var3, Object var4, Object var5, boolean var6) throws AllegroGraphException;

    public abstract Object[] addTriple(AGBase var1, Object var2, Object var3, Object var4, Object var5) throws AllegroGraphException;

    public abstract Object[] addTriples(AGBase var1, Object var2, Object var3, Object var4, Object var5) throws AllegroGraphException;

    public abstract Object[] getParts(AGBase var1, UPI var2) throws AllegroGraphException;

    public abstract void getParts(AGBase var1, UPI[] var2, int[] var3, String[] var4, String[] var5) throws AllegroGraphException;

    public abstract String getTextPart(AGBase var1, UPI var2) throws AllegroGraphException;

    public abstract String getTypePart(AGBase var1, UPI var2) throws AllegroGraphException;

    public abstract String getLangPart(AGBase var1, UPI var2) throws AllegroGraphException;

    public abstract UPIImpl[] getTripleParts(AGBase var1, long var2) throws AllegroGraphException;

    public abstract UPIImpl newBlankNode(AGBase var1) throws AllegroGraphException;

    public abstract UPIImpl newBlankNode(AGBase var1, String var2) throws AllegroGraphException;

    public abstract UPIImpl[] newBlankNodes(AGBase var1, int var2) throws AllegroGraphException;

    public abstract UPIImpl newResource(AGBase var1, String var2) throws AllegroGraphException;

    public abstract UPIImpl[] newResources(AGBase var1, String[] var2) throws AllegroGraphException;

    public abstract UPIImpl newLiteral(AGBase var1, String var2, String var3, String var4) throws AllegroGraphException;

    public abstract UPIImpl newLiteral(AGBase var1, String var2, UPI var3, String var4) throws AllegroGraphException;

    public abstract UPIImpl[] newLiteral(AGBase var1, String[] var2, String[] var3, String[] var4) throws AllegroGraphException;

    public abstract UPIImpl[] nextCursor(AGBase var1, Object var2, int var3) throws AllegroGraphException;

    public abstract Object[] nextCursorAndParts(AGBase var1, Object var2, int var3) throws AllegroGraphException;

    public abstract Object[] nextValuesArray(AGBase var1, Object var2, int var3) throws AllegroGraphException;

    public abstract void delete(AGBase var1, Object var2, Object var3, Object var4, Object var5, boolean var6) throws AllegroGraphException;

    public abstract void discardCursor(AGBase var1, Object var2) throws AllegroGraphException;

    public abstract void discardCursors(AGBase var1, Object[] var2) throws AllegroGraphException;

    public abstract TriplesIterator selectTriples(AllegroGraph var1, String var2, Object var3, String var4, int var5, boolean var6, boolean var7) throws AllegroGraphException;

    public abstract TriplesIterator selectTriples(AllegroGraph var1, String var2, Object[] var3, String var4, int var5, boolean var6, boolean var7) throws AllegroGraphException;

    public abstract Object[] selectValues(AGBase var1, String var2, Object[] var3, String var4, boolean var5, boolean var6) throws AllegroGraphException;

    public abstract Object[] selectValues(AGBase var1, String var2, Object[] var3, String var4, boolean var5, boolean var6, Object[] var7) throws AllegroGraphException;

    public abstract Object[] getFreetextSubjects(AGBase var1, String var2, int var3) throws AllegroGraphException;

    public abstract String[] freetextPredicates(AGBase var1, Object var2) throws AllegroGraphException;

    public abstract void serverTrace(boolean var1, String var2) throws AllegroGraphException;

    public abstract boolean serverLevel(int var1) throws AllegroGraphException;

    public abstract void serverTrace(AGBase var1, boolean var2, String var3) throws AllegroGraphException;

    public abstract Object[] evalInServer(AGBase var1, String var2) throws AllegroGraphException;

    public abstract Object[] evalInServer(String var1) throws AllegroGraphException;

    public abstract long serverId() throws AllegroGraphException;

    public abstract int interruptServer(long var1) throws AllegroGraphException;

    public abstract boolean twinqlAsk(AGBase var1, String var2, boolean var3) throws AllegroGraphException;

    public abstract boolean twinqlAsk(AGBase var1, String var2, boolean var3, Object[] var4) throws AllegroGraphException;

    public abstract Object[] twinqlSelect(AGBase var1, String var2, String var3, int var4, int var5, int var6, boolean var7) throws AllegroGraphException;

    public abstract Object[] twinqlSelect(AGBase var1, String var2, String var3, int var4, int var5, int var6, boolean var7, Object[] var8) throws AllegroGraphException;

    public abstract TriplesIterator twinqlFind(AllegroGraph var1, String var2, int var3, int var4, int var5, boolean var6) throws AllegroGraphException;

    public abstract TriplesIterator twinqlFind(AllegroGraph var1, String var2, int var3, int var4, int var5, boolean var6, Object[] var7) throws AllegroGraphException;

    public abstract TriplesIterator twinqlConstruct(AllegroGraph var1, String var2, int var3, int var4, int var5, boolean var6, Object[] var7) throws AllegroGraphException;

    public abstract TriplesIterator twinqlDescribe(AllegroGraph var1, String var2, int var3, int var4, int var5, boolean var6, Object[] var7) throws AllegroGraphException;

    public abstract String twinqlQuery(AGBase var1, String var2, String var3, int var4, int var5, boolean var6) throws AllegroGraphException;

    public abstract String twinqlQuery(AGBase var1, String var2, String var3, int var4, int var5, boolean var6, Object[] var7) throws AllegroGraphException;

    public abstract Object indexing(AGBase var1, int var2, int var3, String[] var4) throws AllegroGraphException;

    public abstract Object mapping(AGBase var1, int var2, String[] var3) throws AllegroGraphException;

    public abstract String[] namespaces(AGBase var1, String[] var2) throws AllegroGraphException;

    public abstract Object[] addPart(AGBase var1, String var2) throws AllegroGraphException;

    public static int toInt(Object v) {
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Long) {
            return ((Long)v).intValue();
        }
        if (v instanceof Short) {
            return ((Short)v).intValue();
        }
        if (v instanceof Byte) {
            return ((Byte)v).intValue();
        }
        return 0;
    }

    public static long longValue(Object x) {
        if (x == null) {
            return 0L;
        }
        if (x instanceof Long) {
            return (Long)x;
        }
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof UPIImpl && !((UPIImpl)x).withLabel()) {
            return ((UPIImpl)x).getCode();
        }
        throw new IllegalArgumentException("Cannot get a long value from " + x);
    }

    public static boolean hasLongValue(Object x) {
        if (x == null) {
            return true;
        }
        if (x instanceof Long) {
            return true;
        }
        if (x instanceof Integer) {
            return true;
        }
        if (x instanceof Short) {
            return true;
        }
        if (x instanceof Byte) {
            return true;
        }
        return x instanceof UPIImpl && !((UPIImpl)x).withLabel();
    }

    public static double doubleValue(Object x) {
        if (x == null) {
            return 0.0;
        }
        if (x instanceof Double) {
            return (Double)x;
        }
        if (x instanceof Float) {
            return ((Float)x).doubleValue();
        }
        throw new IllegalArgumentException("Cannot get a double value from " + x);
    }

    static boolean isInteger(Object x) {
        if (x == null) {
            return true;
        }
        if (x instanceof Long) {
            return true;
        }
        if (x instanceof Integer) {
            return true;
        }
        if (x instanceof Short) {
            return true;
        }
        return x instanceof Byte;
    }

    static boolean canBeUPI(Object x) {
        if (x == null) {
            return false;
        }
        if (AGConnector.isInteger(x)) {
            return true;
        }
        return x instanceof UPIImpl;
    }

    protected static UPIImpl toUPI(Object x) {
        if (x == null) {
            return null;
        }
        if (AGConnector.isInteger(x)) {
            return new UPIImpl(AGConnector.longValue(x));
        }
        if (x instanceof UPIImpl) {
            return (UPIImpl)x;
        }
        throw new IllegalArgumentException("Cannot get a UPI value from " + x);
    }

    public static UPIImpl[] toUPIArray(Object x) {
        if (x == null) {
            return new UPIImpl[0];
        }
        if (AGConnector.canBeUPI(x)) {
            return new UPIImpl[]{AGConnector.toUPI(x)};
        }
        if (x instanceof UPIImpl[]) {
            return (UPIImpl[])x;
        }
        if (x.getClass().isArray()) {
            int ln = Array.getLength(x);
            UPIImpl[] r = new UPIImpl[ln];
            for (int i = 0; i < ln; ++i) {
                Object e = Array.get(x, i);
                r[i] = e == null ? null : AGConnector.toUPI(e);
            }
            return r;
        }
        throw new IllegalArgumentException("Cannot get a UPI[] value from " + x);
    }

    public static int[] intArray(Object x) {
        if (x == null) {
            return new int[0];
        }
        if (x instanceof int[]) {
            return (int[])x;
        }
        if (x instanceof long[]) {
            return AGConnector.copyToIntArray((long[])x);
        }
        if (x instanceof short[]) {
            return AGConnector.copyToIntArray((short[])x);
        }
        if (x instanceof byte[]) {
            return AGConnector.copyToIntArray((byte[])x);
        }
        if (x instanceof Object[]) {
            return AGConnector.copyToIntArray((Object[])x);
        }
        throw new IllegalArgumentException("Cannot get a int[] value from " + x);
    }

    public static long[] longArray(Object x) {
        if (x == null) {
            return new long[0];
        }
        if (x instanceof long[]) {
            return (long[])x;
        }
        if (x instanceof int[]) {
            return AGConnector.copyToLongArray((int[])x);
        }
        if (x instanceof short[]) {
            return AGConnector.copyToLongArray((short[])x);
        }
        if (x instanceof byte[]) {
            return AGConnector.copyToLongArray((byte[])x);
        }
        if (x instanceof Object[]) {
            return AGConnector.copyToLongArray((Object[])x);
        }
        throw new IllegalArgumentException("Cannot get a long[] value from " + x);
    }

    static int[] copyToIntArray(long[] x) {
        if (x == null) {
            return new int[0];
        }
        int[] y = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (int)x[i];
        }
        return y;
    }

    static int[] copyToIntArray(short[] x) {
        if (x == null) {
            return new int[0];
        }
        int[] y = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i];
        }
        return y;
    }

    static int[] copyToIntArray(byte[] x) {
        if (x == null) {
            return new int[0];
        }
        int[] y = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i];
        }
        return y;
    }

    static long[] copyToLongArray(int[] x) {
        if (x == null) {
            return new long[0];
        }
        long[] y = new long[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i];
        }
        return y;
    }

    static long[] copyToLongArray(short[] x) {
        if (x == null) {
            return new long[0];
        }
        long[] y = new long[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i];
        }
        return y;
    }

    static long[] copyToLongArray(byte[] x) {
        if (x == null) {
            return new long[0];
        }
        long[] y = new long[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i];
        }
        return y;
    }

    static long[] copyToLongArray(Object[] x) {
        if (x == null) {
            return new long[0];
        }
        long[] y = new long[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = AGConnector.longValue(x[i]);
        }
        return y;
    }

    static int[] copyToIntArray(Object[] x) {
        if (x == null) {
            return new int[0];
        }
        int[] y = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (int)AGConnector.longValue(x[i]);
        }
        return y;
    }

    public abstract int federate(String var1, int[] var2, boolean var3) throws AllegroGraphException;

    public abstract Object[] getStores(AGBase var1) throws AllegroGraphException;

    public abstract Object[] findStore(String var1, String var2, Object var3) throws AllegroGraphException;

    public abstract Object serializeTriples(AGBase var1, Object[] var2) throws AllegroGraphException;

    public abstract Object[] applyAGFn(AGBase var1, String var2, Object[] var3) throws AllegroGraphException;

    public abstract Object[] applyFn(String var1, Object[] var2) throws AllegroGraphException;

    public abstract Object serverOptionOne(Object ... var1) throws AllegroGraphException;

    public abstract Object serverOptionAll(Object ... var1) throws AllegroGraphException;

    public abstract Object[] clientOption(AGBase var1, Object ... var2) throws AllegroGraphException;

    public abstract void serverTimers(AGBase var1, boolean var2, boolean var3) throws AllegroGraphException;

    public abstract long[] getTimers(AGBase var1) throws AllegroGraphException;
}

