/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.ValueObject;
import com.franz.agbase.ValueSetIterator;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGInternals;
import java.util.NoSuchElementException;

public class ValueSetIteratorImpl
implements ValueSetIterator {
    public ValueObject[][] sets = null;
    private int index = -3;
    private ValueObject[] row = null;
    private AGInternals ag = null;
    private Object savedToken = null;
    private boolean nullOk = false;
    private int savedMore = 0;
    private int savedPlimit = 0;
    public Object savedExtra = null;

    public ValueSetIteratorImpl() {
    }

    public ValueSetIteratorImpl(AGBase ag, Object vv) {
        this();
        int all;
        if (vv == null) {
            return;
        }
        if (!(vv instanceof Object[])) {
            throw new IllegalArgumentException("Unexpected result " + vv);
        }
        Object[] v = (Object[])vv;
        UPIImpl[] ids = (UPIImpl[])v[0];
        if (ids == null) {
            return;
        }
        int[] types = (int[])v[1];
        String[] labels = (String[])v[2];
        String[] mods = (String[])v[3];
        int more = (Integer)v[4];
        int width = (Integer)v[5];
        Object token = v[6];
        int plimit = (Integer)v[7];
        Object sv = null;
        if (8 < v.length) {
            sv = v[8];
        }
        int n = all = ids.length;
        if (width > 0) {
            n = all / width;
        }
        ValueObject[][] r = new ValueObject[n][width];
        if (width > 0) {
            int i = 0;
            int j = 0;
            while (i < all) {
                for (int k = 0; k < width; ++k) {
                    r[j][k] = ((AGInternals)ag).newSelectValue(true, ids[i], types[i], labels[i], mods[i]);
                    ++i;
                }
                ++j;
            }
        }
        this.ag = (AGInternals)ag;
        this.sets = r;
        this.index = -1;
        this.row = null;
        this.nullOk = true;
        this.savedToken = token;
        this.savedMore = more;
        this.savedPlimit = plimit;
        this.savedExtra = sv;
    }

    @Override
    public boolean hasNext() {
        if (this.sets == null) {
            return false;
        }
        if (this.index < -2) {
            return false;
        }
        if (this.index == -2) {
            return this.savedMore > 0;
        }
        if (this.index + 1 < this.sets.length) {
            return true;
        }
        return this.savedMore > 0;
    }

    private boolean canUseIndex() {
        if (this.sets == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        return this.index < this.sets.length;
    }

    private boolean stepIndex() {
        if (this.sets == null) {
            return false;
        }
        if (this.index < -1) {
            return false;
        }
        ++this.index;
        if (this.index < this.sets.length) {
            return true;
        }
        this.index = -2;
        return false;
    }

    @Override
    public ValueObject[] next() {
        this.row = null;
        if (this.sets == null || this.index < -1) {
            throw new NoSuchElementException("Empty iterator.");
        }
        if (this.stepIndex()) {
            this.row = this.sets[this.index];
            return this.row;
        }
        if (this.savedMore > 0) {
            try {
                this.sets = this.selectMoreInternal(this.sets);
            }
            catch (AllegroGraphException e) {
                throw new NoSuchElementException("Server error " + e);
            }
            this.index = 0;
        }
        if (this.canUseIndex()) {
            this.row = this.sets[this.index];
            return this.row;
        }
        this.index = -4;
        throw new NoSuchElementException("Exhausted iterator.");
    }

    @Override
    public void remove() {
        this.row = null;
    }

    private ValueObject[][] selectMoreInternal(ValueObject[][] sets) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().nextValuesArray(this.ag, this.savedToken, this.ag.selectLimit);
        if (v == null) {
            return (ValueObject[][])this.ag.selectNull(false);
        }
        UPIImpl[] ids = (UPIImpl[])v[0];
        int[] types = (int[])v[1];
        String[] labels = (String[])v[2];
        String[] mods = (String[])v[3];
        int more = (Integer)v[4];
        int width = (Integer)v[5];
        String token = (String)v[6];
        int plimit = (Integer)v[7];
        int all = ids.length;
        int i = 0;
        this.savedMore = more;
        if (more > 0) {
            this.savedToken = token;
            this.savedPlimit = plimit;
        } else {
            this.ag.ags.oldTokens.add(token);
            token = null;
        }
        if (all == width * sets.length) {
            for (int j = 0; j < sets.length; ++j) {
                ValueObject[] row = new ValueObject[width];
                for (int k = 0; k < width; ++k) {
                    row[k] = this.ag.newSelectValue(this.nullOk, ids[i], types[i], labels[i], mods[i]);
                    ++i;
                }
                sets[j] = row;
            }
            return sets;
        }
        if (width == 0) {
            sets = new ValueObject[all][0];
        } else {
            int n = 0;
            n = all / width;
            i = 0;
            int j = 0;
            sets = new ValueObject[n][width];
            while (i < all) {
                for (int k = 0; k < width; ++k) {
                    sets[j][k] = this.ag.newSelectValue(this.nullOk, ids[i], types[i], labels[i], mods[i]);
                    ++i;
                }
                ++j;
            }
        }
        this.ag.discardOldTokens(false);
        return sets;
    }

    @Override
    public ValueObject[] get() {
        return this.row;
    }

    @Override
    public ValueObject get(int i) {
        if (this.row == null) {
            return null;
        }
        if (i < 0) {
            return null;
        }
        if (i < this.row.length) {
            return this.row[i];
        }
        return null;
    }

    @Override
    public ValueObject next(int i) {
        this.next();
        return this.get(i);
    }

    @Override
    public int width() {
        if (this.canUseIndex()) {
            return this.sets[this.index].length;
        }
        if (this.savedExtra instanceof String[]) {
            return ((String[])this.savedExtra).length;
        }
        if (this.sets != null && 0 < this.sets.length) {
            return this.sets[0].length;
        }
        return -1;
    }

    @Override
    public long getCount() {
        long sum = 0L;
        if (this.canUseIndex()) {
            sum = this.sets.length - this.index;
        } else if (this.sets != null) {
            sum = this.sets.length;
        }
        sum += (long)this.savedMore;
        if (this.savedMore > this.savedPlimit) {
            return -sum;
        }
        return sum;
    }

    @Override
    public String[] getNames() {
        if (this.savedExtra instanceof String[]) {
            return (String[])((String[])this.savedExtra).clone();
        }
        int w = this.width();
        if (w < 0) {
            throw new IllegalStateException("There are no values or names.");
        }
        String[] nm = new String[w];
        for (int i = 0; i < nm.length; ++i) {
            nm[i] = "v" + i;
        }
        this.savedExtra = nm;
        return nm;
    }

    @Override
    public ValueObject get(String name) {
        return this.get(this.getIndex(name));
    }

    public static boolean sameVar(String var, String name) {
        int q;
        if (name.equals(var)) {
            return true;
        }
        int p = var.indexOf("?");
        if (p == (q = name.indexOf("?"))) {
            return false;
        }
        if (p == -1 && q == 0 && name.startsWith(var, 1) && 1 + var.length() == name.length()) {
            return true;
        }
        return p == 0 && q == -1 && var.startsWith(name, 1) && 1 + name.length() == var.length();
    }

    @Override
    public int getIndex(String var) {
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            if (!ValueSetIteratorImpl.sameVar(var, names[i])) continue;
            return i;
        }
        return -1;
    }
}

