/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.UPI;
import java.nio.CharBuffer;

public class UPIImpl
implements UPI {
    private static final int CODE_LOWEST = -14;
    private static final UPIImpl WILD = new UPIImpl(-1L);
    private static final UPIImpl NULL_CONTEXT = new UPIImpl(-2L);
    static final int WIDTH = 12;
    byte[] upi = null;
    int setWidth = 0;
    long code = -14L;
    int width = 12;

    public byte[] getUpi() {
        return this.upi;
    }

    public static UPI wildUPI() {
        return WILD;
    }

    public static UPIImpl nullUPI() {
        return NULL_CONTEXT;
    }

    static String wildString() {
        return null;
    }

    static String nullString(boolean allAllowed) {
        if (allAllowed) {
            return "";
        }
        return null;
    }

    static String allString() {
        return null;
    }

    public static UPI refNull(UPI x) {
        if (x == null) {
            return NULL_CONTEXT;
        }
        return x;
    }

    static boolean isWild(UPI x) {
        if (x == null) {
            return true;
        }
        if (x instanceof UPIImpl) {
            return ((UPIImpl)x).isWild();
        }
        return false;
    }

    public boolean isWild() {
        if (this == WILD) {
            return true;
        }
        if (this.upi != null) {
            return false;
        }
        return UPIImpl.WILD.code == this.code;
    }

    public static boolean isNullContext(UPI x) {
        if (x == null) {
            return false;
        }
        if (x == NULL_CONTEXT) {
            return true;
        }
        if (!(x instanceof UPIImpl)) {
            return false;
        }
        UPIImpl y = (UPIImpl)x;
        if (y.upi != null) {
            return false;
        }
        return UPIImpl.NULL_CONTEXT.code == y.code;
    }

    public boolean isNullContext() {
        if (this.upi != null) {
            return false;
        }
        return UPIImpl.NULL_CONTEXT.code == this.code;
    }

    public static boolean canReference(UPI x) {
        if (UPIImpl.isNullContext(x)) {
            return true;
        }
        if (!(x instanceof UPIImpl)) {
            return false;
        }
        UPIImpl y = (UPIImpl)x;
        return y.upi != null;
    }

    public boolean canReference() {
        if (this.upi != null) {
            return true;
        }
        return this.isNullContext();
    }

    static boolean hasBody(UPI x) {
        if (!(x instanceof UPIImpl)) {
            return false;
        }
        UPIImpl y = (UPIImpl)x;
        return null != y.upi;
    }

    boolean hasBody() {
        return null != this.upi;
    }

    public UPIImpl(long x) {
        this.code = x;
        this.width = 0;
    }

    public UPIImpl() {
        this.upi = new byte[12];
    }

    UPIImpl(byte[] bb) {
        this.upi = new byte[12];
        for (int i = 0; i < bb.length; ++i) {
            this.upi[i] = bb[i];
        }
    }

    public long getCode() {
        return this.code;
    }

    public boolean withLabel() {
        return null != this.upi;
    }

    public void addByte(int b) {
        if (this.upi == null) {
            throw new IllegalStateException("Cannot update marker UPI.");
        }
        if (this.setWidth == 12) {
            throw new IllegalStateException("UPI bytes are all there.");
        }
        this.upi[this.setWidth++] = (byte)b;
    }

    public int getByte(int i) {
        if (i < 12) {
            return 0xFF & this.upi[i];
        }
        return -1;
    }

    public String hexByte(int i) {
        String h = Integer.toHexString(this.getByte(i));
        if ("0".equals(h)) {
            h = "00";
        }
        if (2 < h.length()) {
            h = h.substring(h.length() - 2);
        }
        return h;
    }

    public String blankNodeIDString() {
        return this.hexByte(0) + this.hexByte(1) + this.hexByte(2) + this.hexByte(3);
    }

    public long blankNodeID() {
        return this.getByte(0) + 256 * this.getByte(1) + 65536 * this.getByte(2) + 0x1000000 * this.getByte(3);
    }

    public static int compare(UPI xx, UPI yy) {
        if (!(xx instanceof UPIImpl)) {
            return 0;
        }
        if (!(yy instanceof UPIImpl)) {
            return 0;
        }
        UPIImpl x = (UPIImpl)xx;
        UPIImpl y = (UPIImpl)yy;
        if (x.upi == null && y.upi == null) {
            if (x.code == y.code) {
                return 0;
            }
            if (x.code < y.code) {
                return -1;
            }
            return 1;
        }
        if (x.upi == null) {
            return -1;
        }
        if (y.upi == null) {
            return 1;
        }
        byte[] xb = x.upi;
        int xlen = xb.length;
        byte[] yb = y.upi;
        int ylen = yb.length;
        for (int i = 0; i < xlen; ++i) {
            if (i >= ylen) {
                return 1;
            }
            if (xb[i] < yb[i]) {
                return -1;
            }
            if (xb[i] <= yb[i]) continue;
            return 1;
        }
        return 0;
    }

    CharSequence asHex() {
        CharBuffer b = CharBuffer.allocate(24);
        for (int i = 0; i < 12; ++i) {
            int hi = (0xF0 & this.upi[i]) >> 4;
            int lo = 0xF & this.upi[i];
            b.put("0123456789ABCDEF".charAt(hi));
            b.put("0123456789ABCDEF".charAt(lo));
        }
        b.rewind();
        return b;
    }

    public CharSequence asChars() {
        CharBuffer b = CharBuffer.allocate(12);
        for (int i = 0; i < 12; ++i) {
            b.put(this.upiByteAsChar(i));
        }
        b.rewind();
        return b;
    }

    char upiByteAsChar(int i) {
        int v = 1 + (0xFF & this.upi[i]);
        return (char)v;
    }

    public CharSequence asChars(CharSequence prefix) {
        int i;
        CharBuffer b = CharBuffer.allocate(12 + prefix.length());
        for (i = 0; i < prefix.length(); ++i) {
            b.put(prefix.charAt(i));
        }
        for (i = 0; i < 12; ++i) {
            b.put(this.upiByteAsChar(i));
        }
        b.rewind();
        return b;
    }

    @Override
    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (!(x instanceof UPIImpl)) {
            return false;
        }
        UPIImpl y = (UPIImpl)x;
        if (this.upi == null && y.upi == null) {
            return this.getCode() == y.getCode();
        }
        if (this.upi == null || y.upi == null) {
            return false;
        }
        for (int i = 0; i < this.upi.length; ++i) {
            if (this.upi[i] == y.upi[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        if (this.upi == null) {
            return (int)this.getCode();
        }
        for (int i = 0; i < this.upi.length; ++i) {
            h += this.upi[i] << 8 * (i % 4);
        }
        return h;
    }

    @Override
    public String toString() {
        if (this.upi != null) {
            return "<UPI " + this.asHex() + ">";
        }
        if (this.code == -2L) {
            return "";
        }
        return "<UPI code=" + this.code + ">";
    }

    public CharSequence getStoreBytes() {
        if (null == this.upi) {
            return "";
        }
        CharBuffer b = CharBuffer.allocate(8);
        for (int i = 4; i < 8; ++i) {
            int hi = (0xF0 & this.upi[i]) >> 4;
            int lo = 0xF & this.upi[i];
            b.put("0123456789ABCDEF".charAt(hi));
            b.put("0123456789ABCDEF".charAt(lo));
        }
        b.rewind();
        return b;
    }
}

