/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.ResourceNode;
import com.franz.agbase.Triple;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueNode;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.ValueNodeImpl;
import com.franz.agbase.impl.ValueObjectImpl;

public class TripleImpl
extends ValueObjectImpl
implements Triple {
    static final long NO_TRIPLE = -1L;
    private long AGId;
    boolean inferred = false;
    private static final long serialVersionUID = -235560515765409236L;
    private UPI s;
    private UPI p;
    private UPI o;
    private UPI c;
    String subject = null;
    String predicate = null;
    String object = null;
    String context = null;
    int sType = 0;
    int pType = 0;
    int oType = 0;
    int cType = 0;
    String subjMod = null;
    String predMod = null;
    String objMod = null;
    String cxMod = null;
    public ValueNode subjInstance = null;
    public ValueNode predInstance = null;
    public ValueNode objInstance = null;
    private ValueNode cxInstance = null;
    static final TripleImpl[] emptyArray = new TripleImpl[0];

    @Override
    public long queryAGId() {
        return this.AGId;
    }

    @Override
    public long getAGId() throws AllegroGraphException {
        if (this.canReference()) {
            return this.AGId;
        }
        throw new AllegroGraphException("This object does not have a valid id.");
    }

    @Override
    public boolean add() throws AllegroGraphException {
        if (this.canReference()) {
            return false;
        }
        if (null == this.owner) {
            throw new IllegalStateException("Cannot assert Triple with null triple store.");
        }
        this.owner.addStatement(this.subject, this.predicate, this.object, this.context);
        return true;
    }

    public int sameAGId(Object x) {
        if (x == null) {
            return 0;
        }
        if (x instanceof TripleImpl) {
            long xid = ((TripleImpl)x).AGId;
            if (TripleImpl.canReference(this.AGId) && TripleImpl.canReference(xid)) {
                if (this.AGId == xid) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public boolean canReference() {
        return TripleImpl.canReference(this.AGId);
    }

    TripleImpl(AllegroGraph ts, UPI ss, UPI pp, UPI oo) {
        this.owner = ts;
        this.AGId = -1L;
        this.s = ss;
        this.p = pp;
        this.o = oo;
        this.c = UPIImpl.nullUPI();
    }

    TripleImpl(AllegroGraph ts, UPI ss, UPI pp, UPI oo, UPI cc) {
        this.owner = ts;
        this.AGId = -1L;
        this.s = ss;
        this.p = pp;
        this.o = oo;
        this.c = UPIImpl.refNull(cc);
    }

    TripleImpl(AllegroGraph ts, long i, UPI ss, UPI pp, UPI oo) {
        this.owner = ts;
        this.AGId = i;
        this.s = ss;
        this.p = pp;
        this.o = oo;
        this.c = UPIImpl.nullUPI();
    }

    TripleImpl(AllegroGraph ts, long i, UPI ss, UPI pp, UPI oo, UPI cc) {
        this.owner = ts;
        this.AGId = i;
        this.s = ss;
        this.p = pp;
        this.o = oo;
        this.c = UPIImpl.refNull(cc);
    }

    @Override
    public UPI queryS() {
        return this.s;
    }

    @Override
    public UPI getS() {
        if (this.s == null) {
            this.getParts();
        }
        return this.s;
    }

    @Override
    public String querySubject() {
        return this.subject;
    }

    @Override
    public String getSubjectLabel() throws AllegroGraphException {
        if (this.subject == null) {
            this.getParts();
        }
        return this.subject;
    }

    @Override
    public ResourceNode getSubject() {
        return (ResourceNode)this.getSubjectInstance();
    }

    @Override
    public ValueNode getSubjectInstance() {
        if (null != this.subjInstance) {
            return this.subjInstance;
        }
        this.subjInstance = this.sType > 0 && null != this.subject ? (ValueNode)this.owner.newValue(this.s, this.sType, this.subject, this.subjMod) : (ValueNodeImpl)this.owner.newValue(this.getS());
        return this.subjInstance;
    }

    @Override
    public UPI queryP() {
        return this.p;
    }

    @Override
    public UPI getP() {
        if (this.p == null) {
            this.getParts();
        }
        return this.p;
    }

    @Override
    public String queryPredicate() {
        return this.predicate;
    }

    @Override
    public String getPredicateLabel() throws AllegroGraphException {
        if (this.predicate == null) {
            this.getParts();
        }
        return this.predicate;
    }

    @Override
    public URINode getPredicate() {
        return (URINode)this.getPredicateInstance();
    }

    @Override
    public ValueNode getPredicateInstance() {
        if (null != this.predInstance) {
            return this.predInstance;
        }
        this.predInstance = this.pType > 0 && null != this.predicate ? (ValueNode)this.owner.newValue(this.p, this.pType, this.predicate, this.predMod) : (ValueNodeImpl)this.owner.newValue(this.getP());
        return this.predInstance;
    }

    @Override
    public UPI queryO() {
        return this.o;
    }

    @Override
    public UPI getO() {
        if (this.o == null) {
            this.getParts();
        }
        return this.o;
    }

    @Override
    public String queryObject() {
        return this.object;
    }

    @Override
    public String getObjectLabel() throws AllegroGraphException {
        if (this.object == null) {
            this.getParts();
        }
        return this.object;
    }

    @Override
    public ValueNode getObject() {
        if (null != this.objInstance) {
            return this.objInstance;
        }
        this.objInstance = this.oType > 0 && null != this.object ? (ValueNode)this.owner.newValue(this.o, this.oType, this.object, this.objMod) : (ValueNodeImpl)this.owner.newValue(this.getO());
        return this.objInstance;
    }

    @Override
    public UPI getC() {
        return this.c;
    }

    @Override
    public String queryContext() {
        return this.context;
    }

    @Override
    public String getContextLabel() {
        if (this.context == null) {
            this.getParts();
        }
        return this.context;
    }

    @Override
    public ValueNode getContext() {
        if (null != this.cxInstance) {
            return this.cxInstance;
        }
        this.cxInstance = this.cType > 0 && null != this.context ? (ValueNode)this.owner.newValue(this.c, this.cType, this.context, this.cxMod) : (ValueNodeImpl)this.owner.newValue(this.getC());
        return this.cxInstance;
    }

    void getParts() {
        block6: {
            try {
                if (UPIImpl.canReference(this.s) && UPIImpl.canReference(this.p) && UPIImpl.canReference(this.o)) break block6;
                if (ValueObjectImpl.canReference(this.AGId)) {
                    UPIImpl[] v = this.owner.getTripleParts(this.AGId);
                    if (v == null) {
                        throw new IllegalStateException("Cannot reference this triple id " + this.AGId);
                    }
                    this.s = v[0];
                    this.p = v[1];
                    this.o = v[2];
                    this.c = v[3];
                    break block6;
                }
                throw new IllegalStateException("Cannot reference this triple id " + this.AGId);
            }
            catch (AllegroGraphException e) {
                throw new IllegalStateException("Cannot reference this triple id " + this.AGId);
            }
        }
        UPI[] ids = new UPI[]{this.s, this.p, this.o, this.c};
        int[] types = new int[4];
        String[] labels = new String[4];
        String[] mods = new String[4];
        try {
            this.owner.getPartsInternal(ids, types, labels, mods);
        }
        catch (AllegroGraphException e) {
            throw new IllegalStateException("Failed to get all the parts of a triple " + e);
        }
        this.subject = labels[0];
        this.predicate = labels[1];
        this.object = labels[2];
        this.context = labels[3];
        this.sType = types[0];
        this.pType = types[1];
        this.oType = types[2];
        this.cType = types[3];
        this.subjMod = mods[0];
        this.predMod = mods[1];
        this.objMod = mods[2];
        this.cxMod = mods[3];
    }

    String showPart(UPI id, String label, int type, String mod, ValueNode val) {
        if (val != null) {
            return val.toString();
        }
        if (label != null) {
            switch (type) {
                case 1: {
                    return "_:" + label;
                }
                case 2: {
                    return label;
                }
                case 4: {
                    return "\"" + label + "\"@" + mod;
                }
                case 5: {
                    return "\"" + label + "\"^^" + mod;
                }
            }
            return "\"" + label + "\"";
        }
        if (id != null) {
            return id.toString();
        }
        return "null";
    }

    @Override
    public String toString() {
        String cp = this.c == null ? "" : (this.owner.isDefaultGraph(this.c) | this.owner.isDefaultGraph(this.cType) ? "" : (-2L == ((UPIImpl)this.c).code ? "" : " " + this.showPart(this.c, this.context, this.cType, this.cxMod, this.cxInstance)));
        return "<Triple " + this.AGId + ": " + this.showPart(this.s, this.subject, this.sType, this.subjMod, this.subjInstance) + " " + this.showPart(this.p, this.predicate, this.pType, this.predMod, this.predInstance) + " " + this.showPart(this.o, this.object, this.oType, this.objMod, this.objInstance) + cp + ">";
    }

    @Override
    public boolean equals(Object other) {
        switch (this.sameAGId(other)) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        if (other instanceof Triple) {
            Triple os = (Triple)other;
            return this.getSubject().equals(os.getSubject()) && ((Object)this.getPredicate()).equals(os.getPredicate()) && this.getObject().equals(os.getObject());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 961 * this.getSubject().hashCode() + 31 * ((Object)this.getPredicate()).hashCode() + this.getObject().hashCode();
    }

    @Override
    public int compareTo(TripleImpl to) {
        if (this.AGId < to.AGId) {
            return -1;
        }
        if (this.AGId > to.AGId) {
            return 1;
        }
        return 0;
    }
}

