/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.EncodedLiteral;
import com.franz.agbase.impl.LiteralNodeImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGInternals;

public class EncodedLiteralImpl
extends LiteralNodeImpl
implements EncodedLiteral {
    private static final long serialVersionUID = 3540374144729778500L;
    long longValue = 0L;
    double doubleValue = 0.0;
    String stringValue = null;
    public String encoding;
    int rawType;

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Object getValue() {
        switch (this.rawType) {
            case 0: {
                return new Long(this.longValue);
            }
            case 1: {
                return new Double(this.doubleValue);
            }
        }
        return this.stringValue;
    }

    EncodedLiteralImpl(AllegroGraph ts, long value, String newEncoding) {
        super(ts, null, "" + value, null, null, null, null);
        this.rawType = 0;
        this.longValue = value;
        this.encoding = newEncoding;
    }

    EncodedLiteralImpl(AllegroGraph ts, double value, String newEncoding) {
        super(ts, null, "" + value, null, null, null, null);
        this.rawType = 1;
        this.doubleValue = value;
        this.encoding = newEncoding;
    }

    EncodedLiteralImpl(AllegroGraph ts, String value, String newEncoding) {
        super(ts, null, value, null, null, null, null);
        this.rawType = 2;
        this.stringValue = value;
        this.encoding = newEncoding;
    }

    public String stringValue() {
        switch (this.rawType) {
            case 0: {
                return "N" + this.longValue;
            }
            case 1: {
                return "D" + this.doubleValue;
            }
            case 2: {
                return "S" + this.stringValue;
            }
        }
        throw new IllegalStateException("bad rawType " + this.rawType);
    }

    @Override
    public void add() throws AllegroGraphException {
        if (this.canReference()) {
            return;
        }
        Object[] v = this.owner.verifyEnabled().addPart(this.owner, AGInternals.refEncToString(this));
        this.nodeUPI = (UPIImpl)v[0];
    }

    @Override
    public String toString() {
        return "<Literal " + this.nodeUPI + " " + this.queryLabel() + " :" + this.encoding + ">";
    }

    @Override
    public String getLanguage() {
        return null;
    }
}

