/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.impl.NamedAttributeList;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGInternals;

public class TriplesQuery {
    private NamedAttributeList queryAttributes = new NamedAttributeList(queryOptions);
    private Object subject = null;
    private Object predicate = null;
    private Object object = null;
    private Object context = "";
    private Object subjectEnd = null;
    private Object predicateEnd = null;
    private Object objectEnd = null;
    private Object contextEnd = null;
    private Object sref = null;
    private Object pref = null;
    private Object oref = null;
    private Object cref = -2;
    private Object seref = null;
    private Object peref = null;
    private Object oeref = null;
    private Object ceref = null;
    private boolean includeInferred = false;
    private boolean withParts = true;
    private int lookahead = -1;
    private static final String INCDELS = "include-deleted";
    private static final String DROPENC = "omit-encoded";
    private static final String DROPNON = "omit-non-encoded";
    private static final String FILTER = "filter";
    private static final String INDEXED = "indexed-only";
    private static final String WITHPARTS = "with-parts";
    private static final String INFER = "infer";
    private static final String HASVALUE = "has-value";
    private static final Object[] queryOptions = new Object[]{"include-deleted", Boolean.class, "omit-encoded", Boolean.class, "omit-non-encoded", Boolean.class, "filter", String.class, "indexed-only", Boolean.class, "with-parts", Boolean.class, "infer", Boolean.class, "has-value", Boolean.class};
    private boolean haveResultCursor = false;
    private TriplesIterator resultCursor = null;
    private long resultCount = -1L;
    private boolean haveBooleanResult = false;
    private boolean booleanResult = false;
    private AllegroGraph ag = null;

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) throws AllegroGraphException {
        Object v = AllegroGraph.anyContextRef(context, 5);
        this.freshState();
        this.cref = v;
        this.context = context;
    }

    public Object getContextEnd() {
        return this.contextEnd;
    }

    public void setContextEnd(Object contextEnd) throws AllegroGraphException {
        Object v = AllegroGraph.anyContextRef(contextEnd, 6);
        this.freshState();
        this.ceref = v;
        this.contextEnd = contextEnd;
    }

    public Object getObject() {
        return this.object;
    }

    private Object setPart(Object ref) {
        Object v = AllegroGraph.validRangeRef(ref);
        this.freshState();
        return v;
    }

    public void setObject(Object object) {
        this.oref = this.setPart(object);
        this.object = object;
    }

    public Object getObjectEnd() {
        return this.objectEnd;
    }

    public void setObjectEnd(Object objectEnd) {
        this.oeref = this.setPart(objectEnd);
        this.objectEnd = objectEnd;
    }

    public Object getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Object predicate) {
        this.pref = this.setPart(predicate);
        this.predicate = predicate;
    }

    public Object getPredicateEnd() {
        return this.predicateEnd;
    }

    public void setPredicateEnd(Object predicateEnd) {
        this.peref = this.setPart(predicateEnd);
        this.predicateEnd = predicateEnd;
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.sref = this.setPart(subject);
        this.subject = subject;
    }

    public Object getSubjectEnd() {
        return this.subjectEnd;
    }

    public void setSubjectEnd(Object subjectEnd) {
        this.seref = this.setPart(subjectEnd);
        this.subjectEnd = subjectEnd;
    }

    private void freshState() {
        this.haveResultCursor = false;
        this.resultCursor = null;
        this.resultCount = -1L;
        this.haveBooleanResult = false;
        this.booleanResult = false;
    }

    public boolean getBooleanResult() {
        if (this.haveBooleanResult) {
            return this.booleanResult;
        }
        throw new IllegalStateException("BooleanResult is not set.");
    }

    public long getResultCount() {
        if (-1L < this.resultCount) {
            return this.resultCount;
        }
        throw new IllegalStateException("ResultCount is not set.");
    }

    public boolean isIncludeInferred() {
        return this.includeInferred;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.freshState();
        this.includeInferred = includeInferred;
    }

    public int getIncludeDeleted() {
        return this.boolAttr(INCDELS);
    }

    private int boolAttr(String attr) {
        Object v = this.queryAttributes.getAttribute(attr);
        if (v == null) {
            return -1;
        }
        if (((Boolean)v).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void setIncludeDeleted(boolean v) {
        this.freshState();
        this.queryAttributes.setAttribute(INCDELS, v);
    }

    public void setOmitEncoded(boolean v) {
        this.freshState();
        this.queryAttributes.setAttribute(DROPENC, v);
    }

    public int getOmitEncoded() {
        return this.boolAttr(DROPENC);
    }

    public int getHasValue() {
        Object v = this.queryAttributes.getAttribute(HASVALUE);
        if (v == null) {
            return -1;
        }
        if (((Boolean)v).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void setHasValue(boolean v) {
        this.freshState();
        this.queryAttributes.setAttribute(HASVALUE, new Boolean(v));
    }

    public void setLookAhead(int lh) {
        if (lh < 0) {
            throw new IllegalArgumentException("Lookahead must be positive");
        }
        this.lookahead = lh;
    }

    public int getLookAhead() {
        if (this.lookahead > -1) {
            return this.lookahead;
        }
        if (this.ag == null) {
            return -1;
        }
        if (0 == this.ag.defaultLookAhead) {
            return TriplesIteratorImpl.getDefaultLookAhead();
        }
        return this.ag.defaultLookAhead;
    }

    public void setOmitNonEncoded(boolean v) {
        this.freshState();
        this.queryAttributes.setAttribute(DROPNON, v);
    }

    public int getOmitNonEncoded() {
        return this.boolAttr(DROPNON);
    }

    public void setIndexedOnly(boolean v) {
        this.freshState();
        this.queryAttributes.setAttribute(INDEXED, v);
    }

    public int getIndexedOnly() {
        return this.boolAttr(INDEXED);
    }

    public void setFilterFunction(String name) {
        this.freshState();
        this.queryAttributes.setAttribute(FILTER, name);
    }

    public String getLoadFunction() {
        return (String)this.queryAttributes.getAttribute(FILTER);
    }

    public TriplesIterator getResultCursor() {
        if (this.haveResultCursor) {
            return this.resultCursor;
        }
        throw new IllegalStateException("ResultCursor is not set.");
    }

    private void validate(AllegroGraph ag) {
        this.freshState();
        if (ag != null) {
            this.ag = ag;
        }
        if (this.ag == null) {
            throw new IllegalStateException("Cannot run without a triple store.");
        }
    }

    public void setTripleStore(AllegroGraph ag) {
        this.freshState();
        this.ag = ag;
    }

    public AGInternals getTripleStore() {
        return this.ag;
    }

    private Object[] getOpts() {
        if (this.withParts) {
            this.queryAttributes.setAttribute(WITHPARTS, true);
        }
        return this.queryAttributes.getList();
    }

    public long count() throws AllegroGraphException {
        this.validate(null);
        Object v = this.ag.verifyEnabled().getTriples(this.ag, this.sref, this.pref, this.oref, this.cref, this.seref, this.peref, this.oeref, this.ceref, -5, this.getOpts());
        return AGConnector.longValue(v);
    }

    public long count(AllegroGraph ag) throws AllegroGraphException {
        this.ag = ag;
        return this.count();
    }

    public long estimate(boolean roughly) throws AllegroGraphException {
        this.validate(null);
        Object v = this.ag.verifyEnabled().getTriples(this.ag, this.sref, this.pref, this.oref, this.cref, this.seref, this.peref, this.oeref, this.ceref, roughly ? -3 : -4, this.getOpts());
        this.resultCount = AGConnector.longValue(v);
        return this.resultCount;
    }

    public long estimate(boolean roughly, AllegroGraph ag) throws AllegroGraphException {
        this.ag = ag;
        return this.estimate(roughly);
    }

    public boolean ask() throws AllegroGraphException {
        this.validate(null);
        Object v = this.ag.verifyEnabled().getTriples(this.ag, this.sref, this.pref, this.oref, this.cref, this.seref, this.peref, this.oeref, this.ceref, -1, this.getOpts());
        this.booleanResult = (Boolean)v;
        this.haveBooleanResult = true;
        return this.booleanResult;
    }

    public boolean ask(AllegroGraph ag) throws AllegroGraphException {
        this.ag = ag;
        return this.ask();
    }

    public Triple find() throws AllegroGraphException {
        this.freshState();
        this.validate(null);
        Object v = this.ag.verifyEnabled().getTriples(this.ag, this.sref, this.pref, this.oref, this.cref, this.seref, this.peref, this.oeref, this.ceref, -2, this.getOpts());
        this.resultCursor = (TriplesIterator)v;
        if (!this.resultCursor.hasNext()) {
            return null;
        }
        return this.resultCursor.next();
    }

    public Triple find(AllegroGraph ag) throws AllegroGraphException {
        this.ag = ag;
        return this.find();
    }

    public TriplesIterator run() throws AllegroGraphException {
        this.validate(null);
        Object v = this.ag.verifyEnabled().getTriples(this.ag, this.sref, this.pref, this.oref, this.cref, this.seref, this.peref, this.oeref, this.ceref, this.getLookAhead(), this.getOpts());
        this.resultCursor = (TriplesIterator)v;
        return this.resultCursor;
    }

    public TriplesIterator run(AllegroGraph ag) throws AllegroGraphException {
        this.ag = ag;
        return this.run();
    }
}

