/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.GeospatialSubtype;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.GeospatialSubtypeImpl;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.transport.AGConnector;

public class GeoExtension {
    private AllegroGraph ag = null;

    GeoExtension(AllegroGraph ag) {
        this.ag = ag;
    }

    public GeospatialSubtype registerCartesianStriping(double lonMin, double lonMax, double latMin, double latMax, double stripWidth) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"cartesian", new Double(lonMin), new Double(lonMax), new Double(latMin), new Double(latMax), new Double(stripWidth)});
        return this.registeredStriping(v);
    }

    GeospatialSubtype registeredStriping(Object[] v) {
        if (v == null) {
            return null;
        }
        if (1 > v.length) {
            return null;
        }
        GeospatialSubtypeImpl s = (GeospatialSubtypeImpl)GeospatialSubtypeImpl.get(AGConnector.longValue(v[0]), this.ag);
        if (3 == v.length) {
            s.setUUID((String)v[1]);
            s.setXSDType((String)v[2]);
        }
        return s;
    }

    public GeospatialSubtype[] getSubtypes() throws AllegroGraphException {
        Object[] v = null;
        try {
            v = this.ag.verifyEnabled().applyAGFn(this.ag, "agj-geospatial-subtypes", new Object[]{1});
        }
        catch (IllegalArgumentException e) {
            v = this.ag.verifyEnabled().applyAGFn(this.ag, "agj-geospatial-subtypes", new Object[0]);
        }
        if (v == null) {
            return new GeospatialSubtype[0];
        }
        if (0 == v.length) {
            return new GeospatialSubtype[0];
        }
        Object w = v[0];
        if (1 == v.length && w instanceof String[]) {
            if (!(w instanceof String[])) {
                return new GeospatialSubtype[0];
            }
            String[] y = (String[])w;
            GeospatialSubtype[] r = new GeospatialSubtype[y.length / 2];
            for (int i = 0; i < y.length; i += 2) {
                long n = Long.parseLong(y[i]);
                GeospatialSubtypeImpl s = (GeospatialSubtypeImpl)GeospatialSubtypeImpl.get(n, this.ag);
                s.setUUID(y[i + 1]);
                r[i / 2] = s;
            }
            return r;
        }
        if (3 == v.length && GeoExtension.isLongArray(w)) {
            int[] ids = AGConnector.intArray(w);
            String[] uuids = (String[])v[1];
            String[] xsdts = (String[])v[2];
            GeospatialSubtype[] r = new GeospatialSubtype[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                GeospatialSubtypeImpl s = (GeospatialSubtypeImpl)GeospatialSubtypeImpl.get(ids[i], this.ag);
                s.setUUID(uuids[i]);
                s.setXSDType(xsdts[i]);
                r[i] = s;
            }
            return r;
        }
        return new GeospatialSubtype[0];
    }

    static boolean isLongArray(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof Object[]) {
            return true;
        }
        if (x instanceof long[]) {
            return true;
        }
        if (x instanceof int[]) {
            return true;
        }
        if (x instanceof short[]) {
            return true;
        }
        return x instanceof byte[];
    }

    public GeospatialSubtype registerLatitudeStripingInDegrees(double width) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"degrees", new Double(width)});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInDegrees(double width, Double latMin, Double latMax, Double lonMin, Double lonMax) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"degrees", new Double(width), "lat-min", latMin, "lat-max", latMax, "lon-min", lonMin, "lon-max", lonMax});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInMiles(double width) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"miles", new Double(width)});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInMiles(double width, Double latMin, Double latMax, Double lonMin, Double lonMax) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"miles", new Double(width), "lat-min", latMin, "lat-max", latMax, "lon-min", lonMin, "lon-max", lonMax});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInKm(double width) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"km", new Double(width)});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInKm(double width, Double latMin, Double latMax, Double lonMin, Double lonMax) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"km", new Double(width), "lat-min", latMin, "lat-max", latMax, "lon-min", lonMin, "lon-max", lonMax});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInRadians(double width) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"radians", new Double(width)});
        return this.registeredStriping(v);
    }

    public GeospatialSubtype registerLatitudeStripingInRadians(double width, Double latMin, Double latMax, Double lonMin, Double lonMax) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-striping", new Object[]{"radians", new Double(width), "lat-min", latMin, "lat-max", latMax, "lon-min", lonMin, "lon-max", lonMax});
        return this.registeredStriping(v);
    }

    public void addSubtype(GeospatialSubtype subtype) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-add-subtype", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags)});
    }

    public UPI encodeUPI(GeospatialSubtype subtype, double longitude, double latitude) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), new Double(longitude), new Double(latitude)});
        return (UPI)v[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype subtype, double[] longitude, double[] latitude) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), longitude, latitude});
        return (UPI[])v[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype subtype, double longitude, double[] latitude) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), new Double(longitude), latitude});
        return (UPI[])v[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype subtype, double[] longitude, double latitude) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), longitude, new Double(latitude)});
        return (UPI[])v[0];
    }

    public UPI[] encodeUPIs(GeospatialSubtype subtype, double[] longlat) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-encode-geoupi", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), "longlat", longlat});
        return (UPI[])v[0];
    }

    public Object[] decodeUPI(UPI upi) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-decode-geoupi", new Object[]{upi});
        v[0] = GeospatialSubtypeImpl.get((Long)v[0], this.ag);
        return v;
    }

    public Object[] decodeUPIs(UPI[] upi) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-decode-geoupi", new Object[]{upi});
        Object w = v[0];
        if (w instanceof byte[]) {
            byte[] gw = (byte[])w;
            GeospatialSubtype[] gs = new GeospatialSubtype[gw.length];
            for (int i = 0; i < gs.length; ++i) {
                gs[i] = GeospatialSubtypeImpl.get(gw[i], this.ag);
            }
            v[0] = gs;
        } else {
            v[0] = GeospatialSubtypeImpl.get(AGConnector.longValue(v[0]), this.ag);
        }
        return v;
    }

    private Integer lookAheadArg() {
        int lh = this.ag.defaultLookAhead;
        if (lh < 1) {
            lh = TriplesIteratorImpl.defaultLookAhead;
        }
        return new Integer(lh);
    }

    private TriplesIterator geoCursor(Object[] v) {
        if (v == null || 2 > v.length) {
            return this.ag.emptyCursor();
        }
        return AGFactory.makeCursor(this.ag, v[0], AGConnector.toUPIArray(v[1]));
    }

    public TriplesIterator getStatementsInBoundingBox(GeospatialSubtype subtype, Object predicate, double xMin, double xMax, double yMin, double yMax, boolean indexedOnly, boolean includeDeleted) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-get-geo-in-box", new Object[]{((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), this.ag.validRef(predicate), new Double(xMin), new Double(xMax), new Double(yMin), new Double(yMax), "indexed-only", indexedOnly ? "" : null, "include-deleted", includeDeleted ? "" : null, "look-ahead", this.lookAheadArg()});
        return this.geoCursor(v);
    }

    private TriplesIterator getGeoStatements(String units, GeospatialSubtype subtype, Object predicate, double x, double y, double radius, boolean indexedOnly, boolean includeDeleted) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-get-geo-triples", new Object[]{units, ((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags), this.ag.validRef(predicate), new Double(x), new Double(y), new Double(radius), "indexed-only", indexedOnly ? "" : null, "include-deleted", includeDeleted ? "" : null, "look-ahead", this.lookAheadArg()});
        return this.geoCursor(v);
    }

    public TriplesIterator getStatementsInRadius(GeospatialSubtype subtype, Object predicate, double x, double y, double radius, boolean indexedOnly, boolean includeDeleted) throws AllegroGraphException {
        return this.getGeoStatements("radius", subtype, predicate, x, y, radius, indexedOnly, includeDeleted);
    }

    public TriplesIterator getStatementsInHMiles(GeospatialSubtype subtype, Object predicate, double lon, double lat, double radius, boolean indexedOnly, boolean includeDeleted) throws AllegroGraphException {
        return this.getGeoStatements("hmi", subtype, predicate, lon, lat, radius, indexedOnly, includeDeleted);
    }

    public TriplesIterator getStatementsInHKm(GeospatialSubtype subtype, Object predicate, double lon, double lat, double radius, boolean indexedOnly, boolean includeDeleted) throws AllegroGraphException {
        return this.getGeoStatements("hkm", subtype, predicate, lon, lat, radius, indexedOnly, includeDeleted);
    }

    public TriplesIterator getStatementsInHRadians(GeospatialSubtype subtype, Object predicate, double lon, double lat, double radius, boolean indexedOnly, boolean includeDeleted) throws AllegroGraphException {
        return this.getGeoStatements("hrad", subtype, predicate, lon, lat, radius, indexedOnly, includeDeleted);
    }

    public void addSphericalPredicateMapping(String label, GeospatialSubtype subtype) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-add-geo-mapping", new Object[]{"sph-pred", label, ((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags)});
    }

    public void addSphericalDatatypeMapping(String label, GeospatialSubtype subtype) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-add-geo-mapping", new Object[]{"sph-type", label, ((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags)});
    }

    public void addCartesianPredicateMapping(String label, GeospatialSubtype subtype) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-add-geo-mapping", new Object[]{"cart-pred", label, ((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags)});
    }

    public void addCartesianDatatypeMapping(String label, GeospatialSubtype subtype) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-add-geo-mapping", new Object[]{"cart-type", label, ((GeospatialSubtypeImpl)subtype).getLocal(this.ag.ags)});
    }
}

