/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.BlankNode;
import com.franz.agbase.EncodedLiteral;
import com.franz.agbase.GeoExtension;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.NamespaceRegistry;
import com.franz.agbase.ResourceNode;
import com.franz.agbase.SNAExtension;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.ValueSetIterator;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.LiteralNodeImpl;
import com.franz.agbase.impl.TripleImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.URINodeImpl;
import com.franz.agbase.impl.ValueSetIteratorImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGInternals;
import java.util.ArrayList;

public class AllegroGraph
extends AGInternals {
    private static String[] versionLabels = new String[]{"AllegroGraph Version ", "      protocol level "};
    private ArrayList<UPI> blanks = new ArrayList();
    private static String xsiPrefix = "http://www.w3.org/2001/XMLSchema#";
    private URINode[] xsiCache = new URINode[]{null, null, null, null, null, null, null};
    private static final int XS_BOOLEAN = 0;
    private static final int XS_BYTE = 1;
    private static final int XS_SHORT = 2;
    private static final int XS_INT = 3;
    private static final int XS_LONG = 4;
    private static final int XS_FLOAT = 5;
    private static final int XS_DOUBLE = 6;
    private SNAExtension sna = null;
    private GeoExtension geo = null;

    public static String version() {
        Class<?>[] mems = AllegroGraph.class.getDeclaredClasses();
        String ag = AllegroGraph.class.getName();
        String s = "";
        ag = ag + "$V";
        for (int i = 0; i < mems.length; ++i) {
            String sub = mems[i].getName();
            if (!sub.startsWith(ag)) continue;
            s = sub;
        }
        return s;
    }

    public static String[] versions() {
        return new String[]{AllegroGraph.version(), "7"};
    }

    public static void main(String[] args) {
        String[] v = AllegroGraph.versions();
        for (int i = 0; i < v.length; ++i) {
            System.out.println(versionLabels[i] + v[i]);
        }
    }

    public void setLookAhead(int n) {
        if (n <= -1) {
            throw new IllegalArgumentException("setLookAhead cannot be negative " + n);
        }
        this.defaultLookAhead = n;
    }

    public int getLookAhead() {
        return this.defaultLookAhead;
    }

    protected AllegroGraph(AllegroGraphConnection sv, String access, String name, String directory) throws AllegroGraphException {
        this.ags = sv;
        this.storeName = name;
        this.storeDirectory = directory;
        if ("".equals(access)) {
            return;
        }
        this.connect(access);
    }

    public synchronized void setAttribute(StoreAttribute name, Object value) {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.accOpts.setAttribute(name.value(), value);
    }

    public synchronized void setAttribute(String name, Object value) {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.accOpts.setAttribute(name, value);
    }

    public void syncTripleStore() throws AllegroGraphException {
        this.verifyEnabled().syncTripleStore(this);
    }

    public synchronized boolean closeTripleStore() throws AllegroGraphException {
        return this.closeTripleStore(true);
    }

    public synchronized boolean closeTripleStore(boolean doClose) throws AllegroGraphException {
        if (this.tsx < 1) {
            return false;
        }
        boolean r = this.verifyEnabled().closeTripleStore(this, doClose);
        this.tsx = -2;
        this.ags.dropTS(this);
        return r;
    }

    public long loadNTriples(String name) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, name, null, null, null, null, null);
    }

    public long loadNTriples(String name, Object context) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, name, this.ntripleContext(context), null, null, null, null);
    }

    public long loadNTriples(String[] names) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, names, null, null, null, null, null);
    }

    public long loadNTriples(String[] names, Object context) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, names, this.ntripleContext(context), null, null, null, null);
    }

    public long loadNTriples(Object names, Object context, Boolean save, String ext, Object[] place) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, names, this.ntripleContext(context), null, place, save, ext);
    }

    public long loadNTriples(String name, Object context, Boolean save, String ext, Object[] place, boolean unzip) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, name, this.ntripleContext(context), null, place, save, ext, unzip);
    }

    public long parseNTriples(String from) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, null, from, null, null, null);
    }

    public long parseNTriples(String from, Object context) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, this.ntripleContext(context), from, null, null, null);
    }

    public long parseNTriples(String from, Object context, boolean save, Object[] place) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, this.ntripleContext(context), from, place, save, null);
    }

    public long loadRDFXML(String filePath) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, filePath, null, null, null);
    }

    public long loadRDFXML(String filePath, Object context) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, filePath, this.ntripleContext(context), null, null);
    }

    public long loadRDFXML(String filePath, Object context, String baseURI) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, filePath, this.ntripleContext(context), baseURI, false, null, null);
    }

    public long loadRDFXML(Object filePath, Object context, String baseURI, Object useRapper, Boolean save) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, filePath, this.ntripleContext(context), baseURI, useRapper, null, save);
    }

    public long loadRDFXML(String[] filePaths) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, filePaths, null, null, null);
    }

    public long parseRDFXML(String data, Object context, String baseURI) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, null, this.ntripleContext(context), baseURI, null, data, null);
    }

    public long parseRDFXML(String data, Object context, String baseURI, Boolean save) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, null, this.ntripleContext(context), baseURI, null, data, save);
    }

    public long numberOfTriples() throws AllegroGraphException {
        return this.verifyEnabled().numberOfTriples(this);
    }

    public void indexNewTriples() throws AllegroGraphException {
        try {
            this.verifyEnabled().indexTriples(this, true);
        }
        catch (IllegalArgumentException e) {
            this.throwIndexError(e);
            throw e;
        }
    }

    public void indexNewTriples(boolean wait) throws AllegroGraphException {
        try {
            this.verifyEnabled().indexTriples(this, wait);
        }
        catch (IllegalArgumentException e) {
            this.throwIndexError(e);
            throw e;
        }
    }

    public void mergeNewTriples(boolean wait) throws AllegroGraphException {
        this.verifyEnabled().indexStore(this, wait, null);
    }

    void throwIndexError(Throwable e) throws AllegroGraphException {
        String m = e.toString();
        if (-1 == m.indexOf("too-many-index-chunks-error ")) {
            return;
        }
        String w = " will create ";
        int ch = m.indexOf(w);
        if (ch == -1) {
            return;
        }
        int ch2 = m.indexOf(" ", ch + w.length());
        if (ch2 == -1) {
            return;
        }
        throw new AllegroGraphException("too-many-index-chunks-error: " + m.substring(ch, ch2) + " files");
    }

    public void indexAllTriples() throws AllegroGraphException {
        try {
            this.verifyEnabled().indexAll(this, true);
        }
        catch (IllegalArgumentException e) {
            this.throwIndexError(e);
            throw e;
        }
    }

    public void indexAllTriples(boolean wait) throws AllegroGraphException {
        try {
            this.verifyEnabled().indexAll(this, wait);
        }
        catch (IllegalArgumentException e) {
            this.throwIndexError(e);
            throw e;
        }
    }

    private String stringElt(String[] a, int i) {
        if (a == null) {
            return null;
        }
        if (i < a.length) {
            return a[i];
        }
        return a[a.length - 1];
    }

    public ValueObject newValue(UPI id) {
        ValueObject v = null;
        if (!UPIImpl.canReference(id)) {
            throw new IllegalStateException("AllegroGraph Id cannot be registered:" + id);
        }
        if (UPIImpl.isNullContext(id)) {
            return this.getDefaultGraph(id);
        }
        try {
            Object[] r = this.verifyEnabled().getParts(this, id);
            v = this.newValue(id, (Integer)r[0], (String)r[1], (String)r[2]);
        }
        catch (AllegroGraphException e) {
            this.failCreate("ValueObject", e);
        }
        if (v == null) {
            this.failCreate("ValueObject", null);
        }
        return v;
    }

    void failCreate(String what, Throwable e) {
        throw new IllegalStateException("Cannot create " + what + " -- " + e);
    }

    public String[] getParts(UPI id) throws AllegroGraphException {
        Object[] r = this.verifyEnabled().getParts(this, id);
        return new String[]{this.typeToString((Integer)r[0]), (String)r[1], (String)r[2]};
    }

    public UPIImpl[] getTripleParts(long id) throws AllegroGraphException {
        UPIImpl[] v = this.verifyEnabled().getTripleParts(this, id);
        if (v == null) {
            throw new AllegroGraphException("Id is not a triple: " + id);
        }
        return v;
    }

    public void getParts(UPI[] ids, String[] types, String[] vals, String[] mods) throws AllegroGraphException {
        int[] tnums = new int[ids.length];
        this.verifyEnabled().getParts(this, ids, tnums, vals, mods);
        for (int i = 0; i < ids.length; ++i) {
            types[i] = this.typeToString(tnums[i]);
        }
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public void setSelectLimit(int v) {
        if (v < 0) {
            throw new IllegalArgumentException("setSelectLimit argument must be non-negative.");
        }
        this.selectLimit = v;
    }

    public BlankNode createBNode() {
        return this.createBNode(null);
    }

    private UPI fetchBlankUPI() {
        if (this.blanks.isEmpty()) {
            try {
                UPI[] supply;
                for (UPI upi : supply = this.createBNodeIds(100)) {
                    this.blanks.add(upi);
                }
            }
            catch (AllegroGraphException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.blanks.remove(0);
    }

    public BlankNode createBNode(String nodeId) {
        BlankNode b = null;
        Exception ee = null;
        if (nodeId == null) {
            nodeId = "";
        }
        try {
            b = AGFactory.makeBlankNode(this, this.fetchBlankUPI(), nodeId);
        }
        catch (Exception e) {
            ee = e;
        }
        if (b == null) {
            this.failCreate("BlankNode", ee);
        }
        return b;
    }

    public BlankNode[] createBNodes(int n) throws AllegroGraphException {
        UPIImpl[] v = this.verifyEnabled().newBlankNodes(this, n);
        BlankNode[] r = new BlankNode[n];
        for (int i = 0; i < n; ++i) {
            r[i] = AGFactory.makeBlankNode(this, v[i], null);
        }
        return r;
    }

    public EncodedLiteral createEncodedLiteral(long v, String encoding) {
        return AGFactory.makeEncodedLiteral(this, v, encoding);
    }

    public EncodedLiteral createEncodedLiteral(double v, String encoding) {
        return AGFactory.makeEncodedLiteral(this, v, encoding);
    }

    public EncodedLiteral createEncodedLiteral(String v, String encoding) {
        return AGFactory.makeEncodedLiteral(this, v, encoding);
    }

    public LiteralNode createLiteral(String value) {
        return AGFactory.makeLiteral(this, null, value, null, null, LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addLiteral(String value) {
        LiteralNode b = null;
        AllegroGraphException ee = null;
        com.franz.ag.UPI tupi = null;
        try {
            UPIImpl id = this.verifyEnabled().newLiteral((AGBase)this, value, tupi, null);
            b = AGFactory.makeLiteral(this, id, value, null, null, LiteralNodeImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException e) {
            ee = e;
        }
        if (b == null) {
            this.failCreate("Literal", ee);
        }
        return b;
    }

    public LiteralNode createLiteral(String value, String language) {
        return AGFactory.makeLiteral(this, null, value, null, null, LiteralNodeImpl.LANG_KNOWN, language);
    }

    public LiteralNode addLiteral(String value, String language) {
        LiteralNode b = null;
        AllegroGraphException ee = null;
        String type = null;
        try {
            UPIImpl id = this.verifyEnabled().newLiteral((AGBase)this, value, type, language);
            b = AGFactory.makeLiteral(this, id, value, null, null, LiteralNodeImpl.LANG_KNOWN, language);
        }
        catch (AllegroGraphException e) {
            ee = e;
        }
        if (b == null) {
            this.failCreate("languageLiteral", ee);
        }
        return b;
    }

    public LiteralNode createTypedLiteral(String text, String type) {
        return AGFactory.makeLiteral(this, null, text, null, type, LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addTypedLiteral(String text, String type) {
        LiteralNode b = null;
        AllegroGraphException ee = null;
        try {
            UPIImpl id = this.verifyEnabled().newLiteral((AGBase)this, text, type, null);
            b = AGFactory.makeLiteral(this, id, text, null, type, LiteralNodeImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException e) {
            ee = e;
        }
        if (b == null) {
            this.failCreate("typedLiteral", ee);
        }
        return b;
    }

    public LiteralNode createTypedLiteral(String text, UPI type) {
        return AGFactory.makeLiteral(this, null, text, type, null, LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addTypedLiteral(String text, UPI type) {
        LiteralNode b = null;
        AllegroGraphException ee = null;
        try {
            UPIImpl id = this.verifyEnabled().newLiteral((AGBase)this, text, type, null);
            b = AGFactory.makeLiteral(this, id, text, type, null, LiteralNodeImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException e) {
            ee = e;
        }
        if (b == null) {
            this.failCreate("typedLiteral", ee);
        }
        return b;
    }

    public LiteralNode addTypedLiteral(String text, URINode type) {
        UPI id;
        if (type instanceof URINodeImpl && (id = ((URINodeImpl)type).queryAGId()) != null) {
            return this.addTypedLiteral(text, id);
        }
        return this.addTypedLiteral(text, ((Object)type).toString());
    }

    public LiteralNode createLiteral(String value, URINode datatype) {
        URINodeImpl nd;
        UPI nid;
        if (datatype instanceof URINodeImpl && UPIImpl.canReference(nid = (nd = (URINodeImpl)datatype).queryAGId())) {
            return AGFactory.makeLiteral(this, null, value, nid, nd.queryURI(), LiteralNodeImpl.LANG_NONE, null);
        }
        return AGFactory.makeLiteral(this, null, value, null, ((Object)datatype).toString(), LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addLiteral(String value, URINode datatype) throws AllegroGraphException {
        if (datatype instanceof URINodeImpl) {
            URINodeImpl nd = (URINodeImpl)datatype;
            UPI nid = nd.queryAGId();
            nid = nd.getAGId();
            if (UPIImpl.canReference(nid)) {
                LiteralNode v = this.addTypedLiteral(value, nid);
                ((LiteralNodeImpl)v).type = ((Object)datatype).toString();
                return v;
            }
        }
        return this.addTypedLiteral(value, ((Object)datatype).toString());
    }

    public LiteralNode[] addLiterals(String[] values, String[] datatypes, String[] languages) throws AllegroGraphException {
        UPIImpl[] ids = this.verifyEnabled().newLiteral((AGBase)this, values, datatypes, languages);
        LiteralNode[] v = new LiteralNode[values.length];
        for (int i = 0; i < values.length; ++i) {
            String ts = this.stringElt(datatypes, i);
            String ls = this.stringElt(languages, i);
            v[i] = AGFactory.makeLiteral(this, ids[i], values[i], null, ts, LiteralNodeImpl.LANG_KNOWN, ls);
        }
        return v;
    }

    public URINode createURI(String uri) {
        return AGFactory.makeNode(this, null, uri);
    }

    public URINode addURI(String uri) throws AllegroGraphException {
        return AGFactory.makeNode(this, this.verifyEnabled().newResource(this, uri), uri);
    }

    public UPI[] addURIIds(String[] uri) throws AllegroGraphException {
        return this.verifyEnabled().newResources(this, uri);
    }

    public URINode[] addURIs(String[] uri) throws AllegroGraphException {
        URINode[] v = new URINode[uri.length];
        UPIImpl[] ids = this.verifyEnabled().newResources(this, uri);
        for (int i = 0; i < uri.length; ++i) {
            v[i] = AGFactory.makeNode(this, ids[i], uri[i]);
        }
        return v;
    }

    public URINode createURI(String namespace, String localName) {
        return this.createURI(namespace + localName);
    }

    public TriplesIterator getStatements(Object subject, Object predicate, Object object) throws AllegroGraphException {
        return this.verifyEnabled().getTriples(this, AllegroGraph.validRefOrWild(subject), AllegroGraph.validRefOrWild(predicate), AllegroGraph.validRefOrWild(object), UPIImpl.nullUPI(), this.defaultLookAhead);
    }

    public TriplesIterator getStatements(boolean includeInferred, Object subject, Object predicate, Object object) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRefOrWild(subject), AllegroGraph.validRefOrWild(predicate), AllegroGraph.validRefOrWild(object), UPIImpl.nullUPI(), this.defaultLookAhead, includeInferred);
    }

    public TriplesIterator getStatements(Object subject, Object predicate, Object object, Object context) throws AllegroGraphException {
        return this.verifyEnabled().getTriples(this, AllegroGraph.validRefOrWild(subject), AllegroGraph.validRefOrWild(predicate), AllegroGraph.validRefOrWild(object), AllegroGraph.anyContextRef(context, 3), this.defaultLookAhead);
    }

    public TriplesIterator getStatements(boolean includeInferred, Object subject, Object predicate, Object object, Object context) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRefOrWild(subject), AllegroGraph.validRefOrWild(predicate), AllegroGraph.validRefOrWild(object), AllegroGraph.anyContextRef(context, 3), this.defaultLookAhead, includeInferred);
    }

    public TriplesIterator getStatements(Object subject, Object predicate, Object object, Object obEnd, Object context, Object contextEnd) throws AllegroGraphException {
        return this.verifyEnabled().getTriples(this, AllegroGraph.validRangeRef(subject), AllegroGraph.validRangeRef(predicate), AllegroGraph.validRangeRef(object), AllegroGraph.anyContextRef(context, 5), null, null, AllegroGraph.validRangeRef(obEnd), AllegroGraph.anyContextRef(contextEnd, 6), this.defaultLookAhead);
    }

    public TriplesIterator getStatements(boolean includeInferred, Object subject, Object predicate, Object object, Object obEnd, Object context, Object contextEnd) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRangeRef(subject), AllegroGraph.validRangeRef(predicate), AllegroGraph.validRangeRef(object), AllegroGraph.anyContextRef(context, 5), null, null, AllegroGraph.validRangeRef(obEnd), AllegroGraph.anyContextRef(contextEnd, 6), this.defaultLookAhead, includeInferred);
    }

    public TriplesIterator getStatements(boolean includeInferred, Object subject, Object subEnd, Object predicate, Object predEnd, Object object, Object obEnd, Object context, Object contextEnd) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRangeRef(subject), AllegroGraph.validRangeRef(predicate), AllegroGraph.validRangeRef(object), AllegroGraph.anyContextRef(context, 5), AllegroGraph.validRangeRef(subEnd), AllegroGraph.validRangeRef(predEnd), AllegroGraph.validRangeRef(obEnd), AllegroGraph.anyContextRef(contextEnd, 6), this.defaultLookAhead, includeInferred);
    }

    public boolean hasStatement(Object subject, Object predicate, Object object) throws AllegroGraphException {
        return this.hasStatement(subject, predicate, object, (Object)URINodeImpl.nullContext);
    }

    public boolean hasStatement(boolean includeInferred, Object subject, Object predicate, Object object) throws AllegroGraphException {
        return this.hasStatement(includeInferred, subject, predicate, object, URINodeImpl.nullContext);
    }

    public boolean hasStatement(Object subject, Object predicate, Object object, Object context) throws AllegroGraphException {
        return this.verifyEnabled().hasTriple(this, AllegroGraph.validRefOrWild(subject), AllegroGraph.validRefOrWild(predicate), AllegroGraph.validRefOrWild(object), AllegroGraph.anyContextRef(context, 3));
    }

    public boolean hasStatement(boolean includeInferred, Object subject, Object predicate, Object object, Object context) throws AllegroGraphException {
        return this.verifyEnabled().hasInfTriple(this, AllegroGraph.validRefOrWild(subject), AllegroGraph.validRefOrWild(predicate), AllegroGraph.validRefOrWild(object), AllegroGraph.anyContextRef(context, 3), includeInferred);
    }

    public void addStatement(Object subject, Object predicate, Object object) throws AllegroGraphException {
        this.addStatement(subject, predicate, object, null);
    }

    public void addStatement(Object subject, Object predicate, Object object, Object context) throws AllegroGraphException {
        this.verifyEnabled().addTriple(this, this.validRef(subject), this.validRef(predicate), this.validRef(object), AllegroGraph.anyContextRef(context, 1));
    }

    public void addStatements(Object subject, Object predicate, Object object) throws AllegroGraphException {
        this.addStatements(subject, predicate, object, null);
    }

    public void addStatements(Object subject, Object predicate, Object object, Object contexts) throws AllegroGraphException {
        try {
            this.verifyEnabled().addTriples(this, this.validRefs(subject), this.validRefs(predicate), this.validRefs(object), this.anyContextRefs(contexts, 1));
        }
        catch (AllegroGraphException e) {
            throw new AllegroGraphException(e);
        }
    }

    public void clear() throws AllegroGraphException {
        try {
            this.verifyEnabled().delete(this, UPIImpl.wildUPI(), UPIImpl.wildUPI(), UPIImpl.wildUPI(), UPIImpl.wildUPI(), true);
        }
        catch (AllegroGraphException e) {
            throw new AllegroGraphException(e);
        }
    }

    private synchronized URINode getDataType(int index) {
        if (this.xsiCache[index] == null) {
            String type = "";
            switch (index) {
                case 0: {
                    type = "boolean";
                    break;
                }
                case 1: {
                    type = "byte";
                    break;
                }
                case 2: {
                    type = "short";
                    break;
                }
                case 3: {
                    type = "int";
                    break;
                }
                case 4: {
                    type = "long";
                    break;
                }
                case 5: {
                    type = "float";
                    break;
                }
                case 6: {
                    type = "double";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad Schema type index");
                }
            }
            this.xsiCache[index] = this.createURI(xsiPrefix, type);
        }
        return this.xsiCache[index];
    }

    public LiteralNode createLiteral(boolean value) {
        return this.createLiteral(Boolean.toString(value), this.getDataType(0));
    }

    public LiteralNode addLiteral(boolean value) throws AllegroGraphException {
        return this.addLiteral(Boolean.toString(value), this.getDataType(0));
    }

    public LiteralNode createLiteral(long value) {
        return this.createLiteral(Long.toString(value), this.getDataType(4));
    }

    public LiteralNode addLiteral(long value) throws AllegroGraphException {
        return this.addLiteral(Long.toString(value), this.getDataType(4));
    }

    public LiteralNode createLiteral(int value) {
        return this.createLiteral(Integer.toString(value), this.getDataType(3));
    }

    public LiteralNode addLiteral(int value) throws AllegroGraphException {
        return this.addLiteral(Integer.toString(value), this.getDataType(3));
    }

    public LiteralNode createLiteral(short value) {
        return this.createLiteral(Short.toString(value), this.getDataType(2));
    }

    public LiteralNode addLiteral(short value) throws AllegroGraphException {
        return this.addLiteral(Short.toString(value), this.getDataType(2));
    }

    public LiteralNode createLiteral(byte value) {
        return this.createLiteral(Byte.toString(value), this.getDataType(1));
    }

    public LiteralNode addLiteral(byte value) throws AllegroGraphException {
        return this.addLiteral(Byte.toString(value), this.getDataType(1));
    }

    public LiteralNode createLiteral(double value) {
        return this.createLiteral(Double.toString(value), this.getDataType(6));
    }

    public LiteralNode addLiteral(double value) throws AllegroGraphException {
        return this.addLiteral(Double.toString(value), this.getDataType(6));
    }

    public LiteralNode createLiteral(float value) {
        return this.createLiteral(Float.toString(value), this.getDataType(5));
    }

    public LiteralNode addLiteral(float value) throws AllegroGraphException {
        return this.addLiteral(Float.toString(value), this.getDataType(5));
    }

    public Triple createStatement(ResourceNode subject, URINode predicate, ValueNode object, ResourceNode context) {
        UPI s = this.queryAGId(subject);
        UPI p = this.queryAGId(predicate);
        UPI o = this.queryAGId(object);
        UPI c = UPIImpl.nullUPI();
        if (context instanceof URINodeImpl) {
            c = this.queryAGId(context);
        }
        TripleImpl b = (TripleImpl)AGFactory.makeTriple(this, s, p, o, c);
        b.subjInstance = subject;
        b.predInstance = predicate;
        b.objInstance = object;
        return b;
    }

    public Triple newTriple(Object s, Object p, Object o) throws AllegroGraphException {
        return this.newTriple(s, p, o, null);
    }

    public long newTripleId(Object s, Object p, Object o) throws AllegroGraphException {
        return this.newTripleId(s, p, o, null);
    }

    public Triple newTriple(Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] tra = this.verifyEnabled().addTriple(this, this.validRef(s), this.validRef(p), this.validRef(o), AllegroGraph.anyContextRef(c, 1));
        Triple tr = AGFactory.makeTriple(this, (Long)tra[0], (UPIImpl)tra[1], (UPIImpl)tra[2], (UPIImpl)tra[3], (UPIImpl)tra[4]);
        return tr;
    }

    public long newTripleId(Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] tra = this.verifyEnabled().addTriple(this, this.validRef(s), this.validRef(p), this.validRef(o), AllegroGraph.anyContextRef(c, 1));
        return (Long)tra[0];
    }

    public Triple[] newTriples(Object s, Object p, Object o) throws AllegroGraphException {
        return this.newTriples(s, p, o, null);
    }

    public Triple[] newTriples(Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] r = this.verifyEnabled().addTriples(this, this.validRefs(s), this.validRefs(p), this.validRefs(o), this.anyContextRefs(c, 1));
        long[] ri = (long[])r[0];
        UPI[] rs = (UPI[])r[1];
        UPI[] rp = (UPI[])r[2];
        UPI[] ro = (UPI[])r[3];
        Triple[] rt = new Triple[ri.length];
        for (int i = 0; i < ri.length; ++i) {
            Triple tr;
            rt[i] = tr = AGFactory.makeTriple(this, ri[i], rs[i], rp[i], ro[i]);
        }
        return rt;
    }

    public long[] newTripleIds(Object s, Object p, Object o) throws AllegroGraphException {
        return this.newTripleIds(s, p, o, null);
    }

    public long[] newTripleIds(Object s, Object p, Object o, Object c) throws AllegroGraphException {
        Object[] r = this.verifyEnabled().addTriples(this, this.validRefs(s), this.validRefs(p), this.validRefs(o), this.anyContextRefs(c, 1));
        return (long[])r[0];
    }

    public void removeStatements(Object s, Object p, Object o) throws AllegroGraphException {
        this.removeStatements(s, p, o, UPIImpl.nullUPI());
    }

    public void removeStatements(Object s, Object p, Object o, Object c) throws AllegroGraphException {
        this.verifyEnabled().delete(this, this.validRefsOrWild(s), this.validRefsOrWild(p), this.validRefsOrWild(o), this.anyContextRefs(c, 3), true);
    }

    public UPI[] createBNodeIds(int n) throws AllegroGraphException {
        return this.verifyEnabled().newBlankNodes(this, n);
    }

    public void removeStatement(Object s, Object p, Object o) throws AllegroGraphException {
        this.removeStatement(s, p, o, UPIImpl.nullUPI());
    }

    public void removeStatement(Object s, Object p, Object o, Object c) throws AllegroGraphException {
        this.verifyEnabled().delete(this, this.validRef(s), this.validRef(p), this.validRef(o), AllegroGraph.anyContextRef(c, 1), false);
    }

    public UPI[] addLiteralIds(String[] values, String[] datatypes, String[] languages) throws AllegroGraphException {
        return this.verifyEnabled().newLiteral((AGBase)this, values, datatypes, languages);
    }

    public ValueSetIterator getFreetextUniqueSubjects(String pattern) throws AllegroGraphException {
        Object[] v = this.verifyEnabled().getFreetextSubjects(this, pattern, this.selectLimit);
        return new ValueSetIteratorImpl(this, v);
    }

    public TriplesIterator getFreetextStatements(String pattern) throws AllegroGraphException {
        return this.verifyEnabled().getFreetextStatements(this, pattern, this.defaultLookAhead);
    }

    public String[] getFreetextPredicates() throws AllegroGraphException {
        return this.verifyEnabled().freetextPredicates(this, null);
    }

    public void registerFreetextPredicate(Object predicate) throws AllegroGraphException {
        this.verifyEnabled().freetextPredicates(this, this.validRefs(predicate));
    }

    Object selectValuesArray(boolean one, Object[] v, boolean nullOk) throws AllegroGraphException {
        if (v == null) {
            if (one) {
                return new ValueObject[0];
            }
            return new ValueObject[0][0];
        }
        UPIImpl[] ids = (UPIImpl[])v[0];
        if (ids == null) {
            if (one) {
                return new ValueObject[0];
            }
            return new ValueObject[0][0];
        }
        int[] types = (int[])v[1];
        String[] labels = (String[])v[2];
        String[] mods = (String[])v[3];
        int more = (Integer)v[4];
        int width = (Integer)v[5];
        if (one && width != 1) {
            throw new IllegalArgumentException("Asked for single result but received " + width);
        }
        Object token = v[6];
        int plimit = (Integer)v[7];
        int all = ids.length;
        Object sv = null;
        if (8 < v.length) {
            sv = v[8];
        }
        if (one) {
            ValueObject[] s = new ValueObject[all];
            for (int i = 0; i < all; ++i) {
                s[i] = this.newSelectValue(nullOk, ids[i], types[i], labels[i], mods[i]);
            }
            return this.registerValues(s, token, more, plimit, sv, nullOk);
        }
        if (width == 0) {
            ValueObject[][] r = new ValueObject[all][0];
            return this.registerValues(r, token, more, plimit, sv, nullOk);
        }
        int n = all / width;
        int i = 0;
        int j = 0;
        ValueObject[][] r = new ValueObject[n][width];
        while (i < all) {
            for (int k = 0; k < width; ++k) {
                r[j][k] = this.newSelectValue(nullOk, ids[i], types[i], labels[i], mods[i]);
                ++i;
            }
            ++j;
        }
        return this.registerValues(r, token, more, plimit, sv, nullOk);
    }

    Object registerValues(Object r, Object token, int more, int plimit, Object sv, boolean nullOk) throws AllegroGraphException {
        if (more > 0 || sv != null) {
            this.ags.valueMap.put(r, new valueMapEntry(this, token, more, plimit, sv, nullOk));
        }
        this.discardOldTokens(false);
        return r;
    }

    public Triple createStatement(ResourceNode subject, URINode predicate, ValueNode object) {
        return this.createStatement(subject, predicate, object, null);
    }

    private int intResult(Object r) {
        return AGConnector.toInt(r);
    }

    public int getUnmergedCount() throws AllegroGraphException {
        Object r = this.verifyEnabled().indexing(this, 2, 0, null);
        return this.intResult(r);
    }

    public int getUnindexedTripleCount() throws AllegroGraphException {
        Object r = this.verifyEnabled().indexing(this, 1, 0, null);
        return this.intResult(r);
    }

    public int getUnindexedThreshold() throws AllegroGraphException {
        Object r = this.verifyEnabled().indexing(this, 3, 0, null);
        return this.intResult(r);
    }

    public void setUnindexedThreshold(int val) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 13, val, null);
    }

    public int getUnmergedThreshold() throws AllegroGraphException {
        Object r = this.verifyEnabled().indexing(this, 4, 0, null);
        return this.intResult(r);
    }

    public void setUnmergedThreshold(int val) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 14, val, null);
    }

    public String[] getIndexFlavors() throws AllegroGraphException {
        Object r = this.verifyEnabled().indexing(this, 5, 0, null);
        if (r == null) {
            return new String[0];
        }
        return (String[])r;
    }

    public void setIndexFlavors(String[] flavors) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 35, 0, flavors);
    }

    public void addIndexFlavors(String[] flavors) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 15, 0, flavors);
    }

    public void dropIndexFlavors(String[] flavors) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 25, 0, flavors);
    }

    public void addDataMapping(String[] map) throws AllegroGraphException {
        this.verifyEnabled().mapping(this, 11, map);
    }

    public void setDataMapping(String[] map) throws AllegroGraphException {
        this.verifyEnabled().mapping(this, 21, map);
    }

    public String[] getDataMapping() throws AllegroGraphException {
        Object r = this.verifyEnabled().mapping(this, 1, null);
        if (r == null) {
            return new String[0];
        }
        if (r instanceof String[]) {
            return (String[])r;
        }
        return new String[0];
    }

    public Object[] evalInServer(String expression) throws AllegroGraphException {
        return this.verifyEnabled().evalInServer(this, expression);
    }

    public int serverTrace(boolean onoff) {
        try {
            this.verifyEnabled().serverTrace(this, onoff, null);
            return 0;
        }
        catch (AllegroGraphException e) {
            return -1;
        }
    }

    public int serverTrace(String outFile) {
        try {
            this.verifyEnabled().serverTrace(this, true, outFile);
            return 0;
        }
        catch (AllegroGraphException e) {
            return -1;
        }
    }

    public String[] getNamespaces() {
        if (this.nsregs == null) {
            return new String[0];
        }
        return this.nsregs.toArray();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (null == this.nsregs) {
            return null;
        }
        return new NamespaceRegistry(this.nsregs);
    }

    public void registerNamespace(String prefix, String full) throws AllegroGraphException {
        this.nsregsInit().register(prefix, full);
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void registerNamespaces(String[] defs) throws AllegroGraphException {
        if (defs == null) {
            return;
        }
        if (0 == defs.length) {
            return;
        }
        this.nsregsInit();
        for (int i = 0; i < defs.length; i += 2) {
            this.nsregs.register(defs[i], defs[i + 1]);
        }
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void registerNamespaces(NamespaceRegistry ns) throws AllegroGraphException {
        this.nsregsInit().register(ns);
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void registerNamespaces(com.franz.ag.NamespaceRegistry ns) throws AllegroGraphException {
        this.nsregsInit().register(ns);
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void setNamespaceRegistry(NamespaceRegistry ns) throws AllegroGraphException {
        this.nsregs = new NamespaceRegistry(ns);
        this.verifyEnabled().namespaces(this, this.nsregs == null ? null : this.nsregs.toArray());
    }

    public void setNamespaceRegistry(com.franz.ag.NamespaceRegistry ns) throws AllegroGraphException {
        this.nsregs = new NamespaceRegistry(ns);
        this.verifyEnabled().namespaces(this, this.nsregs == null ? null : this.nsregs.toArray());
    }

    public void setNamespaceRegistry() throws AllegroGraphException {
        this.nsregs = this.ags == null ? null : (null == this.ags.nsregs ? null : new NamespaceRegistry(this.ags.nsregs));
        this.verifyEnabled().namespaces(this, this.nsregs == null ? null : this.nsregs.toArray());
    }

    public ValueNode addPart(String part) throws AllegroGraphException {
        if (part.startsWith("_:")) {
            return this.createBNode(part);
        }
        Object[] r = this.verifyEnabled().addPart(this, AllegroGraph.refNtripleString(part));
        UPIImpl upi = r[0] instanceof UPIImpl ? (UPIImpl)r[0] : null;
        int type = 0;
        if (1 < r.length) {
            type = (int)AGConnector.longValue(r[1]);
        }
        String val = null;
        String mod = null;
        if (2 < r.length) {
            val = (String)r[2];
        }
        if (3 < r.length) {
            val = (String)r[3];
        }
        return (ValueNode)this.newValue(upi, type, val, mod);
    }

    protected AllegroGraph(AllegroGraphConnection sv, String name, AGInternals[] parts, boolean supersede) throws AllegroGraphException {
        this.ags = sv;
        this.storeName = name;
        this.storeDirectory = null;
        int[] iparts = new int[parts.length];
        for (int i = 0; i < iparts.length; ++i) {
            if (parts[i].ags != sv) {
                throw new AllegroGraphException("Component of federated triple store must be opened on same connection.");
            }
            if (0 > parts[i].tsx) {
                throw new AllegroGraphException("Components of federated triple store must be open triple stores.");
            }
            iparts[i] = parts[i].tsx;
        }
        this.tsx = this.verifyEnabled().federate(name, iparts, supersede);
        this.ags.addTS(this);
        this.initNamespaces();
    }

    protected AllegroGraph(AllegroGraphConnection sv, String name, String directory) throws AllegroGraphException {
        this.ags = sv;
        this.storeName = name;
        this.storeDirectory = directory;
        Object[] ra = this.verifyEnabled().findStore(name, directory, null);
        if (null == ra) {
            throw new AllegroGraphException("Could not find triple store.");
        }
        this.tsx = (Integer)ra[0];
        this.storeName = (String)ra[1];
        this.storeDirectory = (String)ra[2];
        this.ags.addTS(this);
    }

    public AllegroGraph(String name) {
        this.storeName = name;
    }

    protected AllegroGraph(AGInternals from, int ix, String name, String directory) {
        this.ags = from.ags;
        this.storeName = name;
        this.storeDirectory = directory;
        this.tsx = ix;
        this.ags.addTS(this);
    }

    public AllegroGraph[] getStores() throws AllegroGraphException {
        Object[] r = this.verifyEnabled().getStores(this);
        if (null == r) {
            return null;
        }
        AllegroGraph[] ra = new AllegroGraph[r.length / 3];
        for (int i = 0; i < ra.length; ++i) {
            ra[i] = new AllegroGraph(this, (Integer)r[i * 3], (String)r[1 + i * 3], (String)r[2 + i * 3]);
        }
        return ra;
    }

    public boolean getSyncEveryTime() {
        return this.sync;
    }

    public void setSyncEveryTime(boolean s) {
        this.sync = s;
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.tsx + " " + this.storeName + ">";
    }

    public SNAExtension getSNAExtension() {
        if (null == this.sna) {
            this.sna = new SNAExtension(this);
        }
        return this.sna;
    }

    public GeoExtension getGeoExtension() {
        if (null == this.geo) {
            this.geo = new GeoExtension(this);
        }
        return this.geo;
    }

    private Object ntripleContext(Object c) throws AllegroGraphException {
        if (c instanceof String && "source".equalsIgnoreCase((String)c)) {
            return "source";
        }
        return AllegroGraph.anyContextRef(c, 1);
    }

    public boolean isSPOGICacheEnabled() throws AllegroGraphException {
        Object[] v = this.verifyEnabled().clientOption(this, "spogi-cache", "state", -1);
        if (v == null) {
            return false;
        }
        if (0 == v.length) {
            return false;
        }
        return 1L == AGConnector.longValue(v[0]);
    }

    public void setSPOGICacheEnabled(boolean onoff) throws AllegroGraphException {
        this.verifyEnabled().clientOption(this, "spogi-cache", "state", onoff ? 1 : 0);
    }

    public long getSPOGICacheSize() throws AllegroGraphException {
        Object[] v = this.verifyEnabled().clientOption(this, "spogi-cache", "size", -1);
        return AGConnector.longValue(v[0]);
    }

    public void setSPOGICacheSize(long size) throws AllegroGraphException {
        this.verifyEnabled().clientOption(this, "spogi-cache", "size", size);
    }

    public String getUPIMapDirectory() throws AllegroGraphException {
        Object[] r = this.verifyEnabled().clientOption(this, "upi-map");
        if (r == null) {
            return null;
        }
        if (1 > r.length) {
            return null;
        }
        return (String)r[0];
    }

    public void setUPIMapDirectory(String dir) throws AllegroGraphException {
        this.verifyEnabled().clientOption(this, "upi-map", "directory", dir);
    }

    static class valueMapEntry {
        Object savedToken;
        int savedMore;
        AGInternals savedAG;
        Object savedVal = null;
        int savedPlimit;
        boolean savedNullOk;

        public valueMapEntry(AGInternals ag, Object token, int more, int pl, Object sv, boolean nullOk) {
            this.savedToken = token;
            this.savedMore = more;
            this.savedAG = ag;
            this.savedPlimit = pl;
            this.savedVal = sv;
            this.savedNullOk = nullOk;
        }

        protected synchronized void finalize() throws Throwable {
            if (this.savedAG.ags == null) {
                return;
            }
            if (null != this.savedToken) {
                this.savedAG.ags.oldTokens.add(this.savedToken);
            }
        }
    }

    public static enum StoreAttribute {
        EXPECTED_UNIQUE_RESOURCES("expected-unique-resources"),
        WITH_INDICES("with-indices"),
        INCLUDE_STANDARD_PARTS("include-standard-parts"),
        READ_ONLY("read-only"),
        INDIRECT_HOST("indirect-host"),
        INDIRECT_PORT("indirect-port");

        private String value;

        private StoreAttribute(String value) {
            this.value = value;
        }

        private String value() {
            return this.value;
        }
    }

    public static class V3_2BaseSep04 {
    }
}

