/*
 * Decompiled with CFR 0.152.
 */
package com.foxtrot.flipkart.translator;

import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.DocumentMetadata;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.common.util.Utils;
import com.foxtrot.flipkart.translator.IdentityKeyDistributor;
import com.foxtrot.flipkart.translator.config.TranslatorConfig;
import com.foxtrot.flipkart.translator.utils.Constants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.sematext.hbase.ds.AbstractRowKeyDistributor;
import com.sematext.hbase.ds.RowKeyDistributorByHashPrefix;
import java.util.List;
import javax.inject.Inject;
import org.apache.hadoop.hbase.util.Bytes;

public class DocumentTranslator {
    private static final String EXCEPTION_MESSAGE = "rawKeyVersion not supported version=[%s]";
    private final AbstractRowKeyDistributor keyDistributor;
    private String rawKeyVersion;

    @Inject
    public DocumentTranslator(TranslatorConfig translatorConfig) {
        if (CollectionUtils.isNullOrEmpty((String)translatorConfig.getRawKeyVersion()) || translatorConfig.getRawKeyVersion().equalsIgnoreCase("1.0")) {
            this.keyDistributor = new IdentityKeyDistributor();
            this.rawKeyVersion = "1.0";
        } else if (translatorConfig.getRawKeyVersion().equalsIgnoreCase("2.0")) {
            this.keyDistributor = new RowKeyDistributorByHashPrefix((RowKeyDistributorByHashPrefix.Hasher)new RowKeyDistributorByHashPrefix.OneByteSimpleHash(32));
            this.rawKeyVersion = "2.0";
        } else {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, translatorConfig.getRawKeyVersion()));
        }
    }

    public List<Document> translate(Table table, List<Document> inDocuments) {
        ImmutableList.Builder docListBuilder = ImmutableList.builder();
        for (Document document : inDocuments) {
            docListBuilder.add((Object)this.translate(table, document));
        }
        return docListBuilder.build();
    }

    public Document translate(Table table, Document inDocument) {
        Document document = new Document();
        DocumentMetadata metadata = this.metadata(table, inDocument);
        switch (this.rawKeyVersion) {
            case "1.0": {
                document.setId(inDocument.getId());
                break;
            }
            case "2.0": {
                document.setId(metadata.getRawStorageId());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, this.rawKeyVersion));
            }
        }
        document.setTimestamp(inDocument.getTimestamp());
        document.setMetadata(metadata);
        document.setData(inDocument.getData());
        document.setDate(Utils.getDate((long)inDocument.getTimestamp()));
        return document;
    }

    public Document translateBack(Document inDocument) {
        Document document = new Document();
        document.setId(inDocument.getMetadata() != null ? inDocument.getMetadata().getId() : inDocument.getId());
        document.setTimestamp(inDocument.getTimestamp());
        document.setData(inDocument.getData());
        document.setDate(Utils.getDate((long)inDocument.getTimestamp()));
        return document;
    }

    private DocumentMetadata metadata(Table table, Document inDocument) {
        String rowKey = this.generateScalableKey(this.rawStorageIdFromDocument(table, inDocument));
        DocumentMetadata metadata = new DocumentMetadata();
        metadata.setRawStorageId(rowKey);
        metadata.setId(inDocument.getId());
        metadata.setTime(inDocument.getTimestamp());
        return metadata;
    }

    private String rawStorageIdFromDocument(Table table, Document document) {
        switch (this.rawKeyVersion) {
            case "1.0": {
                return document.getId() + ":" + table.getName();
            }
            case "2.0": {
                return String.format("%s:%020d:%s:%s", table.getName(), document.getTimestamp(), document.getId(), Constants.RAW_KEY_VERSION_TO_SUFFIX_MAP.get(this.rawKeyVersion));
            }
        }
        throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, this.rawKeyVersion));
    }

    @VisibleForTesting
    public String generateScalableKey(String id) {
        return new String(this.keyDistributor.getDistributedKey(Bytes.toBytes((String)id)));
    }

    public String rawStorageIdFromDocumentId(Table table, String id) {
        if (id.endsWith(Constants.RAW_KEY_VERSION_TO_SUFFIX_MAP.get("2.0"))) {
            return id;
        }
        return String.format("%s:%s", id, table.getName());
    }
}

