/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.sql.fqlstore;

import com.collections.CollectionUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.core.exception.FqlPersistenceException;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.sql.fqlstore.FqlGetRequest;
import com.flipkart.foxtrot.sql.fqlstore.FqlStore;
import com.flipkart.foxtrot.sql.fqlstore.FqlStoreService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FqlStoreServiceImpl
implements FqlStoreService {
    private static final Logger logger = LoggerFactory.getLogger(FqlStore.class);
    private static final String FQL_STORE_INDEX = "fql-store";
    private final ElasticsearchConnection elasticsearchConnection;
    private final ObjectMapper objectMapper;

    @Inject
    public FqlStoreServiceImpl(ElasticsearchConnection elasticsearchConnection, ObjectMapper objectMapper) {
        this.elasticsearchConnection = elasticsearchConnection;
        this.objectMapper = objectMapper;
    }

    @Override
    public void save(FqlStore fqlStore) {
        fqlStore.setId(UUID.randomUUID().toString());
        try {
            ((IndexRequestBuilder)this.elasticsearchConnection.getClient().prepareIndex().setIndex(FQL_STORE_INDEX)).setType("document").setId(fqlStore.getId()).setSource(this.objectMapper.writeValueAsBytes((Object)fqlStore), XContentType.JSON).execute().get();
            logger.info("Saved FQL Query : {}", (Object)fqlStore.getQuery());
        }
        catch (Exception e) {
            throw new FqlPersistenceException("Couldn't save FQL query: " + fqlStore.getQuery() + " Error Message: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<FqlStore> get(FqlGetRequest fqlGetRequest) {
        ArrayList<FqlStore> fqlStoreList = new ArrayList<FqlStore>();
        try {
            SearchHits searchHits = ((SearchResponse)this.elasticsearchConnection.getClient().prepareSearch(new String[]{FQL_STORE_INDEX}).setTypes(new String[]{"document"}).setQuery((QueryBuilder)QueryBuilders.prefixQuery((String)"title", (String)fqlGetRequest.getTitle().toLowerCase())).setSearchType(SearchType.QUERY_THEN_FETCH).setFrom(fqlGetRequest.getFrom()).setSize(fqlGetRequest.getSize()).execute().actionGet()).getHits();
            for (SearchHit searchHit : CollectionUtils.nullAndEmptySafeValueList((Object[])searchHits.getHits())) {
                fqlStoreList.add((FqlStore)this.objectMapper.readValue(searchHit.getSourceAsString(), FqlStore.class));
            }
        }
        catch (Exception e) {
            throw new FqlPersistenceException("Couldn't get FqlStore: " + e.getMessage(), (Throwable)e);
        }
        return fqlStoreList;
    }
}

