/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.ResponseVisitor;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.core.querystore.QueryExecutor;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.sql.FqlQuery;
import com.flipkart.foxtrot.sql.FqlQueryVisitor;
import com.flipkart.foxtrot.sql.QueryTranslator;
import com.flipkart.foxtrot.sql.query.FqlActionQuery;
import com.flipkart.foxtrot.sql.query.FqlDescribeTable;
import com.flipkart.foxtrot.sql.query.FqlShowTablesQuery;
import com.flipkart.foxtrot.sql.responseprocessors.Flattener;
import com.flipkart.foxtrot.sql.responseprocessors.FlatteningUtils;
import com.flipkart.foxtrot.sql.responseprocessors.model.FlatRepresentation;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FqlEngine {
    private static final Logger logger = LoggerFactory.getLogger((String)FqlEngine.class.getSimpleName());
    private TableMetadataManager tableMetadataManager;
    private QueryStore queryStore;
    private QueryExecutor queryExecutor;
    private ObjectMapper mapper;

    @Inject
    public FqlEngine(TableMetadataManager tableMetadataManager, QueryStore queryStore, QueryExecutor queryExecutor, ObjectMapper mapper) {
        this.tableMetadataManager = tableMetadataManager;
        this.queryStore = queryStore;
        this.queryExecutor = queryExecutor;
        this.mapper = mapper;
    }

    public FlatRepresentation parse(String fql) throws Exception {
        QueryTranslator translator = new QueryTranslator();
        FqlQuery query = translator.translate(fql);
        FlatRepresentation response = new QueryProcessor(this.tableMetadataManager, this.queryStore, this.queryExecutor, this.mapper).process(query);
        logger.debug("Flat Response: " + this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response));
        return response;
    }

    private static final class QueryProcessor
    implements FqlQueryVisitor {
        private TableMetadataManager tableMetadataManager;
        private QueryStore queryStore;
        private QueryExecutor queryExecutor;
        private ObjectMapper mapper;
        private FlatRepresentation result;

        private QueryProcessor(TableMetadataManager tableMetadataManager, QueryStore queryStore, QueryExecutor queryExecutor, ObjectMapper mapper) {
            this.tableMetadataManager = tableMetadataManager;
            this.queryStore = queryStore;
            this.queryExecutor = queryExecutor;
            this.mapper = mapper;
        }

        public FlatRepresentation process(FqlQuery query) {
            query.receive(this);
            return this.result;
        }

        @Override
        public void visit(FqlDescribeTable fqlDescribeTable) {
            TableFieldMapping fieldMetaData = this.queryStore.getFieldMappings(fqlDescribeTable.getTableName());
            this.result = FlatteningUtils.genericMultiRowParse(this.mapper.valueToTree((Object)fieldMetaData.getMappings()), Lists.newArrayList((Object[])new String[]{"field", "type"}), "field");
        }

        @Override
        public void visit(FqlShowTablesQuery fqlShowTablesQuery) {
            List tables = this.tableMetadataManager.get();
            this.result = FlatteningUtils.genericMultiRowParse(this.mapper.valueToTree((Object)tables), Lists.newArrayList((Object[])new String[]{"name", "ttl"}), "name");
        }

        @Override
        public void visit(FqlActionQuery fqlActionQuery) {
            try {
                String query = this.mapper.writeValueAsString((Object)fqlActionQuery.getActionRequest());
                logger.info("Generated query: {}", (Object)query);
            }
            catch (JsonProcessingException e) {
                logger.error("Error in serializing action request.", (Throwable)e);
            }
            ActionResponse actionResponse = this.queryExecutor.execute(fqlActionQuery.getActionRequest());
            Flattener flattener = new Flattener(this.mapper, fqlActionQuery.getActionRequest(), fqlActionQuery.getSelectedFields());
            actionResponse.accept((ResponseVisitor)flattener);
            this.result = flattener.getFlatRepresentation();
        }
    }
}

