/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.sql.responseprocessors;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.sql.responseprocessors.model.FieldHeader;
import com.flipkart.foxtrot.sql.responseprocessors.model.FlatRepresentation;
import com.flipkart.foxtrot.sql.responseprocessors.model.MetaData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatteningUtils {
    private static final Logger log = LoggerFactory.getLogger(FlatteningUtils.class);
    private static final String DEFAULT_SEPARATOR = ".";

    private FlatteningUtils() {
    }

    public static FlatRepresentation genericParse(JsonNode response) {
        ArrayList headers = Lists.newArrayList();
        Map<String, MetaData> docFields = FlatteningUtils.generateFieldMappings(null, response);
        TreeMap row = Maps.newTreeMap();
        for (Map.Entry<String, MetaData> docField : docFields.entrySet()) {
            row.put(docField.getKey(), docField.getValue().getData());
            headers.add(new FieldHeader(docField.getKey(), 20));
        }
        return new FlatRepresentation(headers, Collections.singletonList(row));
    }

    public static FlatRepresentation genericMultiRowParse(JsonNode response, List<String> predefinedHeaders, String sortField) {
        ArrayList headers = Lists.newArrayList();
        ArrayList rows = Lists.newArrayList();
        TreeMap headerData = Maps.newTreeMap();
        for (JsonNode arrayElement : response) {
            Map<String, MetaData> element = FlatteningUtils.generateFieldMappings(null, arrayElement);
            HashMap row2 = Maps.newHashMap();
            for (Map.Entry<String, MetaData> elementData : element.entrySet()) {
                if (!headerData.containsKey(elementData.getKey())) {
                    headerData.put(elementData.getKey(), elementData.getValue().getLength());
                }
                headerData.put(elementData.getKey(), Math.max(elementData.getValue().getLength(), (Integer)headerData.get(elementData.getKey())));
                row2.put(elementData.getKey(), elementData.getValue().getData());
            }
            rows.add(row2);
        }
        if (!Strings.isNullOrEmpty((String)sortField)) {
            rows.sort(Comparator.comparing(row -> row.get(sortField).toString()));
        }
        FlatteningUtils.populateHeaders(predefinedHeaders, headerData, headers);
        return new FlatRepresentation(headers, rows);
    }

    private static void populateHeaders(List<String> predefinedHeaders, Map<String, Integer> headerData, List<FieldHeader> headers) {
        if (!CollectionUtils.isNullOrEmpty(predefinedHeaders)) {
            for (String predefinedHeader : predefinedHeaders) {
                if (!headerData.containsKey(predefinedHeader)) continue;
                headers.add(new FieldHeader(predefinedHeader, headerData.get(predefinedHeader)));
            }
        } else {
            for (Map.Entry<String, Integer> entry : headerData.entrySet()) {
                headers.add(new FieldHeader(entry.getKey(), entry.getValue()));
            }
        }
    }

    public static Map<String, MetaData> generateFieldMappings(String parentField, JsonNode jsonNode) {
        return FlatteningUtils.generateFieldMappings(parentField, jsonNode, DEFAULT_SEPARATOR);
    }

    public static Map<String, MetaData> generateFieldMappings(String parentField, JsonNode jsonNode, String separator) {
        TreeMap fields = Maps.newTreeMap();
        if (null == jsonNode) {
            log.info("NULL for {}", (Object)parentField);
            return Collections.emptyMap();
        }
        if (jsonNode.isArray()) {
            int index = 0;
            for (JsonNode arrayElement : jsonNode) {
                if (!FlatteningUtils.isArrayOrObject(arrayElement)) {
                    fields.put(parentField + separator + Integer.toString(index), new MetaData(arrayElement, arrayElement.toString().length()));
                } else {
                    Map<String, MetaData> tmpFields = FlatteningUtils.generateFieldMappings(parentField, arrayElement, separator);
                    fields.putAll(tmpFields);
                }
                ++index;
            }
        }
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            String currentField;
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = currentField = parentField == null ? (String)entry.getKey() : String.format("%s%s%s", parentField, separator, entry.getKey());
            if (FlatteningUtils.isArrayOrObject((JsonNode)entry.getValue())) {
                fields.putAll(FlatteningUtils.generateFieldMappings(currentField, (JsonNode)entry.getValue(), separator));
                continue;
            }
            fields.put(currentField, new MetaData(entry.getValue(), ((JsonNode)entry.getValue()).toString().length()));
        }
        return fields;
    }

    private static boolean isArrayOrObject(JsonNode jsonNode) {
        return jsonNode.isArray() || jsonNode.isObject();
    }
}

