/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.sql.responseprocessors;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.foxtrot.sql.responseprocessors.model.FieldHeader;
import com.flipkart.foxtrot.sql.responseprocessors.model.FlatRepresentation;
import com.flipkart.foxtrot.sql.responseprocessors.model.MetaData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FlatteningUtils {
    private static final String DEFAULT_SEPARATOR = ".";

    public static FlatRepresentation genericParse(JsonNode response) {
        ArrayList headers = Lists.newArrayList();
        Map<String, MetaData> docFields = FlatteningUtils.generateFieldMappings(null, response);
        TreeMap row = Maps.newTreeMap();
        for (Map.Entry<String, MetaData> docField : docFields.entrySet()) {
            row.put(docField.getKey(), docField.getValue().getData());
            headers.add(new FieldHeader(docField.getKey(), 20));
        }
        return new FlatRepresentation(headers, Collections.singletonList(row));
    }

    public static FlatRepresentation genericMultiRowParse(JsonNode response, List<String> predefinedHeaders, final String sortField) {
        ArrayList headers = Lists.newArrayList();
        ArrayList rows = Lists.newArrayList();
        TreeMap headerData = Maps.newTreeMap();
        for (JsonNode jsonNode : response) {
            Map<String, MetaData> element = FlatteningUtils.generateFieldMappings(null, jsonNode);
            HashMap row = Maps.newHashMap();
            for (Map.Entry<String, MetaData> elementData : element.entrySet()) {
                if (!headerData.containsKey(elementData.getKey())) {
                    headerData.put(elementData.getKey(), elementData.getValue().getLength());
                }
                headerData.put(elementData.getKey(), Math.max(elementData.getValue().getLength(), (Integer)headerData.get(elementData.getKey())));
                row.put(elementData.getKey(), elementData.getValue().getData());
            }
            rows.add(row);
        }
        if (null != sortField && !sortField.isEmpty()) {
            Collections.sort(rows, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                    return lhs.get(sortField).toString().compareTo(rhs.get(sortField).toString());
                }
            });
        }
        if (null != predefinedHeaders && !predefinedHeaders.isEmpty()) {
            for (String string : predefinedHeaders) {
                if (!headerData.containsKey(string)) continue;
                headers.add(new FieldHeader(string, (Integer)headerData.get(string)));
            }
        } else {
            for (Map.Entry entry : headerData.entrySet()) {
                headers.add(new FieldHeader((String)entry.getKey(), (Integer)entry.getValue()));
            }
        }
        return new FlatRepresentation(headers, rows);
    }

    public static Map<String, MetaData> generateFieldMappings(String parentField, JsonNode jsonNode) {
        return FlatteningUtils.generateFieldMappings(parentField, jsonNode, DEFAULT_SEPARATOR);
    }

    public static Map<String, MetaData> generateFieldMappings(String parentField, JsonNode jsonNode, String separator) {
        TreeMap fields = Maps.newTreeMap();
        if (null == jsonNode) {
            System.out.println("NULL for " + parentField);
            return Collections.emptyMap();
        }
        if (jsonNode.isArray()) {
            for (JsonNode arrayElement : jsonNode) {
                Map<String, MetaData> tmpFields = FlatteningUtils.generateFieldMappings(parentField, arrayElement, separator);
                fields.putAll(tmpFields);
            }
        }
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            String currentField;
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = currentField = parentField == null ? (String)entry.getKey() : String.format("%s%s%s", parentField, separator, entry.getKey());
            if (((JsonNode)entry.getValue()).isObject() || ((JsonNode)entry.getValue()).isArray()) {
                fields.putAll(FlatteningUtils.generateFieldMappings(currentField, (JsonNode)entry.getValue(), separator));
                continue;
            }
            fields.put(currentField, new MetaData(entry.getValue(), ((JsonNode)entry.getValue()).toString().length()));
        }
        return fields;
    }
}

