/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.sql.responseprocessors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.ResponseVisitor;
import com.flipkart.foxtrot.common.count.CountResponse;
import com.flipkart.foxtrot.common.distinct.DistinctResponse;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.common.histogram.HistogramResponse;
import com.flipkart.foxtrot.common.query.QueryResponse;
import com.flipkart.foxtrot.common.stats.StatsResponse;
import com.flipkart.foxtrot.common.stats.StatsTrendResponse;
import com.flipkart.foxtrot.common.stats.StatsTrendValue;
import com.flipkart.foxtrot.common.trend.TrendResponse;
import com.flipkart.foxtrot.sql.responseprocessors.FlatteningUtils;
import com.flipkart.foxtrot.sql.responseprocessors.model.FieldHeader;
import com.flipkart.foxtrot.sql.responseprocessors.model.FlatRepresentation;
import com.flipkart.foxtrot.sql.responseprocessors.model.MetaData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Flattener
implements ResponseVisitor {
    private FlatRepresentation flatRepresentation;
    private ObjectMapper objectMapper;
    private ActionRequest request;
    private final List<String> fieldsToReturn;

    public Flattener(ObjectMapper objectMapper, ActionRequest request, List<String> fieldsToReturn) {
        this.objectMapper = objectMapper;
        this.request = request;
        this.fieldsToReturn = fieldsToReturn;
    }

    public void visit(GroupResponse groupResponse) {
        String separator = "__SEPARATOR__";
        TreeMap fieldNames = Maps.newTreeMap();
        Map<String, MetaData> dataFields = FlatteningUtils.generateFieldMappings(null, this.objectMapper.valueToTree((Object)groupResponse.getResult()), "__SEPARATOR__");
        GroupRequest groupRequest = (GroupRequest)this.request;
        ArrayList rows = Lists.newArrayList();
        for (Map.Entry<String, MetaData> groupData : dataFields.entrySet()) {
            String[] values = groupData.getKey().split("__SEPARATOR__");
            HashMap row = Maps.newHashMap();
            for (int i = 0; i < groupRequest.getNesting().size(); ++i) {
                String fieldName = (String)groupRequest.getNesting().get(i);
                row.put(fieldName, values[i]);
                if (!fieldNames.containsKey(fieldName)) {
                    fieldNames.put(fieldName, 0);
                }
                fieldNames.put(fieldName, this.lengthMax((Integer)fieldNames.get(fieldName), values[i]));
            }
            row.put("count", groupData.getValue().getData());
            rows.add(row);
        }
        fieldNames.put("count", 10);
        ArrayList headers = Lists.newArrayList();
        for (String fieldName : groupRequest.getNesting()) {
            headers.add(new FieldHeader(fieldName, (Integer)fieldNames.get(fieldName)));
        }
        headers.add(new FieldHeader("count", 10));
        this.flatRepresentation = new FlatRepresentation("group", headers, rows);
    }

    public void visit(HistogramResponse histogramResponse) {
        ArrayList rows = Lists.newArrayList();
        rows.addAll(histogramResponse.getCounts().stream().map(count -> new HashMap<String, Object>(){
            {
                this.put("timestamp", count.getPeriod());
                this.put("count", count.getCount());
            }
        }).collect(Collectors.toList()));
        ArrayList headers = Lists.newArrayList();
        headers.add(new FieldHeader("timestamp", 15));
        headers.add(new FieldHeader("count", 15));
        this.flatRepresentation = new FlatRepresentation("histogram", headers, rows);
    }

    public void visit(QueryResponse queryResponse) {
        TreeMap fieldNames = Maps.newTreeMap();
        ArrayList rows = Lists.newArrayList();
        HashSet<String> fieldToLookup = null == this.fieldsToReturn ? Collections.emptySet() : new HashSet<String>(this.fieldsToReturn);
        boolean isAllFields = fieldToLookup.isEmpty();
        for (Document document : queryResponse.getDocuments()) {
            Map<String, MetaData> docFields = FlatteningUtils.generateFieldMappings(null, this.objectMapper.valueToTree((Object)document));
            TreeMap row = Maps.newTreeMap();
            for (Map.Entry<String, MetaData> docField : docFields.entrySet()) {
                String fieldName = docField.getKey();
                String prettyFieldName = fieldName.replaceFirst("data.", "");
                if (!isAllFields && !fieldToLookup.contains(prettyFieldName)) continue;
                row.put(prettyFieldName, docField.getValue().getData());
                if (!fieldNames.containsKey(prettyFieldName)) {
                    fieldNames.put(prettyFieldName, 0);
                }
                fieldNames.put(prettyFieldName, Math.max((Integer)fieldNames.get(prettyFieldName), docField.getValue().getLength()));
            }
            rows.add(row);
        }
        if (!rows.isEmpty()) {
            this.flatRepresentation = new FlatRepresentation("query", this.getFieldsFromList(fieldNames), rows);
        }
    }

    public void visit(StatsResponse statsResponse) {
        this.flatRepresentation = FlatteningUtils.genericParse(this.objectMapper.valueToTree((Object)statsResponse.getResult()));
        ArrayList headers = Lists.newArrayList();
        headers.add(new FieldHeader("percentiles.1.0", 20));
        headers.add(new FieldHeader("percentiles.5.0", 20));
        headers.add(new FieldHeader("percentiles.25.0", 20));
        headers.add(new FieldHeader("percentiles.50.0", 20));
        headers.add(new FieldHeader("percentiles.75.0", 20));
        headers.add(new FieldHeader("percentiles.95.0", 20));
        headers.add(new FieldHeader("percentiles.99.0", 20));
        headers.add(new FieldHeader("stats.count", 20));
        headers.add(new FieldHeader("stats.avg", 20));
        headers.add(new FieldHeader("stats.max", 20));
        headers.add(new FieldHeader("stats.min", 20));
        headers.add(new FieldHeader("stats.sum", 20));
        headers.add(new FieldHeader("stats.sum_of_squares", 20));
        headers.add(new FieldHeader("stats.variance", 20));
        headers.add(new FieldHeader("stats.std_deviation", 20));
        this.flatRepresentation.setHeaders(headers);
        this.flatRepresentation.setOpcode("stats");
    }

    public void visit(StatsTrendResponse statsTrendResponse) {
        HashSet headers = Sets.newHashSet();
        ArrayList rows = Lists.newArrayList();
        for (StatsTrendValue statsTrendValue : statsTrendResponse.getResult()) {
            FlatRepresentation tmpFlatR = FlatteningUtils.genericParse(this.objectMapper.valueToTree((Object)statsTrendValue));
            headers.addAll(tmpFlatR.getHeaders());
            rows.add(tmpFlatR.getRows().get(0));
        }
        ArrayList fieldHeaders = Lists.newArrayList();
        fieldHeaders.add(new FieldHeader("period", 20));
        fieldHeaders.add(new FieldHeader("percentiles.1.0", 20));
        fieldHeaders.add(new FieldHeader("percentiles.5.0", 20));
        fieldHeaders.add(new FieldHeader("percentiles.25.0", 20));
        fieldHeaders.add(new FieldHeader("percentiles.50.0", 20));
        fieldHeaders.add(new FieldHeader("percentiles.75.0", 20));
        fieldHeaders.add(new FieldHeader("percentiles.95.0", 20));
        fieldHeaders.add(new FieldHeader("percentiles.99.0", 20));
        fieldHeaders.add(new FieldHeader("stats.count", 20));
        fieldHeaders.add(new FieldHeader("stats.avg", 20));
        fieldHeaders.add(new FieldHeader("stats.max", 20));
        fieldHeaders.add(new FieldHeader("stats.min", 20));
        fieldHeaders.add(new FieldHeader("stats.sum", 20));
        fieldHeaders.add(new FieldHeader("stats.sum_of_squares", 20));
        fieldHeaders.add(new FieldHeader("stats.variance", 20));
        fieldHeaders.add(new FieldHeader("stats.std_deviation", 20));
        this.flatRepresentation = new FlatRepresentation("statstrend", fieldHeaders, rows);
    }

    public void visit(TrendResponse trendResponse) {
        ArrayList headers = Lists.newArrayListWithCapacity((int)3);
        JsonNode root = this.objectMapper.valueToTree((Object)trendResponse.getTrends());
        if (null == root || !root.isObject()) {
            return;
        }
        ArrayList types = Lists.newArrayList();
        ArrayList rows = Lists.newArrayList();
        Iterator typeNameIt = root.fieldNames();
        TreeMap representation = Maps.newTreeMap();
        int typeNameMaxLength = 0;
        while (typeNameIt.hasNext()) {
            String typeName = (String)typeNameIt.next();
            types.add(typeName);
            typeNameMaxLength = Math.max(typeNameMaxLength, typeName.length());
            for (JsonNode dataNode : root.get(typeName)) {
                String time = Long.toString(dataNode.get("period").asLong());
                if (!representation.containsKey(time)) {
                    representation.put(time, Maps.newHashMap());
                }
                ((Map)representation.get(time)).put(typeName, dataNode.get("count").asLong());
            }
        }
        headers.add(new FieldHeader("time", 20));
        for (String string : types) {
            headers.add(new FieldHeader(string, 20));
        }
        for (Map.Entry entry : representation.entrySet()) {
            TreeMap row = Maps.newTreeMap();
            row.put("time", entry.getKey());
            for (Map.Entry data : ((Map)entry.getValue()).entrySet()) {
                row.put(data.getKey(), data.getValue());
            }
            rows.add(row);
        }
        this.flatRepresentation = new FlatRepresentation("trend", new ArrayList<FieldHeader>(headers), rows);
    }

    public void visit(CountResponse countResponse) {
        FieldHeader fieldHeader = new FieldHeader("count", 20);
        ArrayList rows = Lists.newArrayList();
        rows.add(Collections.singletonMap("count", countResponse.getCount()));
        this.flatRepresentation = new FlatRepresentation("count", Arrays.asList(fieldHeader), rows);
    }

    public void visit(DistinctResponse distinctResponse) {
        ArrayList fieldHeaders = Lists.newArrayList();
        for (String header : distinctResponse.getHeaders()) {
            fieldHeaders.add(new FieldHeader(header, 10));
        }
        List distinctResponseRows = distinctResponse.getResult();
        ArrayList rows = Lists.newArrayList();
        for (List responseRow : distinctResponseRows) {
            HashMap row = Maps.newHashMap();
            for (int i = 0; i < fieldHeaders.size(); ++i) {
                row.put(((FieldHeader)fieldHeaders.get(i)).getName(), responseRow.get(i));
            }
            rows.add(row);
        }
        this.flatRepresentation = new FlatRepresentation("distinct", fieldHeaders, rows);
    }

    public FlatRepresentation getFlatRepresentation() {
        return this.flatRepresentation;
    }

    private int lengthMax(int currMax, String rhs) {
        return currMax > rhs.length() ? currMax : rhs.length();
    }

    private List<FieldHeader> getFieldsFromList(Map<String, Integer> fieldNames) {
        ArrayList headers = Lists.newArrayList();
        if (null == this.fieldsToReturn || this.fieldsToReturn.isEmpty()) {
            for (Map.Entry<String, Integer> entry : fieldNames.entrySet()) {
                headers.add(new FieldHeader(entry.getKey(), entry.getValue()));
            }
        } else {
            for (String fieldName : this.fieldsToReturn) {
                headers.add(new FieldHeader(fieldName, fieldNames.get(fieldName)));
            }
        }
        return headers;
    }
}

