/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.sql;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.count.CountRequest;
import com.flipkart.foxtrot.common.distinct.DistinctRequest;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.histogram.HistogramRequest;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.Query;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.general.ExistsFilter;
import com.flipkart.foxtrot.common.query.general.InFilter;
import com.flipkart.foxtrot.common.query.general.MissingFilter;
import com.flipkart.foxtrot.common.query.general.NotEqualsFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.query.string.ContainsFilter;
import com.flipkart.foxtrot.common.stats.StatsRequest;
import com.flipkart.foxtrot.common.stats.StatsTrendRequest;
import com.flipkart.foxtrot.common.trend.TrendRequest;
import com.flipkart.foxtrot.sql.FqlQuery;
import com.flipkart.foxtrot.sql.FqlQueryType;
import com.flipkart.foxtrot.sql.MetaStatementMatcher;
import com.flipkart.foxtrot.sql.SqlElementVisitor;
import com.flipkart.foxtrot.sql.extendedsql.ExtendedSqlStatement;
import com.flipkart.foxtrot.sql.extendedsql.desc.Describe;
import com.flipkart.foxtrot.sql.extendedsql.showtables.ShowTables;
import com.flipkart.foxtrot.sql.query.FqlActionQuery;
import com.flipkart.foxtrot.sql.query.FqlDescribeTable;
import com.flipkart.foxtrot.sql.query.FqlShowTablesQuery;
import com.flipkart.foxtrot.sql.util.QueryUtils;
import com.google.common.collect.Lists;
import io.dropwizard.util.Duration;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTranslator
extends SqlElementVisitor {
    private static final Logger logger = LoggerFactory.getLogger((String)QueryTranslator.class.getSimpleName());
    private static final MetaStatementMatcher metastatementMatcher = new MetaStatementMatcher();
    private FqlQueryType queryType = FqlQueryType.select;
    private String tableName;
    private List<String> groupBycolumnsList = Lists.newArrayList();
    private ResultSort resultSort;
    private boolean hasLimit = false;
    private long limitFrom;
    private long limitCount;
    private ActionRequest calledAction;
    private List<Filter> filters;
    private List<String> selectedColumns = Lists.newArrayList();
    private List<ResultSort> columnsWithSort = Lists.newArrayList();

    @Override
    public void visit(PlainSelect plainSelect) {
        List selectItems = plainSelect.getSelectItems();
        for (Object selectItem : selectItems) {
            SelectItem selectExpressionItem = (SelectItem)selectItem;
            FunctionReader functionReader = new FunctionReader();
            selectExpressionItem.accept((SelectItemVisitor)functionReader);
            String columnName = functionReader.columnName;
            if (null != columnName && !columnName.isEmpty()) {
                this.selectedColumns.add(columnName);
                continue;
            }
            this.calledAction = functionReader.actionRequest;
            this.queryType = functionReader.queryType;
        }
        plainSelect.getFromItem().accept((FromItemVisitor)this);
        List groupByItems = plainSelect.getGroupByColumnReferences();
        if (null != groupByItems) {
            this.queryType = FqlQueryType.group;
            for (Object groupByItem : groupByItems) {
                if (!(groupByItem instanceof Column)) continue;
                Column column = (Column)groupByItem;
                this.groupBycolumnsList.add(column.getFullyQualifiedName());
            }
        }
        if (FqlQueryType.select == this.queryType) {
            List orderByElements = plainSelect.getOrderByElements();
            this.resultSort = this.generateResultSort(orderByElements);
            if (null != plainSelect.getLimit()) {
                this.hasLimit = true;
                this.limitFrom = plainSelect.getLimit().getOffset();
                this.limitCount = plainSelect.getLimit().getRowCount();
            }
        }
        if (null != plainSelect.getWhere()) {
            FilterParser filterParser = new FilterParser();
            plainSelect.getWhere().accept((ExpressionVisitor)filterParser);
            this.filters = filterParser.filters.isEmpty() ? null : filterParser.filters;
        }
        List<ResultSort> tempColumnsWithSort = this.generateColumnSort(plainSelect.getOrderByElements());
        if (null != plainSelect.getDistinct()) {
            for (String selectedColumn : this.selectedColumns) {
                boolean alreadyAdded = false;
                for (ResultSort columnWithSort : tempColumnsWithSort) {
                    if (!selectedColumn.equalsIgnoreCase(columnWithSort.getField())) continue;
                    this.columnsWithSort.add(columnWithSort);
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                ResultSort resultSort = new ResultSort();
                resultSort.setField(selectedColumn);
                resultSort.setOrder(ResultSort.Order.desc);
                this.columnsWithSort.add(resultSort);
            }
            this.queryType = FqlQueryType.distinct;
        }
    }

    @Override
    public void visit(Select select) {
        select.getSelectBody().accept((SelectVisitor)this);
    }

    @Override
    public void visit(Table tableName) {
        this.tableName = tableName.getName().replaceAll("[^a-zA-Z0-9\\-_]", "");
    }

    @Override
    public void visit(Function function) {
        List params = function.getParameters().getExpressions();
        ((Expression)params.toArray()[0]).accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(ExpressionList expressionList) {
        ExpressionList expressions = (ExpressionList)expressionList.getExpressions();
        for (Object expression : expressions.getExpressions()) {
            System.out.println(expression.getClass());
        }
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept((ExpressionVisitor)this);
    }

    public FqlQuery translate(String sql) throws Exception {
        ExtendedSqlStatement extendedSqlStatement = metastatementMatcher.parse(sql);
        if (null != extendedSqlStatement) {
            ExtendedSqlParser parser = new ExtendedSqlParser();
            extendedSqlStatement.receive(parser);
            return parser.getQuery();
        }
        CCJSqlParserManager ccjSqlParserManager = new CCJSqlParserManager();
        Statement statement = ccjSqlParserManager.parse((Reader)new StringReader(sql));
        Select select = (Select)statement;
        select.accept((StatementVisitor)this);
        TrendRequest request = null;
        switch (this.queryType) {
            case select: {
                Query query = new Query();
                query.setTable(this.tableName);
                query.setSort(this.resultSort);
                if (this.hasLimit) {
                    query.setFrom((int)this.limitFrom);
                    query.setLimit((int)this.limitCount);
                }
                query.setFilters(this.filters);
                request = query;
                break;
            }
            case group: {
                GroupRequest group = new GroupRequest();
                group.setTable(this.tableName);
                group.setNesting(this.groupBycolumnsList);
                group.setFilters(this.filters);
                this.setUniqueCountOn(group);
                request = group;
                break;
            }
            case trend: {
                TrendRequest trend = (TrendRequest)this.calledAction;
                trend.setTable(this.tableName);
                trend.setFilters(this.filters);
                request = trend;
                break;
            }
            case statstrend: {
                StatsTrendRequest statsTrend = (StatsTrendRequest)this.calledAction;
                statsTrend.setTable(this.tableName);
                statsTrend.setFilters(this.filters);
                request = statsTrend;
                break;
            }
            case stats: {
                StatsRequest stats = (StatsRequest)this.calledAction;
                stats.setTable(this.tableName);
                stats.setFilters(this.filters);
                request = stats;
                break;
            }
            case histogram: {
                HistogramRequest histogram = (HistogramRequest)this.calledAction;
                histogram.setTable(this.tableName);
                histogram.setFilters(this.filters);
                request = histogram;
                break;
            }
            case count: {
                CountRequest countRequest = (CountRequest)this.calledAction;
                countRequest.setTable(this.tableName);
                countRequest.setFilters(this.filters);
                request = countRequest;
                break;
            }
            case distinct: {
                DistinctRequest distinctRequest = new DistinctRequest();
                distinctRequest.setTable(this.tableName);
                distinctRequest.setFilters(this.filters);
                distinctRequest.setNesting(this.columnsWithSort);
                request = distinctRequest;
                break;
            }
        }
        if (null == request) {
            throw new Exception("Could not parse provided FQL.");
        }
        return new FqlActionQuery(this.queryType, (ActionRequest)request, this.selectedColumns);
    }

    private ResultSort generateResultSort(List orderByElements) {
        if (null == orderByElements) {
            return null;
        }
        Iterator iterator = orderByElements.iterator();
        if (iterator.hasNext()) {
            Object orderByElementObject = iterator.next();
            OrderByElement orderByElement = (OrderByElement)orderByElementObject;
            Column sortColumn = (Column)orderByElement.getExpression();
            ResultSort resultSort = new ResultSort();
            resultSort.setField(sortColumn.getFullyQualifiedName());
            resultSort.setOrder(orderByElement.isAsc() ? ResultSort.Order.asc : ResultSort.Order.desc);
            logger.info("ResultSort: " + resultSort);
            return resultSort;
        }
        return null;
    }

    private void setUniqueCountOn(GroupRequest group) {
        CountRequest calledAction;
        boolean distinct;
        if (this.calledAction instanceof CountRequest && (distinct = (calledAction = (CountRequest)this.calledAction).isDistinct())) {
            group.setUniqueCountOn(calledAction.getField());
        }
    }

    private List<ResultSort> generateColumnSort(List<OrderByElement> orderItems) {
        ArrayList resultSortList = Lists.newArrayList();
        if (orderItems == null || orderItems.isEmpty()) {
            return resultSortList;
        }
        for (OrderByElement orderByElement : orderItems) {
            Column sortColumn = (Column)orderByElement.getExpression();
            ResultSort resultSort = new ResultSort();
            resultSort.setField(sortColumn.getFullyQualifiedName());
            resultSort.setOrder(orderByElement.isAsc() ? ResultSort.Order.asc : ResultSort.Order.desc);
            resultSortList.add(resultSort);
        }
        return resultSortList;
    }

    private static final class ExtendedSqlParser
    extends SqlElementVisitor {
        private FqlQuery query;

        private ExtendedSqlParser() {
        }

        @Override
        public void visit(Describe describe) {
            this.query = new FqlDescribeTable(describe.getTable().getName());
        }

        @Override
        public void visit(ShowTables showTables) {
            this.query = new FqlShowTablesQuery();
        }

        public FqlQuery getQuery() {
            return this.query;
        }
    }

    private static final class FilterParser
    extends SqlElementVisitor {
        private List<Filter> filters = Lists.newArrayList();

        private FilterParser() {
        }

        @Override
        public void visit(EqualsTo equalsTo) {
            EqualsFilter equalsFilter = new EqualsFilter();
            String field = ((Column)equalsTo.getLeftExpression()).getFullyQualifiedName();
            equalsFilter.setField(field.replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            equalsFilter.setValue(this.getValueFromExpression(equalsTo.getRightExpression()));
            this.filters.add((Filter)equalsFilter);
        }

        @Override
        public void visit(NotEqualsTo notEqualsTo) {
            NotEqualsFilter notEqualsFilter = new NotEqualsFilter();
            String field = ((Column)notEqualsTo.getLeftExpression()).getFullyQualifiedName();
            notEqualsFilter.setField(field.replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            notEqualsFilter.setValue(this.getValueFromExpression(notEqualsTo.getRightExpression()));
            this.filters.add((Filter)notEqualsFilter);
        }

        @Override
        public void visit(AndExpression andExpression) {
            andExpression.getLeftExpression().accept((ExpressionVisitor)this);
            andExpression.getRightExpression().accept((ExpressionVisitor)this);
        }

        @Override
        public void visit(Between between) {
            BetweenFilter betweenFilter = new BetweenFilter();
            ColumnData columnData = this.setupColumn(between.getLeftExpression());
            betweenFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            betweenFilter.setTemporal(columnData.isTemporal());
            Number from = this.getNumbericValue(between.getBetweenExpressionStart());
            Number to = this.getNumbericValue(between.getBetweenExpressionEnd());
            betweenFilter.setFrom(from);
            betweenFilter.setTo(to);
            this.filters.add((Filter)betweenFilter);
        }

        @Override
        public void visit(GreaterThan greaterThan) {
            GreaterThanFilter greaterThanFilter = new GreaterThanFilter();
            ColumnData columnData = this.setupColumn(greaterThan.getLeftExpression());
            greaterThanFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            greaterThanFilter.setTemporal(columnData.isTemporal());
            greaterThanFilter.setValue(this.getNumbericValue(greaterThan.getRightExpression()));
            this.filters.add((Filter)greaterThanFilter);
        }

        @Override
        public void visit(GreaterThanEquals greaterThanEquals) {
            GreaterEqualFilter greaterEqualFilter = new GreaterEqualFilter();
            ColumnData columnData = this.setupColumn(greaterThanEquals.getLeftExpression());
            greaterEqualFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            greaterEqualFilter.setTemporal(columnData.isTemporal());
            greaterEqualFilter.setValue(this.getNumbericValue(greaterThanEquals.getRightExpression()));
            this.filters.add((Filter)greaterEqualFilter);
        }

        @Override
        public void visit(InExpression inExpression) {
            InFilter inFilter = new InFilter();
            inFilter.setField(((Column)inExpression.getLeftExpression()).getFullyQualifiedName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            ItemsList itemsList = inExpression.getRightItemsList();
            if (!(itemsList instanceof ExpressionList)) {
                throw new RuntimeException("Sub selects not supported");
            }
            ExpressionList expressionList = (ExpressionList)itemsList;
            ArrayList filterValues = Lists.newArrayList();
            for (Object expressionObject : expressionList.getExpressions()) {
                Expression expression = (Expression)expressionObject;
                filterValues.add(this.getValueFromExpression(expression));
            }
            inFilter.setValues((List)filterValues);
            this.filters.add((Filter)inFilter);
        }

        @Override
        public void visit(IsNullExpression isNullExpression) {
            super.visit(isNullExpression);
            ColumnData columnData = this.setupColumn(isNullExpression.getLeftExpression());
            if (isNullExpression.isNot()) {
                ExistsFilter existsFilter = new ExistsFilter();
                existsFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
                this.filters.add((Filter)existsFilter);
            } else {
                MissingFilter missingFilter = new MissingFilter();
                missingFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
                this.filters.add((Filter)missingFilter);
            }
        }

        @Override
        public void visit(LikeExpression likeExpression) {
            super.visit(likeExpression);
            ContainsFilter containsFilter = new ContainsFilter();
            containsFilter.setValue(this.getStringValue(likeExpression.getRightExpression()));
            containsFilter.setField(((Column)likeExpression.getLeftExpression()).getFullyQualifiedName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            this.filters.add((Filter)containsFilter);
        }

        @Override
        public void visit(MinorThan minorThan) {
            LessThanFilter lessThanFilter = new LessThanFilter();
            ColumnData columnData = this.setupColumn(minorThan.getLeftExpression());
            lessThanFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            lessThanFilter.setTemporal(columnData.isTemporal());
            lessThanFilter.setValue(this.getNumbericValue(minorThan.getRightExpression()));
            this.filters.add((Filter)lessThanFilter);
        }

        @Override
        public void visit(MinorThanEquals minorThanEquals) {
            LessEqualFilter lessEqualFilter = new LessEqualFilter();
            ColumnData columnData = this.setupColumn(minorThanEquals.getLeftExpression());
            lessEqualFilter.setField(columnData.getColumnName().replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            lessEqualFilter.setTemporal(columnData.isTemporal());
            lessEqualFilter.setValue(this.getNumbericValue(minorThanEquals.getRightExpression()));
            this.filters.add((Filter)lessEqualFilter);
        }

        @Override
        public void visit(Function function) {
            if (function.getName().equalsIgnoreCase("last")) {
                LastFilter lastFilter = this.parseWindowFunction(function.getParameters().getExpressions());
                this.filters.add((Filter)lastFilter);
                return;
            }
            throw new RuntimeException("Only last() function is supported");
        }

        private LastFilter parseWindowFunction(List expressions) {
            if (expressions == null || expressions.isEmpty() || expressions.size() > 3) {
                throw new RuntimeException("last function has following format: last(duration, [start-time, [timestamp field]])");
            }
            LastFilter lastFilter = new LastFilter();
            lastFilter.setDuration(Duration.parse((String)QueryUtils.expressionToString((Expression)expressions.get(0))));
            if (expressions.size() > 1) {
                lastFilter.setCurrentTime(QueryUtils.expressionToNumber((Expression)expressions.get(1)).longValue());
            }
            if (expressions.size() > 2) {
                lastFilter.setField(QueryUtils.expressionToString((Expression)expressions.get(2)).replaceAll("[^a-zA-Z0-9.\\-_]", ""));
            }
            return lastFilter;
        }

        private Object getValueFromExpression(Expression expression) {
            if (expression instanceof StringValue) {
                return ((StringValue)expression).getValue();
            }
            return this.getNumbericValue(expression);
        }

        private String getStringValue(Expression expression) {
            if (expression instanceof StringValue) {
                return ((StringValue)expression).getValue();
            }
            throw new RuntimeException("Unsupported value type.");
        }

        private Number getNumbericValue(Expression expression) {
            if (expression instanceof DoubleValue) {
                return ((DoubleValue)expression).getValue();
            }
            if (expression instanceof LongValue) {
                return ((LongValue)expression).getValue();
            }
            if (expression instanceof DateValue) {
                return ((DateValue)expression).getValue().getTime();
            }
            if (expression instanceof TimeValue) {
                return ((TimeValue)expression).getValue().getTime();
            }
            throw new RuntimeException("Unsupported value type.");
        }

        private ColumnData setupColumn(Expression expression) {
            if (expression instanceof Function) {
                Function function = (Function)expression;
                if (function.getName().equalsIgnoreCase("temporal")) {
                    List parameters = function.getParameters().getExpressions();
                    if (parameters.size() != 1 || !(parameters.get(0) instanceof Column)) {
                        throw new RuntimeException("temporal function must have a fieldname as parameter");
                    }
                    return ColumnData.temporal(((Column)parameters.get(0)).getFullyQualifiedName());
                }
                throw new RuntimeException("Only the function 'temporal' is supported in where clause");
            }
            if (expression instanceof Column) {
                return new ColumnData(((Column)expression).getFullyQualifiedName());
            }
            throw new RuntimeException("Only the function 'temporal([fieldname)' and fieldname is supported in where clause");
        }

        private static final class ColumnData {
            private final String columnName;
            private boolean temporal = false;
            private boolean window = false;

            private ColumnData(String columnName) {
                this.columnName = columnName;
            }

            static ColumnData temporal(String columnName) {
                ColumnData columnData = new ColumnData(columnName);
                columnData.temporal = true;
                return columnData;
            }

            static ColumnData window(String columnName) {
                ColumnData columnData = new ColumnData(columnName);
                columnData.window = true;
                return columnData;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public boolean isTemporal() {
                return this.temporal;
            }

            public boolean isWindow() {
                return this.window;
            }
        }
    }

    private static final class FunctionReader
    extends SqlElementVisitor {
        private boolean allColumn = false;
        private ActionRequest actionRequest;
        public FqlQueryType queryType = FqlQueryType.select;
        private String columnName = null;

        private FunctionReader() {
        }

        @Override
        public void visit(SelectExpressionItem selectExpressionItem) {
            Expression expression = selectExpressionItem.getExpression();
            if (expression instanceof Function) {
                Function function = (Function)expression;
                this.queryType = this.getType(function.getName());
                switch (this.queryType) {
                    case trend: {
                        this.actionRequest = this.parseTrendFunction(function.getParameters().getExpressions());
                        break;
                    }
                    case statstrend: {
                        this.actionRequest = this.parseStatsTrendFunction(function.getParameters().getExpressions());
                        break;
                    }
                    case stats: {
                        this.actionRequest = this.parseStatsFunction(function.getParameters().getExpressions());
                        break;
                    }
                    case histogram: {
                        this.actionRequest = this.parseHistogramRequest(function.getParameters());
                        break;
                    }
                    case count: {
                        this.actionRequest = this.parseCountRequest(function.getParameters(), function.isAllColumns(), function.isDistinct());
                        break;
                    }
                }
            } else if (expression instanceof Parenthesis) {
                this.columnName = ((Column)((Parenthesis)expression).getExpression()).getFullyQualifiedName();
            } else if (expression instanceof Column) {
                this.columnName = ((Column)expression).getFullyQualifiedName();
            }
        }

        private FqlQueryType getType(String function) {
            if (function.equalsIgnoreCase("trend")) {
                return FqlQueryType.trend;
            }
            if (function.equalsIgnoreCase("statstrend")) {
                return FqlQueryType.statstrend;
            }
            if (function.equalsIgnoreCase("stats")) {
                return FqlQueryType.stats;
            }
            if (function.equalsIgnoreCase("histogram")) {
                return FqlQueryType.histogram;
            }
            if (function.equalsIgnoreCase("count")) {
                return FqlQueryType.count;
            }
            return FqlQueryType.select;
        }

        private TrendRequest parseTrendFunction(List expressions) {
            if (expressions == null || expressions.isEmpty() || expressions.size() > 3) {
                throw new RuntimeException("trend function has following format: trend(fieldname, [period, [timestamp field]])");
            }
            TrendRequest trendRequest = new TrendRequest();
            trendRequest.setField(QueryUtils.expressionToString((Expression)expressions.get(0)));
            if (expressions.size() > 1) {
                trendRequest.setPeriod(Period.valueOf((String)QueryUtils.expressionToString((Expression)expressions.get(1)).toLowerCase()));
            }
            if (expressions.size() > 2) {
                trendRequest.setTimestamp(QueryUtils.expressionToString((Expression)expressions.get(2)));
            }
            return trendRequest;
        }

        private StatsTrendRequest parseStatsTrendFunction(List expressions) {
            if (expressions == null || expressions.isEmpty() || expressions.size() > 2) {
                throw new RuntimeException("statstrend function has following format: statstrend(fieldname, [period])");
            }
            StatsTrendRequest statsTrendRequest = new StatsTrendRequest();
            statsTrendRequest.setField(QueryUtils.expressionToString((Expression)expressions.get(0)));
            if (expressions.size() > 1) {
                statsTrendRequest.setPeriod(Period.valueOf((String)QueryUtils.expressionToString((Expression)expressions.get(1)).toLowerCase()));
            }
            return statsTrendRequest;
        }

        private StatsRequest parseStatsFunction(List expressions) {
            if (expressions == null || expressions.isEmpty() || expressions.size() > 1) {
                throw new RuntimeException("stats function has following format: stats(fieldname)");
            }
            StatsRequest statsRequest = new StatsRequest();
            statsRequest.setField(QueryUtils.expressionToString((Expression)expressions.get(0)));
            return statsRequest;
        }

        private HistogramRequest parseHistogramRequest(ExpressionList expressionList) {
            if (expressionList != null && expressionList.getExpressions() != null && expressionList.getExpressions().size() > 2) {
                throw new RuntimeException("histogram function has the following format: histogram([period, [timestamp field]])");
            }
            HistogramRequest histogramRequest = new HistogramRequest();
            if (null != expressionList) {
                List expressions = expressionList.getExpressions();
                histogramRequest.setPeriod(Period.valueOf((String)QueryUtils.expressionToString((Expression)expressions.get(0)).toLowerCase()));
                if (expressions.size() > 1) {
                    histogramRequest.setField(QueryUtils.expressionToString((Expression)expressions.get(1)));
                }
            }
            return histogramRequest;
        }

        private ActionRequest parseCountRequest(ExpressionList expressionList, boolean allColumns, boolean isDistinct) {
            CountRequest countRequest = new CountRequest();
            if (allColumns) {
                countRequest.setField(null);
                return countRequest;
            }
            if (expressionList != null && expressionList.getExpressions() != null && expressionList.getExpressions().size() == 1) {
                List expressions = expressionList.getExpressions();
                countRequest.setField(this.expressionToString((Expression)expressions.get(0)));
                countRequest.setDistinct(isDistinct);
                return countRequest;
            }
            throw new RuntimeException("count function has the following format: count([distinct] */column_name)");
        }

        private String expressionToString(Expression expression) {
            if (expression instanceof Column) {
                return ((Column)expression).getFullyQualifiedName();
            }
            if (expression instanceof StringValue) {
                return ((StringValue)expression).getValue();
            }
            return null;
        }

        @Override
        public void visit(AllColumns allColumns) {
            this.allColumn = true;
        }

        public boolean isAllColumn() {
            return this.allColumn;
        }
    }
}

