/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.exception.TableMapStoreException;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.util.ElasticsearchQueryUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.MapStoreFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMapStore
implements MapStore<String, Table> {
    public static final String TABLE_META_INDEX = "table-meta";
    public static final String TABLE_META_TYPE = "table-meta";
    private static final Logger logger = LoggerFactory.getLogger((String)TableMapStore.class.getSimpleName());
    private final ElasticsearchConnection elasticsearchConnection;
    private final ObjectMapper objectMapper;

    public TableMapStore(ElasticsearchConnection elasticsearchConnection) {
        this.elasticsearchConnection = elasticsearchConnection;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static Factory factory(ElasticsearchConnection elasticsearchConnection) {
        return new Factory(elasticsearchConnection);
    }

    public void store(String key, Table value) {
        if (key == null || value == null || value.getName() == null) {
            throw new TableMapStoreException(String.format("Illegal Store Request - %s - %s", key, value));
        }
        logger.info("Storing key: {}", (Object)key);
        try {
            Map<String, Object> sourceMap = ElasticsearchQueryUtils.toMap(this.objectMapper, value);
            ((IndexRequestBuilder)((IndexRequestBuilder)this.elasticsearchConnection.getClient().prepareIndex().setIndex("table-meta")).setType("table-meta").setSource(sourceMap).setId(key).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet();
        }
        catch (Exception e) {
            throw new TableMapStoreException("Error saving meta: ", (Throwable)e);
        }
    }

    public void storeAll(Map<String, Table> map) {
        if (map == null) {
            throw new TableMapStoreException("Illegal Store Request - Null Map");
        }
        if (map.containsKey(null)) {
            throw new TableMapStoreException("Illegal Store Request - Null Key is Present");
        }
        logger.info("Store all called for multiple values");
        BulkRequestBuilder bulkRequestBuilder = (BulkRequestBuilder)this.elasticsearchConnection.getClient().prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (Map.Entry<String, Table> mapEntry : map.entrySet()) {
            try {
                if (mapEntry.getValue() == null) {
                    throw new TableMapStoreException(String.format("Illegal Store Request - Object is Null for Table - %s", mapEntry.getKey()));
                }
                Map<String, Object> sourceMap = ElasticsearchQueryUtils.toMap(this.objectMapper, mapEntry.getValue());
                bulkRequestBuilder.add(this.elasticsearchConnection.getClient().prepareIndex("table-meta", "table-meta", mapEntry.getKey()).setSource(sourceMap));
            }
            catch (Exception e) {
                throw new TableMapStoreException("Error bulk saving meta: ", (Throwable)e);
            }
        }
        bulkRequestBuilder.execute().actionGet();
    }

    public void delete(String key) {
        logger.info("Delete called for value: {}", (Object)key);
        ((DeleteRequestBuilder)((DeleteRequestBuilder)this.elasticsearchConnection.getClient().prepareDelete().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setIndex("table-meta")).setType("table-meta").setId(key).execute().actionGet();
        logger.info("Deleted value: {}", (Object)key);
    }

    public void deleteAll(Collection<String> keys) {
        logger.info("Delete all called for multiple values: {}", keys);
        BulkRequestBuilder bulRequestBuilder = (BulkRequestBuilder)this.elasticsearchConnection.getClient().prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (String key : keys) {
            bulRequestBuilder.add(this.elasticsearchConnection.getClient().prepareDelete("table-meta", "table-meta", key));
        }
        bulRequestBuilder.execute().actionGet();
        logger.info("Deleted multiple values: {}", keys);
    }

    public Table load(String key) {
        logger.info("Load called for: {}", (Object)key);
        GetResponse response = (GetResponse)((GetRequestBuilder)this.elasticsearchConnection.getClient().prepareGet().setIndex("table-meta")).setType("table-meta").setId(key).execute().actionGet();
        if (!response.isExists()) {
            return null;
        }
        try {
            return (Table)this.objectMapper.readValue(response.getSourceAsBytes(), Table.class);
        }
        catch (Exception e) {
            throw new TableMapStoreException("Error getting data for table: " + key);
        }
    }

    public Map<String, Table> loadAll(Collection<String> keys) {
        logger.info("Load all called for multiple keys");
        MultiGetResponse response = (MultiGetResponse)this.elasticsearchConnection.getClient().prepareMultiGet().add("table-meta", "table-meta", keys).execute().actionGet();
        HashMap tables = Maps.newHashMap();
        for (MultiGetItemResponse multiGetItemResponse : response) {
            try {
                Table table = (Table)this.objectMapper.readValue(multiGetItemResponse.getResponse().getSourceAsString(), Table.class);
                tables.put(table.getName(), table);
            }
            catch (Exception e) {
                throw new TableMapStoreException("Error getting data for table: " + multiGetItemResponse.getId());
            }
        }
        logger.info("Loaded value count: {}", (Object)tables.size());
        return tables;
    }

    public Set<String> loadAllKeys() {
        logger.info("Load all keys called");
        SearchResponse response = (SearchResponse)this.elasticsearchConnection.getClient().prepareSearch(new String[]{"table-meta"}).setTypes(new String[]{"table-meta"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(10000).setScroll(new TimeValue(30L, TimeUnit.SECONDS)).setFetchSource(false).execute().actionGet();
        HashSet ids = Sets.newHashSet();
        do {
            for (SearchHit hit : response.getHits().getHits()) {
                ids.add(hit.getId());
            }
        } while (0 != response.getHits().getHits().length && (response = (SearchResponse)this.elasticsearchConnection.getClient().prepareSearchScroll(response.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet()).getHits().getHits().length != 0);
        logger.info("Loaded value count: {}", (Object)ids.size());
        return ids;
    }

    public static class Factory
    implements MapStoreFactory<String, Table> {
        private final ElasticsearchConnection elasticsearchConnection;

        public Factory(ElasticsearchConnection elasticsearchConnection) {
            this.elasticsearchConnection = elasticsearchConnection;
        }

        public TableMapStore newMapStore(String mapName, Properties properties) {
            return new TableMapStore(this.elasticsearchConnection);
        }
    }
}

