/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.codahale.metrics.annotation.Timed;
import com.collections.CollectionUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.FieldMetadata;
import com.flipkart.foxtrot.common.FieldType;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.common.estimation.CardinalityEstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationDataVisitor;
import com.flipkart.foxtrot.common.estimation.FixedEstimationData;
import com.flipkart.foxtrot.common.estimation.PercentileEstimationData;
import com.flipkart.foxtrot.common.estimation.TermHistogramEstimationData;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.parsers.ElasticsearchMappingParser;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.flipkart.foxtrot.core.table.impl.TableMapStore;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.IMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=15)
public class DistributedTableMetadataManager
implements TableMetadataManager {
    public static final String CARDINALITY_CACHE_INDEX = "table_cardinality_cache";
    private static final Logger logger = LoggerFactory.getLogger(DistributedTableMetadataManager.class);
    private static final String DATA_MAP = "tablemetadatamap";
    private static final String FIELD_MAP = "tablefieldmap";
    private static final String CARDINALITY_FIELD_MAP = "cardinalitytablefieldmap";
    private static final String CARDINALITY = "cardinality";
    private static final int PRECISION_THRESHOLD = 100;
    private static final int TIME_TO_LIVE_CACHE = (int)TimeUnit.MINUTES.toSeconds(15L);
    private static final int TIME_TO_LIVE_TABLE_CACHE = (int)TimeUnit.DAYS.toSeconds(30L);
    private static final int TIME_TO_LIVE_CARDINALITY_CACHE = (int)TimeUnit.DAYS.toSeconds(7L);
    private static final int TIME_TO_NEAR_CACHE = (int)TimeUnit.MINUTES.toSeconds(15L);
    private final HazelcastConnection hazelcastConnection;
    private final ElasticsearchConnection elasticsearchConnection;
    private final ObjectMapper mapper;
    private final CardinalityConfig cardinalityConfig;
    private IMap<String, Table> tableDataStore;
    private IMap<String, TableFieldMapping> fieldDataCache;
    private IMap<String, TableFieldMapping> fieldDataCardinalityCache;

    @Inject
    public DistributedTableMetadataManager(HazelcastConnection hazelcastConnection, ElasticsearchConnection elasticsearchConnection, ObjectMapper mapper, CardinalityConfig cardinalityConfig) {
        this.hazelcastConnection = hazelcastConnection;
        this.elasticsearchConnection = elasticsearchConnection;
        this.mapper = mapper;
        this.cardinalityConfig = cardinalityConfig;
        hazelcastConnection.getHazelcastConfig().getMapConfigs().put(DATA_MAP, this.tableMapConfig());
        hazelcastConnection.getHazelcastConfig().getMapConfigs().put(FIELD_MAP, this.fieldMetaMapConfig());
        hazelcastConnection.getHazelcastConfig().getMapConfigs().put(CARDINALITY_FIELD_MAP, this.cardinalityFieldMetaMapConfig());
    }

    private static <K, V> Collector<Map.Entry<K, V>, ?, List<Map<K, V>>> mapSize(int limit) {
        return Collector.of(ArrayList::new, (l, e) -> {
            DistributedTableMetadataManager.addEmptyMap(limit, l);
            ((Map)l.get(l.size() - 1)).put(e.getKey(), e.getValue());
        }, (l1, l2) -> {
            if (l1.isEmpty()) {
                return l2;
            }
            if (l2.isEmpty()) {
                return l1;
            }
            if (((Map)l1.get(l1.size() - 1)).size() < limit) {
                Map map = (Map)l1.get(l1.size() - 1);
                ListIterator mapsIte = l2.listIterator(l2.size());
                DistributedTableMetadataManager.processMap(limit, map, mapsIte);
            }
            l1.addAll(l2);
            return l1;
        }, new Collector.Characteristics[0]);
    }

    private static <K, V> void processMap(int limit, Map<K, V> map, ListIterator<Map<K, V>> mapsIte) {
        while (mapsIte.hasPrevious() && map.size() < limit) {
            Iterator<Map.Entry<K, V>> ite = mapsIte.previous().entrySet().iterator();
            DistributedTableMetadataManager.processNestedMap(limit, map, ite);
            if (ite.hasNext()) continue;
            mapsIte.remove();
        }
    }

    private static <K, V> void processNestedMap(int limit, Map<K, V> map, Iterator<Map.Entry<K, V>> ite) {
        while (ite.hasNext() && map.size() < limit) {
            Map.Entry<K, V> entry = ite.next();
            map.put(entry.getKey(), entry.getValue());
            ite.remove();
        }
    }

    private static <K, V> void addEmptyMap(int limit, List<Map<K, V>> l) {
        if (l.isEmpty() || l.get(l.size() - 1).size() == limit) {
            l.add(new HashMap());
        }
    }

    @Override
    public boolean cardinalityCacheContains(String table) {
        return this.fieldDataCardinalityCache.containsKey((Object)table);
    }

    private MapConfig tableMapConfig() {
        MapConfig mapConfig = new MapConfig();
        mapConfig.setReadBackupData(true);
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setTimeToLiveSeconds(TIME_TO_LIVE_TABLE_CACHE);
        mapConfig.setBackupCount(0);
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setFactoryImplementation((Object)TableMapStore.factory(this.elasticsearchConnection));
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setInitialLoadMode(MapStoreConfig.InitialLoadMode.EAGER);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setTimeToLiveSeconds(TIME_TO_LIVE_TABLE_CACHE);
        nearCacheConfig.setInvalidateOnChange(true);
        mapConfig.setNearCacheConfig(nearCacheConfig);
        return mapConfig;
    }

    private MapConfig fieldMetaMapConfig() {
        MapConfig mapConfig = new MapConfig();
        mapConfig.setReadBackupData(true);
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setTimeToLiveSeconds(TIME_TO_LIVE_CACHE);
        mapConfig.setBackupCount(0);
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setTimeToLiveSeconds(TIME_TO_NEAR_CACHE);
        nearCacheConfig.setInvalidateOnChange(true);
        mapConfig.setNearCacheConfig(nearCacheConfig);
        return mapConfig;
    }

    private MapConfig cardinalityFieldMetaMapConfig() {
        MapConfig mapConfig = new MapConfig();
        mapConfig.setReadBackupData(true);
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setTimeToLiveSeconds(TIME_TO_LIVE_CARDINALITY_CACHE);
        mapConfig.setBackupCount(0);
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setTimeToLiveSeconds(TIME_TO_LIVE_CARDINALITY_CACHE);
        nearCacheConfig.setInvalidateOnChange(true);
        mapConfig.setNearCacheConfig(nearCacheConfig);
        return mapConfig;
    }

    @Override
    public void save(Table table) {
        logger.info("Saving Table : {}", (Object)table);
        this.tableDataStore.put((Object)table.getName(), (Object)table);
        this.tableDataStore.flush();
    }

    @Override
    public Table get(String tableName) {
        logger.debug("Getting Table : {}", (Object)tableName);
        if (this.tableDataStore.containsKey((Object)tableName)) {
            return (Table)this.tableDataStore.get((Object)tableName);
        }
        return null;
    }

    @Override
    public List<Table> get() {
        if (0 == this.tableDataStore.size()) {
            return Collections.emptyList();
        }
        ArrayList tables = Lists.newArrayList((Iterable)this.tableDataStore.values());
        tables.sort(Comparator.comparing(table -> table.getName().toLowerCase()));
        return tables;
    }

    @Override
    @Timed
    public TableFieldMapping getFieldMappings(String tableName, boolean withCardinality, boolean calculateCardinality, long timestamp) {
        TableFieldMapping tableFieldMapping;
        String table = ElasticsearchUtils.getValidTableName(tableName);
        if (!this.tableDataStore.containsKey((Object)table)) {
            throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
        }
        if (this.fieldDataCardinalityCache.size() == 0) {
            this.initializeCardinalityCache();
        }
        if (this.fieldDataCache.containsKey((Object)table) && !withCardinality) {
            tableFieldMapping = (TableFieldMapping)this.fieldDataCache.get((Object)table);
        } else if (this.fieldDataCardinalityCache.containsKey((Object)table) && withCardinality && !calculateCardinality) {
            tableFieldMapping = (TableFieldMapping)this.fieldDataCardinalityCache.get((Object)table);
        } else {
            tableFieldMapping = this.getTableFieldMapping(table);
            if (calculateCardinality) {
                this.estimateCardinality(table, tableFieldMapping.getMappings(), timestamp);
                this.fieldDataCardinalityCache.put((Object)table, (Object)tableFieldMapping);
                this.saveCardinalityCache(table, tableFieldMapping);
            } else {
                this.fieldDataCache.put((Object)table, (Object)tableFieldMapping);
            }
        }
        return TableFieldMapping.builder().table(table).mappings(tableFieldMapping.getMappings().stream().map(x -> FieldMetadata.builder().field(x.getField()).type(x.getType()).estimationData(withCardinality ? x.getEstimationData() : null).build()).collect(Collectors.toSet())).build();
    }

    private TableFieldMapping getTableFieldMapping(String table) {
        ElasticsearchMappingParser mappingParser = new ElasticsearchMappingParser(this.mapper);
        String indices = ElasticsearchUtils.getIndices(table);
        logger.info("Selected indices: {}", (Object)indices);
        GetMappingsResponse mappingsResponse = (GetMappingsResponse)this.elasticsearchConnection.getClient().admin().indices().prepareGetMappings(new String[]{indices}).execute().actionGet();
        HashSet indicesName = Sets.newHashSet();
        for (ObjectCursor index2 : mappingsResponse.getMappings().keys()) {
            indicesName.add(index2.value);
        }
        List fieldMetadata = indicesName.stream().filter(x -> !com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty((String)x)).sorted((lhs, rhs) -> {
            Date lhsDate = ElasticsearchUtils.parseIndexDate(lhs, table).toDate();
            Date rhsDate = ElasticsearchUtils.parseIndexDate(rhs, table).toDate();
            return 0 - lhsDate.compareTo(rhsDate);
        }).map(index -> (MappingMetaData)((ImmutableOpenMap)mappingsResponse.mappings().get(index)).get((Object)"document")).flatMap(mappingData -> {
            try {
                return mappingParser.getFieldMappings((MappingMetaData)mappingData).stream();
            }
            catch (Exception e) {
                logger.error("Could not read mapping from " + mappingData, (Throwable)e);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        TreeSet<FieldMetadata> fieldMetadataTreeSet = new TreeSet<FieldMetadata>(new FieldMetadataComparator());
        fieldMetadataTreeSet.addAll(fieldMetadata);
        return new TableFieldMapping(table, fieldMetadataTreeSet);
    }

    @Override
    public void updateEstimationData(String table, long timestamp) {
        if (!this.tableDataStore.containsKey((Object)table)) {
            throw FoxtrotExceptions.createBadRequestException(table, String.format("unknown_table table:%s", table));
        }
        TableFieldMapping tableFieldMapping = this.getFieldMappings(table, this.cardinalityConfig.isEnabled(), false, timestamp);
        this.fieldDataCache.put((Object)table, (Object)tableFieldMapping);
    }

    private void estimateCardinality(String table, Collection<FieldMetadata> fields, long time) {
        if (com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty(fields)) {
            logger.warn("No fields.. Nothing to query");
            return;
        }
        Map<String, FieldMetadata> fieldMap = fields.stream().collect(Collectors.toMap(FieldMetadata::getField, fieldMetadata -> fieldMetadata, (lhs, rhs) -> lhs));
        String index = ElasticsearchUtils.getCurrentIndex(ElasticsearchUtils.getValidTableName(table), time);
        Client client = this.elasticsearchConnection.getClient();
        Map<String, EstimationData> estimationData = this.estimateFirstPhaseData(table, index, client, fieldMap);
        estimationData = this.estimateSecondPhaseData(table, index, client, estimationData);
        estimationData.forEach((key, value) -> ((FieldMetadata)fieldMap.get(key)).setEstimationData(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, EstimationData> estimateFirstPhaseData(String table, String index, Client client, Map<String, FieldMetadata> fields) {
        HashMap estimationDataMap = Maps.newHashMap();
        int subListSize = this.cardinalityConfig == null || this.cardinalityConfig.getSubListSize() == 0 ? 50 : this.cardinalityConfig.getSubListSize();
        List listOfMaps = fields.entrySet().stream().collect(DistributedTableMetadataManager.mapSize(subListSize));
        for (Map innerMap : listOfMaps) {
            MultiSearchResponse multiResponse;
            MultiSearchRequestBuilder multiQuery = client.prepareMultiSearch();
            innerMap.values().forEach(fieldMetadata -> {
                String field = fieldMetadata.getField();
                SearchRequestBuilder query = client.prepareSearch(new String[]{index}).setIndicesOptions(Utils.indicesOptions()).setQuery((QueryBuilder)QueryBuilders.existsQuery((String)field)).setSize(0);
                switch (fieldMetadata.getType()) {
                    case STRING: {
                        this.evaluateStringAggregation(table, field, fieldMetadata.getType(), query);
                        break;
                    }
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        this.evaluateDoubleAggregation(table, field, fieldMetadata.getType(), query);
                        break;
                    }
                }
                multiQuery.add(query);
            });
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                multiResponse = (MultiSearchResponse)multiQuery.execute().actionGet();
            }
            catch (Throwable throwable) {
                logger.info("Cardinality query on table {} for {} fields took {} ms", new Object[]{table, fields.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                throw throwable;
            }
            logger.info("Cardinality query on table {} for {} fields took {} ms", new Object[]{table, fields.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            this.handleFirstPhaseMultiSearchResponse(multiResponse, table, fields, estimationDataMap);
        }
        return estimationDataMap;
    }

    private void handleFirstPhaseMultiSearchResponse(MultiSearchResponse multiResponse, String table, Map<String, FieldMetadata> fields, Map<String, EstimationData> estimationDataMap) {
        for (MultiSearchResponse.Item item : multiResponse.getResponses()) {
            SearchResponse response = this.validateAndGetSearchResponse(item, table);
            if (null == response) continue;
            long hits = response.getHits().getTotalHits();
            Map output = response.getAggregations().asMap();
            output.forEach((key, value) -> {
                FieldMetadata fieldMetadata = (FieldMetadata)fields.get(key);
                if (fieldMetadata == null) {
                    fieldMetadata = (FieldMetadata)fields.get(key.replace("_", ""));
                }
                if (fieldMetadata == null) {
                    return;
                }
                switch (fieldMetadata.getType()) {
                    case STRING: {
                        this.evaluateStringEstimation((Aggregation)value, table, (String)key, fieldMetadata.getType(), estimationDataMap, hits);
                        break;
                    }
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        this.evaluateDoubleEstimation((Aggregation)value, table, (String)key, fieldMetadata.getType(), estimationDataMap, hits);
                        break;
                    }
                    case BOOLEAN: {
                        this.evaluateBooleanEstimation((String)key, estimationDataMap);
                        break;
                    }
                }
            });
        }
    }

    private void evaluateStringAggregation(String table, String field, FieldType type, SearchRequestBuilder query) {
        logger.info("table:{} field:{} type:{} aggregationType:{}", new Object[]{table, field, type, CARDINALITY});
        query.addAggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)field).field(field)).precisionThreshold(100L));
    }

    private void evaluateDoubleAggregation(String table, String field, FieldType type, SearchRequestBuilder query) {
        logger.info("table:{} field:{} type:{} aggregationType:{}", new Object[]{table, field, type, "percentile"});
        query.addAggregation((AggregationBuilder)((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)field).field(field)).percentiles(new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0}));
        query.addAggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)("_" + field)).field(field)).precisionThreshold(100L));
    }

    private void evaluateStringEstimation(Aggregation value, String table, String key, FieldType type, Map<String, EstimationData> estimationDataMap, long hits) {
        Cardinality cardinality = (Cardinality)value;
        logger.info("table:{} field:{} type:{} aggregationType:{} value:{} ", new Object[]{table, key, type, CARDINALITY, cardinality.getValue()});
        estimationDataMap.put(key, (EstimationData)CardinalityEstimationData.builder().cardinality(cardinality.getValue()).count(hits).build());
    }

    private void evaluateDoubleEstimation(Aggregation value, String table, String key, FieldType type, Map<String, EstimationData> estimationDataMap, long hits) {
        if (value instanceof Percentiles) {
            Percentiles percentiles = (Percentiles)value;
            double[] values = new double[10];
            for (int i = 10; i <= 100; i += 10) {
                Double percentile = percentiles.percentile((double)i);
                values[i / 10 - 1] = percentile.isNaN() ? 0.0 : percentile;
            }
            logger.info("table:{} field:{} type:{} aggregationType:{} value:{}", new Object[]{table, key, type, "percentile", values});
            estimationDataMap.put(key, (EstimationData)PercentileEstimationData.builder().values(values).count(hits).build());
        } else if (value instanceof Cardinality) {
            Cardinality cardinality = (Cardinality)value;
            logger.info("table:{} field:{} type:{} aggregationType:{} value:{}", new Object[]{table, key, type, CARDINALITY, cardinality.getValue()});
            EstimationData estimationData = estimationDataMap.get(key.replace("_", ""));
            if (estimationData instanceof PercentileEstimationData) {
                ((PercentileEstimationData)estimationData).setCardinality(cardinality.getValue());
            } else {
                estimationDataMap.put(key.replace("_", ""), (EstimationData)PercentileEstimationData.builder().cardinality(cardinality.getValue()).build());
            }
        }
    }

    private void evaluateBooleanEstimation(String key, Map<String, EstimationData> estimationDataMap) {
        estimationDataMap.put(key, (EstimationData)FixedEstimationData.builder().count(2L).build());
    }

    private Map<String, EstimationData> estimateSecondPhaseData(String table, final String index, final Client client, Map<String, EstimationData> estimationData) {
        final long maxDocuments = estimationData.values().stream().map(EstimationData::getCount).max(Comparator.naturalOrder()).orElse(0L);
        if (maxDocuments == 0L) {
            return estimationData;
        }
        final MultiSearchRequestBuilder multiQuery = client.prepareMultiSearch();
        estimationData.forEach((key, value) -> {
            Void cfr_ignored_0 = (Void)value.accept((EstimationDataVisitor)new EstimationDataVisitor<Void>(){

                public Void visit(FixedEstimationData fixedEstimationData) {
                    return null;
                }

                public Void visit(PercentileEstimationData percentileEstimationData) {
                    return null;
                }

                public Void visit(CardinalityEstimationData cardinalityEstimationData) {
                    if (cardinalityEstimationData.getCount() > 0L && cardinalityEstimationData.getCardinality() > 0L) {
                        int countToCardinalityRatio = (int)(cardinalityEstimationData.getCount() / cardinalityEstimationData.getCardinality());
                        int documentToCountRatio = (int)(maxDocuments / cardinalityEstimationData.getCount());
                        if (cardinalityEstimationData.getCardinality() <= 100L || countToCardinalityRatio > 100 && documentToCountRatio < 100 && cardinalityEstimationData.getCardinality() <= 5000L) {
                            logger.info("field:{} maxCount:{} countToCardinalityRatio:{} documentToCountRatio:{}", new Object[]{key, maxDocuments, countToCardinalityRatio, documentToCountRatio});
                            SearchRequestBuilder query = client.prepareSearch(new String[]{index}).setIndicesOptions(Utils.indicesOptions()).setQuery((QueryBuilder)QueryBuilders.existsQuery((String)key)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)key).field(key)).size(10000)).setSize(0);
                            multiQuery.add(query);
                        }
                    }
                    return null;
                }

                public Void visit(TermHistogramEstimationData termHistogramEstimationData) {
                    return null;
                }
            });
        });
        HashMap estimationDataMap = Maps.newHashMap(estimationData);
        MultiSearchResponse multiResponse = (MultiSearchResponse)multiQuery.execute().actionGet();
        this.handleSecondPhaseMultiSearchResponse(multiResponse, table, estimationDataMap);
        return estimationDataMap;
    }

    private void handleSecondPhaseMultiSearchResponse(MultiSearchResponse multiResponse, String table, Map<String, EstimationData> estimationDataMap) {
        for (MultiSearchResponse.Item item : multiResponse.getResponses()) {
            SearchResponse response = this.validateAndGetSearchResponse(item, table);
            if (null == response) continue;
            long hits = response.getHits().getTotalHits();
            Map output = response.getAggregations().asMap();
            output.forEach((key, value) -> {
                Terms terms = (Terms)output.get(key);
                estimationDataMap.put((String)key, (EstimationData)TermHistogramEstimationData.builder().count(hits).termCounts(terms.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount))).build());
            });
        }
    }

    private SearchResponse validateAndGetSearchResponse(MultiSearchResponse.Item item, String table) {
        if (item.isFailure()) {
            logger.info("FailureInDeducingCardinality table:{} failureMessage:{}", (Object)table, (Object)item.getFailureMessage());
            return null;
        }
        SearchResponse response = item.getResponse();
        if (null == response.getAggregations()) {
            return null;
        }
        return response;
    }

    @Override
    public boolean exists(String tableName) {
        return this.tableDataStore.containsKey((Object)tableName);
    }

    @Override
    public void delete(String tableName) {
        logger.info("Deleting Table : {}", (Object)tableName);
        if (this.tableDataStore.containsKey((Object)tableName)) {
            this.tableDataStore.delete((Object)tableName);
        }
        logger.info("Deleted Table : {}", (Object)tableName);
    }

    public void start() throws Exception {
        this.tableDataStore = this.hazelcastConnection.getHazelcast().getMap(DATA_MAP);
        this.fieldDataCache = this.hazelcastConnection.getHazelcast().getMap(FIELD_MAP);
        this.fieldDataCardinalityCache = this.hazelcastConnection.getHazelcast().getMap(CARDINALITY_FIELD_MAP);
    }

    public void stop() throws Exception {
    }

    private void saveCardinalityCache(String table, TableFieldMapping tableFieldMapping) {
        try {
            ((IndexRequestBuilder)this.elasticsearchConnection.getClient().prepareIndex().setIndex(CARDINALITY_CACHE_INDEX)).setType("document").setId(table).setSource(this.mapper.writeValueAsBytes((Object)tableFieldMapping), XContentType.JSON).execute().get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Error in saving cardinality cache: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<TableFieldMapping> getAllCardinalityCache() {
        int maxSize = 1000;
        ArrayList<TableFieldMapping> tableFieldMappings = new ArrayList<TableFieldMapping>();
        try {
            SearchResponse response = (SearchResponse)this.elasticsearchConnection.getClient().prepareSearch(new String[]{CARDINALITY_CACHE_INDEX}).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setSize(maxSize).execute().actionGet();
            for (SearchHit hit : CollectionUtils.nullAndEmptySafeValueList((Object[])response.getHits().getHits())) {
                tableFieldMappings.add((TableFieldMapping)this.mapper.readValue(hit.getSourceAsString(), TableFieldMapping.class));
            }
            return tableFieldMappings;
        }
        catch (Exception e) {
            logger.error("Error in getting cardinality caches: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void initializeCardinalityCache() {
        List<TableFieldMapping> tableFieldMappings = this.getAllCardinalityCache();
        for (TableFieldMapping tableFieldMapping : CollectionUtils.nullSafeList(tableFieldMappings)) {
            this.fieldDataCardinalityCache.put((Object)tableFieldMapping.getTable(), (Object)tableFieldMapping);
        }
    }

    private static class FieldMetadataComparator
    implements Comparator<FieldMetadata>,
    Serializable {
        private static final long serialVersionUID = 8557746595191991528L;

        private FieldMetadataComparator() {
        }

        @Override
        public int compare(FieldMetadata o1, FieldMetadata o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getField().compareTo(o2.getField());
        }
    }
}

