/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.mutator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.foxtrot.core.config.TextNodeRemoverConfiguration;
import com.flipkart.foxtrot.core.querystore.mutator.IndexerEventMutator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeTextNodeRemover
implements IndexerEventMutator {
    private static final Logger log = LoggerFactory.getLogger(LargeTextNodeRemover.class);
    private final ObjectMapper objectMapper;
    private final TextNodeRemoverConfiguration configuration;
    private final Random random;

    public LargeTextNodeRemover(ObjectMapper objectMapper, TextNodeRemoverConfiguration textNodeRemoverConfiguration) {
        this.objectMapper = objectMapper;
        this.configuration = textNodeRemoverConfiguration;
        this.random = new Random();
    }

    @Override
    public void mutate(String table, String documentId, JsonNode data) {
        this.walkTree(table, documentId, data);
    }

    private void walkTree(String table, String documentId, JsonNode node) {
        if (node == null || node.isNull()) {
            return;
        }
        if (node.isObject()) {
            this.handleObjectNode(table, documentId, (ObjectNode)node);
        } else if (node.isArray()) {
            this.handleArrayNode(table, documentId, null, (ArrayNode)node);
        }
    }

    private void handleObjectNode(String table, String documentId, ObjectNode objectNode) {
        if (objectNode == null || objectNode.isNull()) {
            return;
        }
        ArrayList toBeRemoved = Lists.newArrayList();
        objectNode.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isTextual()) {
                boolean removeEntry = this.evaluateForRemoval(table, documentId, key, value);
                if (removeEntry) {
                    toBeRemoved.add(entry.getKey());
                }
            } else if (value.isArray()) {
                this.handleArrayNode(table, documentId, key, (ArrayNode)value);
            } else if (value.isObject()) {
                this.handleObjectNode(table, documentId, (ObjectNode)value);
            }
        });
        objectNode.remove((Collection)toBeRemoved);
    }

    private void handleArrayNode(String table, String documentId, String parentKey, ArrayNode arrayNode) {
        if (arrayNode == null || arrayNode.isNull()) {
            return;
        }
        ArrayNode copy = this.objectMapper.createArrayNode();
        arrayNode.elements().forEachRemaining(node -> {
            boolean copyNode = true;
            if (node.isObject()) {
                this.handleObjectNode(table, documentId, (ObjectNode)node);
            } else if (node.isArray()) {
                this.handleArrayNode(table, documentId, parentKey, (ArrayNode)node);
            } else if (node.isTextual()) {
                boolean bl = copyNode = !this.evaluateForRemoval(table, documentId, parentKey, (JsonNode)node);
            }
            if (copyNode) {
                copy.add(node);
            }
        });
        arrayNode.removeAll();
        arrayNode.addAll(copy);
    }

    private boolean evaluateForRemoval(String table, String documentId, String key, JsonNode node) {
        if (!node.isTextual()) {
            return false;
        }
        if (node.isNull()) {
            return false;
        }
        if (node.textValue().length() < this.configuration.getMaxAllowedSize()) {
            return false;
        }
        if (this.random.nextInt(100) < this.configuration.getLogSamplingPercentage()) {
            log.warn("LargeTextNodeDetected table: {} documentId: {} key: {} value: {}", new Object[]{table, documentId, key, node.textValue()});
        }
        return this.random.nextInt(100) < this.configuration.getBlockPercentage();
    }
}

