/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.core.querystore.ActionEvaluationResponse;
import com.flipkart.foxtrot.core.querystore.ActionExecutionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowQueryReporter
implements ActionExecutionObserver {
    private static final Logger log = LoggerFactory.getLogger(SlowQueryReporter.class);

    @Override
    public void postExecution(ActionEvaluationResponse response) {
        if (null != response.getException() || response.isCached()) {
            return;
        }
        if (response.getElapsedTime() > 1000L) {
            try {
                String query = response.getExecutedAction().getObjectMapper().writeValueAsString((Object)response.getRequest());
                log.warn("SLOW_QUERY: Time: {} ms Query: {}", (Object)response.getElapsedTime(), (Object)query);
            }
            catch (JsonProcessingException e) {
                log.error("Error serializing slow query", (Throwable)e);
            }
        }
    }
}

