/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.AnalyticsActionLoaderException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.ActionMetadata;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.dropwizard.lifecycle.Managed;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=20)
public class AnalyticsLoader
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsLoader.class);
    private final Map<String, ActionMetadata> actions = Maps.newHashMap();
    private final TableMetadataManager tableMetadataManager;
    private final DataStore dataStore;
    private final QueryStore queryStore;
    private final ElasticsearchConnection elasticsearchConnection;
    private final CacheManager cacheManager;
    private final ObjectMapper objectMapper;

    @Inject
    public AnalyticsLoader(TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection elasticsearchConnection, CacheManager cacheManager, ObjectMapper objectMapper) {
        this.tableMetadataManager = tableMetadataManager;
        this.dataStore = dataStore;
        this.queryStore = queryStore;
        this.elasticsearchConnection = elasticsearchConnection;
        this.cacheManager = cacheManager;
        this.objectMapper = objectMapper;
    }

    public <R extends ActionRequest> Action<R> getAction(R request) {
        ActionMetadata metadata;
        String className = request.getClass().getCanonicalName();
        if (this.actions.containsKey(className) && (metadata = this.actions.get(className)).getRequest().isInstance(request)) {
            ActionRequest r = metadata.getRequest().cast(request);
            try {
                Constructor<? extends Action> constructor = metadata.getAction().getConstructor(metadata.getRequest(), AnalyticsLoader.class);
                return constructor.newInstance(r, this);
            }
            catch (Exception e) {
                throw FoxtrotExceptions.createActionResolutionException(request, e);
            }
        }
        return null;
    }

    public void register(ActionMetadata actionMetadata, String opcode) {
        this.actions.put(actionMetadata.getRequest().getCanonicalName(), actionMetadata);
        if (actionMetadata.isCacheable()) {
            this.registerCache(opcode);
        }
    }

    public void registerCache(String opcode) {
        this.cacheManager.create(opcode);
    }

    public void start() throws Exception {
        Reflections reflections = new Reflections("com.flipkart.foxtrot", new Scanner[]{new SubTypesScanner()});
        Set actionSet = reflections.getSubTypesOf(Action.class);
        if (actionSet.isEmpty()) {
            throw new AnalyticsActionLoaderException("No analytics actions found!!");
        }
        ArrayList<NamedType> types = new ArrayList<NamedType>();
        for (Class action : actionSet) {
            AnalyticsProvider analyticsProvider = action.getAnnotation(AnalyticsProvider.class);
            String opcode = analyticsProvider.opcode();
            if (Strings.isNullOrEmpty((String)opcode)) {
                throw new AnalyticsActionLoaderException("Invalid annotation on " + action.getCanonicalName());
            }
            this.register(new ActionMetadata(analyticsProvider.request(), action, analyticsProvider.cacheable()), analyticsProvider.opcode());
            types.add(new NamedType(analyticsProvider.request(), opcode));
            types.add(new NamedType(analyticsProvider.response(), opcode));
            logger.info("Registered action: {}", (Object)action.getCanonicalName());
        }
        this.objectMapper.getSubtypeResolver().registerSubtypes(types.toArray(new NamedType[0]));
    }

    public void stop() throws Exception {
    }

    public Map<String, ActionMetadata> getActions() {
        return this.actions;
    }

    public TableMetadataManager getTableMetadataManager() {
        return this.tableMetadataManager;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public QueryStore getQueryStore() {
        return this.queryStore;
    }

    public ElasticsearchConnection getElasticsearchConnection() {
        return this.elasticsearchConnection;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

