/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.stats.AnalyticsRequestFlags;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.Stat;
import com.flipkart.foxtrot.common.stats.StatsTrendRequest;
import com.flipkart.foxtrot.common.stats.StatsTrendResponse;
import com.flipkart.foxtrot.common.stats.StatsTrendValue;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.joda.time.DateTime;

@AnalyticsProvider(opcode="statstrend", request=StatsTrendRequest.class, response=StatsTrendResponse.class, cacheable=false)
public class StatsTrendAction
extends Action<StatsTrendRequest> {
    public StatsTrendAction(StatsTrendRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
    }

    @Override
    public void preprocess() {
        ((StatsTrendRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((StatsTrendRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((StatsTrendRequest)this.getParameter()).getTable();
    }

    @Override
    public String getRequestCacheKey() {
        StatsTrendRequest statsRequest = (StatsTrendRequest)this.getParameter();
        long hashKey = 0L;
        if (statsRequest.getFilters() != null) {
            for (Filter filter : statsRequest.getFilters()) {
                hashKey += (long)(31 * filter.hashCode());
            }
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)statsRequest.getNesting())) {
            for (String field : statsRequest.getNesting()) {
                hashKey += (long)(31 * field.hashCode());
            }
        }
        hashKey += (long)(31 * statsRequest.getPeriod().name().hashCode());
        hashKey += (long)(31 * statsRequest.getTimestamp().hashCode());
        return String.format("stats-trend-%s-%s-%s-%d", statsRequest.getTable(), statsRequest.getField(), statsRequest.getPeriod(), hashKey += (long)(31 * (statsRequest.getField() != null ? statsRequest.getField().hashCode() : "FIELD".hashCode())));
    }

    @Override
    public void validateImpl(StatsTrendRequest parameter) {
        ArrayList validationErrors = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("field name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTimestamp())) {
            validationErrors.add("timestamp field cannot be null or empty");
        }
        if (parameter.getPeriod() == null) {
            validationErrors.add(String.format("specify time period (%s)", StringUtils.join((Object[])Period.values())));
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(StatsTrendRequest parameter) {
        SearchRequestBuilder searchRequestBuilder = this.getRequestBuilder(parameter);
        try {
            SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout());
            return this.getResponse((ActionResponse)response, parameter);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    public SearchRequestBuilder getRequestBuilder(StatsTrendRequest parameter) {
        SearchRequestBuilder searchRequestBuilder;
        try {
            String table = parameter.getTable();
            AbstractAggregationBuilder aggregation = this.buildAggregation(parameter, table);
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(table, (ActionRequest)parameter)).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(0).addAggregation((AggregationBuilder)aggregation);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        return searchRequestBuilder;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse response, StatsTrendRequest parameter) {
        Aggregations aggregations = ((SearchResponse)response).getAggregations();
        if (aggregations != null) {
            return this.buildResponse(parameter, aggregations);
        }
        return null;
    }

    private AbstractAggregationBuilder buildAggregation(StatsTrendRequest request, String table) {
        String field = request.getField();
        DateHistogramInterval interval = Utils.getHistogramInterval(request.getPeriod());
        DateHistogramAggregationBuilder dateHistogramBuilder = Utils.buildDateHistogramAggregation(request.getTimestamp(), interval);
        boolean isNumericField = Utils.isNumericField(this.getTableMetadataManager(), table, field);
        if (isNumericField) {
            dateHistogramBuilder.subAggregation((AggregationBuilder)Utils.buildStatsAggregation(field, ((StatsTrendRequest)this.getParameter()).getStats()));
            if (!AnalyticsRequestFlags.hasFlag((Collection)request.getFlags(), (AnalyticsRequestFlags)AnalyticsRequestFlags.STATS_SKIP_PERCENTILES)) {
                dateHistogramBuilder.subAggregation((AggregationBuilder)Utils.buildPercentileAggregation(field, request.getPercentiles(), request.getCompression()));
            }
        } else {
            dateHistogramBuilder.subAggregation((AggregationBuilder)Utils.buildStatsAggregation(field, Collections.singleton(Stat.COUNT)));
        }
        if (CollectionUtils.isNullOrEmpty((Collection)((StatsTrendRequest)this.getParameter()).getNesting())) {
            return dateHistogramBuilder;
        }
        return Utils.buildTermsAggregation(((StatsTrendRequest)this.getParameter()).getNesting().stream().map(x -> new ResultSort(x, ResultSort.Order.asc)).collect(Collectors.toList()), Sets.newHashSet((Object[])new AggregationBuilder[]{dateHistogramBuilder}));
    }

    private StatsTrendResponse buildResponse(StatsTrendRequest request, Aggregations aggregations) {
        StatsTrendResponse response = new StatsTrendResponse();
        if (CollectionUtils.isNullOrEmpty((Collection)request.getNesting())) {
            List<StatsTrendValue> trends = this.buildStatsTrendValue(request.getField(), aggregations);
            response.setResult(trends);
        } else {
            List<BucketResponse<List<StatsTrendValue>>> buckets = this.buildNestedTrendStats(request.getNesting(), aggregations);
            response.setBuckets(buckets);
        }
        return response;
    }

    private List<BucketResponse<List<StatsTrendValue>>> buildNestedTrendStats(List<String> nesting, Aggregations aggregations) {
        String field = nesting.get(0);
        ArrayList<String> remainingFields = nesting.size() > 1 ? nesting.subList(1, nesting.size()) : new ArrayList<String>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        ArrayList bucketResponses = Lists.newArrayList();
        for (Terms.Bucket bucket : terms.getBuckets()) {
            BucketResponse bucketResponse = new BucketResponse();
            bucketResponse.setKey(String.valueOf(bucket.getKey()));
            if (nesting.size() == 1) {
                bucketResponse.setResult(this.buildStatsTrendValue(((StatsTrendRequest)this.getParameter()).getField(), bucket.getAggregations()));
            } else {
                bucketResponse.setBuckets(this.buildNestedTrendStats(remainingFields, bucket.getAggregations()));
            }
            bucketResponses.add(bucketResponse);
        }
        return bucketResponses;
    }

    private List<StatsTrendValue> buildStatsTrendValue(String field, Aggregations aggregations) {
        String dateHistogramKey = Utils.getDateHistogramKey(((StatsTrendRequest)this.getParameter()).getTimestamp());
        Histogram dateHistogram = (Histogram)aggregations.get(dateHistogramKey);
        List buckets = dateHistogram.getBuckets();
        ArrayList statsValueList = Lists.newArrayList();
        String metricKey = Utils.getExtendedStatsAggregationKey(field);
        String percentileMetricKey = Utils.getPercentileAggregationKey(field);
        for (Histogram.Bucket bucket : buckets) {
            StatsTrendValue statsTrendValue = new StatsTrendValue();
            DateTime key = (DateTime)bucket.getKey();
            statsTrendValue.setPeriod((Number)key.getMillis());
            Aggregation statAggregation = (Aggregation)bucket.getAggregations().getAsMap().get(metricKey);
            statsTrendValue.setStats(Utils.toStats(statAggregation));
            Aggregation rawPercentiles = (Aggregation)bucket.getAggregations().getAsMap().get(percentileMetricKey);
            if (null != rawPercentiles) {
                Percentiles internalPercentile = (Percentiles)Percentiles.class.cast(rawPercentiles);
                statsTrendValue.setPercentiles(Utils.createPercentilesResponse(internalPercentile));
            }
            statsValueList.add(statsTrendValue);
        }
        return statsValueList;
    }

    @Override
    protected Filter getDefaultTimeSpan() {
        LastFilter lastFilter = new LastFilter();
        lastFilter.setField("_timestamp");
        lastFilter.setDuration(Duration.days((long)1L));
        return lastFilter;
    }
}

