/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.stats.AnalyticsRequestFlags;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.Stat;
import com.flipkart.foxtrot.common.stats.StatsRequest;
import com.flipkart.foxtrot.common.stats.StatsResponse;
import com.flipkart.foxtrot.common.stats.StatsValue;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;

@AnalyticsProvider(opcode="stats", request=StatsRequest.class, response=StatsResponse.class, cacheable=false)
public class StatsAction
extends Action<StatsRequest> {
    public StatsAction(StatsRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
    }

    private static StatsValue buildStatsValue(String field, Aggregations aggregations) {
        String metricKey = Utils.getExtendedStatsAggregationKey(field);
        String percentileMetricKey = Utils.getPercentileAggregationKey(field);
        StatsValue statsValue = new StatsValue();
        statsValue.setStats(Utils.toStats((Aggregation)aggregations.getAsMap().get(metricKey)));
        Percentiles internalPercentile = (Percentiles)aggregations.getAsMap().get(percentileMetricKey);
        if (null != internalPercentile) {
            statsValue.setPercentiles(Utils.createPercentilesResponse(internalPercentile));
        }
        return statsValue;
    }

    @Override
    public void preprocess() {
        ((StatsRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((StatsRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((StatsRequest)this.getParameter()).getTable();
    }

    @Override
    public String getRequestCacheKey() {
        long statsHashKey = 0L;
        StatsRequest statsRequest = (StatsRequest)this.getParameter();
        if (null != statsRequest.getFilters()) {
            for (Filter filter : statsRequest.getFilters()) {
                statsHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)statsRequest.getNesting())) {
            for (String nestingKey : statsRequest.getNesting()) {
                statsHashKey += (long)(31 * nestingKey.hashCode());
            }
        }
        return String.format("%s-%s-%d", statsRequest.getTable(), statsRequest.getField(), statsHashKey);
    }

    @Override
    public void validateImpl(StatsRequest parameter) {
        ArrayList validationErrors = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("field name cannot be null or empty");
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(StatsRequest parameter) {
        SearchRequestBuilder searchRequestBuilder = this.getRequestBuilder(parameter);
        try {
            SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout());
            return this.getResponse((ActionResponse)response, parameter);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    public SearchRequestBuilder getRequestBuilder(StatsRequest parameter) {
        SearchRequestBuilder searchRequestBuilder;
        try {
            AbstractAggregationBuilder extendedStats;
            String table = parameter.getTable();
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(table, (ActionRequest)parameter)).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(10000);
            AbstractAggregationBuilder percentiles = null;
            String field = ((StatsRequest)this.getParameter()).getField();
            boolean isNumericField = Utils.isNumericField(this.getTableMetadataManager(), table, field);
            if (isNumericField) {
                if (!AnalyticsRequestFlags.hasFlag((Collection)parameter.getFlags(), (AnalyticsRequestFlags)AnalyticsRequestFlags.STATS_SKIP_PERCENTILES)) {
                    percentiles = Utils.buildPercentileAggregation(field, ((StatsRequest)this.getParameter()).getPercentiles());
                    searchRequestBuilder.addAggregation((AggregationBuilder)percentiles);
                }
                extendedStats = Utils.buildStatsAggregation(field, ((StatsRequest)this.getParameter()).getStats());
            } else {
                extendedStats = Utils.buildStatsAggregation(field, Collections.singleton(Stat.COUNT));
            }
            searchRequestBuilder.addAggregation((AggregationBuilder)extendedStats);
            if (!CollectionUtils.isNullOrEmpty((Collection)((StatsRequest)this.getParameter()).getNesting())) {
                HashSet<AggregationBuilder> subAggregations = new HashSet<AggregationBuilder>();
                subAggregations.add((AggregationBuilder)extendedStats);
                if (null != percentiles) {
                    subAggregations.add((AggregationBuilder)percentiles);
                }
                searchRequestBuilder.addAggregation((AggregationBuilder)Utils.buildTermsAggregation(((StatsRequest)this.getParameter()).getNesting().stream().map(x -> new ResultSort(x, ResultSort.Order.asc)).collect(Collectors.toList()), subAggregations));
            }
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        return searchRequestBuilder;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse response, StatsRequest parameter) {
        Aggregations aggregations = ((SearchResponse)response).getAggregations();
        if (aggregations != null) {
            return this.buildResponse(parameter, aggregations);
        }
        return null;
    }

    private StatsResponse buildResponse(StatsRequest request, Aggregations aggregations) {
        StatsValue statsValue = StatsAction.buildStatsValue(request.getField(), aggregations);
        List<BucketResponse<StatsValue>> buckets = null;
        if (!CollectionUtils.isNullOrEmpty((Collection)request.getNesting())) {
            buckets = this.buildNestedStats(request.getNesting(), aggregations);
        }
        StatsResponse statsResponse = new StatsResponse();
        statsResponse.setResult(statsValue);
        statsResponse.setBuckets(buckets);
        return statsResponse;
    }

    private List<BucketResponse<StatsValue>> buildNestedStats(List<String> nesting, Aggregations aggregations) {
        String field = nesting.get(0);
        ArrayList<String> remainingFields = nesting.size() > 1 ? nesting.subList(1, nesting.size()) : new ArrayList<String>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        ArrayList bucketResponses = Lists.newArrayList();
        for (Terms.Bucket bucket : terms.getBuckets()) {
            BucketResponse bucketResponse = new BucketResponse();
            bucketResponse.setKey(String.valueOf(bucket.getKey()));
            if (nesting.size() == 1) {
                bucketResponse.setResult((Object)StatsAction.buildStatsValue(((StatsRequest)this.getParameter()).getField(), bucket.getAggregations()));
            } else {
                bucketResponse.setBuckets(this.buildNestedStats(remainingFields, bucket.getAggregations()));
            }
            bucketResponses.add(bucketResponse);
        }
        return bucketResponses;
    }
}

