/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.collections.CollectionUtils;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.MultiQueryRequest;
import com.flipkart.foxtrot.common.query.MultiQueryResponse;
import com.flipkart.foxtrot.common.query.MultiTimeQueryRequest;
import com.flipkart.foxtrot.common.query.MultiTimeQueryResponse;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;

@AnalyticsProvider(opcode="multi_time_query", request=MultiTimeQueryRequest.class, response=MultiTimeQueryResponse.class, cacheable=false)
public class MultiTimeQueryAction
extends Action<MultiTimeQueryRequest> {
    private AnalyticsLoader analyticsLoader;
    private Action action;
    private MultiQueryRequest multiQueryRequest;

    public MultiTimeQueryAction(MultiTimeQueryRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
        this.analyticsLoader = analyticsLoader;
    }

    @Override
    public void preprocess() {
        MultiTimeQueryRequest multiTimeQueryRequest = (MultiTimeQueryRequest)this.getParameter();
        if (multiTimeQueryRequest.getActionRequest() == null && CollectionUtils.isEmpty((Collection)multiTimeQueryRequest.getFilters())) {
            throw FoxtrotExceptions.createBadRequestException("multi_time_query", "No Between Filter found in actionRequest multiQueryRequest : " + this.multiQueryRequest.toString());
        }
        if (CollectionUtils.isEmpty((Collection)multiTimeQueryRequest.getActionRequest().getFilters())) {
            multiTimeQueryRequest.getActionRequest().setFilters((List)Lists.newArrayList());
        }
        multiTimeQueryRequest.getActionRequest().getFilters().addAll(multiTimeQueryRequest.getFilters());
        Optional<Filter> optionalBetweenFilter = multiTimeQueryRequest.getActionRequest().getFilters().stream().filter(filter -> filter instanceof BetweenFilter).findFirst();
        if (!optionalBetweenFilter.isPresent()) {
            throw FoxtrotExceptions.createBadRequestException("multi_time_query", "No Between Filter found in actionRequest multiQueryRequest : " + this.multiQueryRequest.toString());
        }
        BetweenFilter betweenFilter = (BetweenFilter)optionalBetweenFilter.get();
        int sampleSize = multiTimeQueryRequest.getSampleSize() != 0 ? multiTimeQueryRequest.getSampleSize() : (multiTimeQueryRequest.getSkipDuration().toHours() > TimeUnit.DAYS.toHours(1L) ? (int)(30L / multiTimeQueryRequest.getSkipDuration().toDays()) : (int)(24L / multiTimeQueryRequest.getSkipDuration().toHours()));
        this.multiQueryRequest = this.createMultiQueryRequests(sampleSize, betweenFilter);
        this.action = this.analyticsLoader.getAction(this.multiQueryRequest);
        if (null == this.action) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)multiTimeQueryRequest, null);
        }
        this.action.preprocess();
    }

    @Override
    public String getMetricKey() {
        return this.action.getMetricKey();
    }

    @Override
    public String getRequestCacheKey() {
        return this.action.getRequestCacheKey();
    }

    @Override
    public void validateImpl(MultiTimeQueryRequest parameter) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (parameter.getActionRequest() == null) {
            validationErrors.add("action request cannot be null or empty");
        }
        if (parameter.getSkipDuration() == null) {
            validationErrors.add("skip duration cannot be null or empty");
        }
        if (CollectionUtils.isNotEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
        this.action.validateImpl(this.multiQueryRequest);
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(MultiTimeQueryRequest parameter) {
        MultiTimeQueryResponse multiTimeQueryResponse = new MultiTimeQueryResponse();
        multiTimeQueryResponse.setResponses(((MultiQueryResponse)this.action.execute(this.multiQueryRequest)).getResponses());
        return multiTimeQueryResponse;
    }

    @Override
    public ActionRequestBuilder getRequestBuilder(MultiTimeQueryRequest parameter) {
        return this.action.getRequestBuilder(this.multiQueryRequest);
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse multiSearchResponse, MultiTimeQueryRequest parameter) {
        MultiQueryResponse multiQueryResponse = (MultiQueryResponse)this.action.getResponse(multiSearchResponse, this.multiQueryRequest);
        return new MultiTimeQueryResponse(multiQueryResponse.getResponses());
    }

    private MultiQueryRequest createMultiQueryRequests(int sampleSize, BetweenFilter betweenFilter) {
        MultiTimeQueryRequest multiTimeQueryRequest = (MultiTimeQueryRequest)this.getParameter();
        HashMap<String, ActionRequest> requests = new HashMap<String, ActionRequest>();
        long from = betweenFilter.getFrom().longValue();
        long to = betweenFilter.getTo().longValue();
        for (int itr = 0; itr < sampleSize; ++itr) {
            List filters = multiTimeQueryRequest.getActionRequest().getFilters();
            for (int i = 0; i < filters.size(); ++i) {
                if (!(filters.get(i) instanceof BetweenFilter)) continue;
                BetweenFilter tempBetweenFilter = (BetweenFilter)filters.get(i);
                BetweenFilter tempBetweenFilter1 = new BetweenFilter(tempBetweenFilter.getField(), (Number)from, (Number)to, tempBetweenFilter.isFilterTemporal());
                filters.set(i, tempBetweenFilter1);
                break;
            }
            multiTimeQueryRequest.getActionRequest().setFilters(filters);
            try {
                requests.put(Long.toString(from), (ActionRequest)multiTimeQueryRequest.getActionRequest().clone());
            }
            catch (Exception e) {
                throw FoxtrotExceptions.queryCreationException(multiTimeQueryRequest.getActionRequest(), e);
            }
            from -= multiTimeQueryRequest.getSkipDuration().toMilliseconds();
            to -= multiTimeQueryRequest.getSkipDuration().toMilliseconds();
        }
        return new MultiQueryRequest(requests);
    }
}

