/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.collections.CollectionUtils;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.query.MultiQueryRequest;
import com.flipkart.foxtrot.common.query.MultiQueryResponse;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.actions.ActionInterface;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.glassfish.hk2.api.MultiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyticsProvider(opcode="multi_query", request=MultiQueryRequest.class, response=MultiQueryResponse.class, cacheable=false)
public class MultiQueryAction
extends Action<MultiQueryRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiQueryAction.class);
    private AnalyticsLoader analyticsLoader;
    private Map<ActionRequest, Action> requestActionMap = Maps.newHashMap();

    public MultiQueryAction(MultiQueryRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
        this.analyticsLoader = analyticsLoader;
    }

    @Override
    public void preprocess() {
        MultiQueryRequest multiQueryRequest = (MultiQueryRequest)this.getParameter();
        this.createActions(multiQueryRequest);
        this.processForSubQueries(multiQueryRequest, (action, request) -> {
            action.preprocess();
            return null;
        });
    }

    @Override
    public String getMetricKey() {
        return this.processForSubQueries((MultiQueryRequest)this.getParameter(), (action, request) -> action.getMetricKey());
    }

    @Override
    public String getRequestCacheKey() {
        return this.processForSubQueries((MultiQueryRequest)this.getParameter(), (action, request) -> action.getRequestCacheKey());
    }

    @Override
    public void validateImpl(MultiQueryRequest parameter) {
        MultiQueryRequest multiQueryRequest = (MultiQueryRequest)this.getParameter();
        MultiException multiException = new MultiException();
        this.processForSubQueries(multiQueryRequest, (action, request) -> {
            try {
                action.validateImpl(request);
            }
            catch (MalformedQueryException e) {
                multiException.addError((Throwable)e);
            }
            return null;
        });
        if (CollectionUtils.isNotEmpty((Collection)multiException.getErrors())) {
            throw multiException;
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(MultiQueryRequest parameter) {
        MultiSearchRequestBuilder multiSearchRequestBuilder = this.getRequestBuilder(parameter);
        try {
            LOGGER.info("Search: {}", (Object)multiSearchRequestBuilder);
            MultiSearchResponse multiSearchResponse = (MultiSearchResponse)multiSearchRequestBuilder.execute().actionGet();
            return this.getResponse((ActionResponse)multiSearchResponse, parameter);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    public MultiSearchRequestBuilder getRequestBuilder(MultiQueryRequest parameter) {
        MultiSearchRequestBuilder multiSearchRequestBuilder = this.getConnection().getClient().prepareMultiSearch();
        for (Map.Entry entry : parameter.getRequests().entrySet()) {
            ActionRequest request = (ActionRequest)entry.getValue();
            Action<ActionRequest> action = this.analyticsLoader.getAction(request);
            if (null == action) {
                throw FoxtrotExceptions.queryCreationException(request, null);
            }
            ActionRequestBuilder requestBuilder = action.getRequestBuilder(request);
            if (!(requestBuilder instanceof SearchRequestBuilder)) continue;
            multiSearchRequestBuilder.add((SearchRequestBuilder)requestBuilder);
        }
        return multiSearchRequestBuilder;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse multiSearchResponse, MultiQueryRequest parameter) {
        HashMap queryVsQueryResponseMap = Maps.newHashMap();
        int queryCounter = 0;
        ArrayList queryKeys = Lists.newArrayList();
        ArrayList requests = Lists.newArrayList();
        for (Map.Entry entry : ((MultiQueryRequest)this.getParameter()).getRequests().entrySet()) {
            queryKeys.add(entry.getKey());
            requests.add(entry.getValue());
        }
        for (MultiSearchResponse.Item item : ((MultiSearchResponse)multiSearchResponse).getResponses()) {
            Action<ActionRequest> action = null;
            ActionRequest request = (ActionRequest)requests.get(queryCounter);
            try {
                action = this.analyticsLoader.getAction(request);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while executing multiQuery request : {}", (Throwable)e);
            }
            if (null == action) {
                throw FoxtrotExceptions.queryCreationException(request, null);
            }
            String key = (String)queryKeys.get(queryCounter++);
            com.flipkart.foxtrot.common.ActionResponse response = action.getResponse((ActionResponse)item.getResponse(), request);
            queryVsQueryResponseMap.put(key, response);
        }
        return new MultiQueryResponse((Map)queryVsQueryResponseMap);
    }

    private void createActions(MultiQueryRequest multiQueryRequest) {
        for (Map.Entry entry : multiQueryRequest.getRequests().entrySet()) {
            Action action;
            ActionRequest request = (ActionRequest)entry.getValue();
            if (this.requestActionMap.get(request) != null) {
                action = this.requestActionMap.get(request);
            } else {
                action = this.analyticsLoader.getAction(request);
                this.requestActionMap.put(request, action);
            }
            if (null != action) continue;
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)multiQueryRequest, Collections.singletonList("No action found for the sub request : " + request.toString()));
        }
    }

    private String processForSubQueries(MultiQueryRequest multiQueryRequest, ActionInterface actionInterface) {
        ArrayList results = Lists.newArrayList();
        for (Map.Entry entry : multiQueryRequest.getRequests().entrySet()) {
            String result = actionInterface.invoke(this.requestActionMap.get(entry.getValue()), (ActionRequest)entry.getValue());
            if (Strings.isNullOrEmpty((String)result)) continue;
            results.add(result);
        }
        return String.join((CharSequence)"-", results);
    }
}

