/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.histogram.HistogramRequest;
import com.flipkart.foxtrot.common.histogram.HistogramResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.joda.time.DateTime;

@AnalyticsProvider(opcode="histogram", request=HistogramRequest.class, response=HistogramResponse.class, cacheable=true)
public class HistogramAction
extends Action<HistogramRequest> {
    public HistogramAction(HistogramRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
    }

    @Override
    public String getMetricKey() {
        return ((HistogramRequest)this.getParameter()).getTable();
    }

    @Override
    public void preprocess() {
        ((HistogramRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((HistogramRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getRequestCacheKey() {
        long filterHashKey = 0L;
        HistogramRequest query = (HistogramRequest)this.getParameter();
        if (null != query.getFilters()) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (null != query.getUniqueCountOn()) {
            filterHashKey += (long)(31 * query.getUniqueCountOn().hashCode());
        }
        return String.format("%s-%s-%s-%d", query.getTable(), query.getPeriod().name(), query.getField(), filterHashKey);
    }

    @Override
    public void validateImpl(HistogramRequest parameter) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("timestamp field cannot be null or empty");
        }
        if (parameter.getPeriod() == null) {
            validationErrors.add("time period cannot be null");
        }
        if (parameter.getUniqueCountOn() != null && parameter.getUniqueCountOn().isEmpty()) {
            validationErrors.add("distinct field cannot be empty (can be null)");
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(HistogramRequest parameter) {
        SearchRequestBuilder searchRequestBuilder = this.getRequestBuilder(parameter);
        try {
            SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout());
            return this.getResponse((ActionResponse)response, parameter);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    public SearchRequestBuilder getRequestBuilder(HistogramRequest parameter) {
        SearchRequestBuilder searchRequestBuilder;
        AbstractAggregationBuilder aggregationBuilder = this.buildAggregation();
        try {
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(10000).addAggregation((AggregationBuilder)aggregationBuilder);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        return searchRequestBuilder;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse response, HistogramRequest parameter) {
        Aggregations aggregations = ((SearchResponse)response).getAggregations();
        return this.buildResponse(aggregations);
    }

    private HistogramResponse buildResponse(Aggregations aggregations) {
        if (aggregations == null) {
            return new HistogramResponse(Collections.emptyList());
        }
        String dateHistogramKey = Utils.getDateHistogramKey(((HistogramRequest)this.getParameter()).getField());
        Histogram dateHistogram = (Histogram)aggregations.get(dateHistogramKey);
        List buckets = dateHistogram.getBuckets();
        ArrayList<HistogramResponse.Count> counts = new ArrayList<HistogramResponse.Count>(buckets.size());
        for (Histogram.Bucket bucket : buckets) {
            if (!CollectionUtils.isNullOrEmpty((String)((HistogramRequest)this.getParameter()).getUniqueCountOn())) {
                String key = Utils.sanitizeFieldForAggregation(((HistogramRequest)this.getParameter()).getUniqueCountOn());
                Cardinality cardinality = (Cardinality)bucket.getAggregations().get(key);
                counts.add(new HistogramResponse.Count((Number)((DateTime)bucket.getKey()).getMillis(), cardinality.getValue()));
                continue;
            }
            counts.add(new HistogramResponse.Count((Number)((DateTime)bucket.getKey()).getMillis(), bucket.getDocCount()));
        }
        return new HistogramResponse(counts);
    }

    private AbstractAggregationBuilder buildAggregation() {
        DateHistogramInterval interval = Utils.getHistogramInterval(((HistogramRequest)this.getParameter()).getPeriod());
        DateHistogramAggregationBuilder histogramBuilder = Utils.buildDateHistogramAggregation(((HistogramRequest)this.getParameter()).getField(), interval);
        if (!CollectionUtils.isNullOrEmpty((String)((HistogramRequest)this.getParameter()).getUniqueCountOn())) {
            histogramBuilder.subAggregation((AggregationBuilder)Utils.buildCardinalityAggregation(((HistogramRequest)this.getParameter()).getUniqueCountOn()));
        }
        return histogramBuilder;
    }

    @Override
    protected Filter getDefaultTimeSpan() {
        LastFilter lastFilter = new LastFilter();
        lastFilter.setField("_timestamp");
        lastFilter.setDuration(Duration.days((long)1L));
        return lastFilter;
    }
}

