/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.collections.CollectionUtils;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.FieldMetadata;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.common.TableFieldMapping;
import com.flipkart.foxtrot.common.estimation.CardinalityEstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationDataVisitor;
import com.flipkart.foxtrot.common.estimation.FixedEstimationData;
import com.flipkart.foxtrot.common.estimation.PercentileEstimationData;
import com.flipkart.foxtrot.common.estimation.TermHistogramEstimationData;
import com.flipkart.foxtrot.common.group.GroupRequest;
import com.flipkart.foxtrot.common.group.GroupResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.FilterVisitor;
import com.flipkart.foxtrot.common.query.FilterVisitorAdapter;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.general.InFilter;
import com.flipkart.foxtrot.common.query.general.NotEqualsFilter;
import com.flipkart.foxtrot.common.query.general.NotInFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.query.string.ContainsFilter;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.common.PeriodSelector;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchQueryStore;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyticsProvider(opcode="group", request=GroupRequest.class, response=GroupResponse.class, cacheable=true)
public class GroupAction
extends Action<GroupRequest> {
    private static final Logger log = LoggerFactory.getLogger(GroupAction.class);
    private static final long MAX_CARDINALITY = 50000L;
    private static final long MIN_ESTIMATION_THRESHOLD = 1000L;
    private static final double PROBABILITY_CUT_OFF = 0.5;

    public GroupAction(GroupRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
    }

    @Override
    public void preprocess() {
        ((GroupRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((GroupRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((GroupRequest)this.getParameter()).getTable();
    }

    @Override
    public String getRequestCacheKey() {
        long filterHashKey = 0L;
        GroupRequest query = (GroupRequest)this.getParameter();
        if (null != query.getFilters()) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (null != query.getUniqueCountOn()) {
            filterHashKey += (long)(31 * query.getUniqueCountOn().hashCode());
        }
        for (int i = 0; i < query.getNesting().size(); ++i) {
            filterHashKey += (long)(31 * ((String)query.getNesting().get(i)).hashCode() * (i + 1));
        }
        return String.format("%s-%d", query.getTable(), filterHashKey);
    }

    @Override
    public void validateImpl(GroupRequest parameter) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty((Collection)parameter.getNesting())) {
            validationErrors.add("at least one grouping parameter is required");
        } else {
            validationErrors.addAll(parameter.getNesting().stream().filter(com.flipkart.foxtrot.common.util.CollectionUtils::isNullOrEmpty).map(field -> "grouping parameter cannot have null or empty name").collect(Collectors.toList()));
        }
        if (parameter.getUniqueCountOn() != null && parameter.getUniqueCountOn().isEmpty()) {
            validationErrors.add("unique field cannot be empty (can be null)");
        }
        this.validateCardinality(parameter);
        if (!com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(GroupRequest parameter) {
        SearchRequestBuilder query = this.getRequestBuilder(parameter);
        try {
            SearchResponse response = (SearchResponse)query.execute().actionGet(this.getGetQueryTimeout());
            return this.getResponse((ActionResponse)response, parameter);
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    public SearchRequestBuilder getRequestBuilder(GroupRequest parameter) {
        SearchRequestBuilder query;
        try {
            query = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setIndicesOptions(Utils.indicesOptions());
            AbstractAggregationBuilder aggregation = this.buildAggregation();
            query.setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(10000).addAggregation((AggregationBuilder)aggregation);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        return query;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse response, GroupRequest parameter) {
        List fields = parameter.getNesting();
        Aggregations aggregations = ((SearchResponse)response).getAggregations();
        if (aggregations == null) {
            return new GroupResponse(Collections.emptyMap());
        }
        return new GroupResponse(this.getMap(fields, aggregations));
    }

    private double estimateProbability(TableFieldMapping tableFieldMapping, GroupRequest parameter) {
        Set mappings = tableFieldMapping.getMappings();
        Map<String, FieldMetadata> metaMap = mappings.stream().collect(Collectors.toMap(FieldMetadata::getField, mapping -> mapping));
        String cacheKey = this.getRequestCacheKey();
        long estimatedMaxDocCount = this.extractMaxDocCount(metaMap);
        log.debug("cacheKey:{} msg:DOC_COUNT_ESTIMATION_COMPLETED maxDocCount:{}", (Object)cacheKey, (Object)estimatedMaxDocCount);
        long estimatedDocCountBasedOnTime = this.estimateDocCountBasedOnTime(estimatedMaxDocCount, parameter, this.getTableMetadataManager(), tableFieldMapping.getTable());
        log.debug("cacheKey:{} msg:TIME_BASED_DOC_ESTIMATION_COMPLETED maxDocCount:{} docCountAfterTimeFilters:{}", new Object[]{cacheKey, estimatedMaxDocCount, estimatedDocCountBasedOnTime});
        final long estimatedDocCountAfterFilters = this.estimateDocCountWithFilters(estimatedDocCountBasedOnTime, metaMap, parameter.getFilters());
        log.debug("cacheKey:{} msg:ALL_FILTER_ESTIMATION_COMPLETED maxDocCount:{} docCountAfterTimeFilters:{} docCountAfterFilters:{}", new Object[]{cacheKey, estimatedMaxDocCount, estimatedDocCountBasedOnTime, estimatedDocCountAfterFilters});
        if (estimatedDocCountAfterFilters < 1000L) {
            log.debug("cacheKey:{} msg:NESTING_ESTIMATION_SKIPPED estimatedDocCount:{} threshold:{}", new Object[]{cacheKey, estimatedDocCountAfterFilters, 1000L});
            return 0.0;
        }
        long outputCardinality = 1L;
        final AtomicBoolean reduceCardinality = new AtomicBoolean(false);
        for (int i = 0; i < parameter.getNesting().size(); ++i) {
            String field = (String)parameter.getNesting().get(i);
            FieldMetadata metadata = metaMap.get(field);
            if (null == metadata || null == metadata.getEstimationData()) {
                log.warn("cacheKey:{} msg:NO_FIELD_ESTIMATION_DATA table:{} field:{}", new Object[]{cacheKey, parameter.getTable(), field});
                continue;
            }
            long fieldCardinality = (Long)metadata.getEstimationData().accept((EstimationDataVisitor)new EstimationDataVisitor<Long>(){

                public Long visit(FixedEstimationData fixedEstimationData) {
                    return fixedEstimationData.getCount();
                }

                public Long visit(PercentileEstimationData percentileEstimationData) {
                    reduceCardinality.getAndSet(true);
                    return percentileEstimationData.getCardinality();
                }

                public Long visit(CardinalityEstimationData cardinalityEstimationData) {
                    return (long)((double)(cardinalityEstimationData.getCardinality() * estimatedDocCountAfterFilters) / (double)cardinalityEstimationData.getCount());
                }

                public Long visit(TermHistogramEstimationData termEstimationData) {
                    reduceCardinality.getAndSet(true);
                    return termEstimationData.getTermCounts().size();
                }
            });
            log.debug("cacheKey:{} msg:NESTING_FIELD_ESTIMATED field:{} overallCardinality:{} fieldCardinality:{} newCardinality:{}", new Object[]{cacheKey, field, outputCardinality, fieldCardinality, outputCardinality * fieldCardinality});
            fieldCardinality = (long)Utils.ensureOne(fieldCardinality);
            log.debug("cacheKey:{} msg:NESTING_FIELD_ESTIMATION_COMPLETED field:{} overallCardinality:{} fieldCardinality:{} newCardinality:{}", new Object[]{cacheKey, field, outputCardinality, fieldCardinality, outputCardinality * fieldCardinality});
            outputCardinality *= fieldCardinality;
        }
        if (estimatedMaxDocCount != 0L && (double)estimatedDocCountAfterFilters / (double)estimatedMaxDocCount < 1.0 && reduceCardinality.get()) {
            outputCardinality = (long)((double)outputCardinality * ((double)estimatedDocCountAfterFilters / (double)estimatedMaxDocCount));
        }
        log.debug("cacheKey:{} msg:NESTING_FIELDS_ESTIMATION_COMPLETED maxDocCount:{} docCountAfterTimeFilters:{} docCountAfterFilters:{} outputCardinality:{}", new Object[]{cacheKey, estimatedMaxDocCount, estimatedDocCountBasedOnTime, estimatedDocCountAfterFilters, outputCardinality});
        long maxCardinality = 50000L;
        if (this.getQueryStore() instanceof ElasticsearchQueryStore && ((ElasticsearchQueryStore)this.getQueryStore()).getCardinalityConfig() != null && ((ElasticsearchQueryStore)this.getQueryStore()).getCardinalityConfig().getMaxCardinality() != 0L) {
            maxCardinality = ((ElasticsearchQueryStore)this.getQueryStore()).getCardinalityConfig().getMaxCardinality();
        }
        if (outputCardinality > maxCardinality) {
            log.warn("Output cardinality : {}, estimatedMaxDocCount : {}, estimatedDocCountBasedOnTime : {}, estimatedDocCountAfterFilters : {}, TableFieldMapping : {},  Query: {}", new Object[]{outputCardinality, estimatedMaxDocCount, estimatedDocCountBasedOnTime, estimatedDocCountAfterFilters, tableFieldMapping, parameter.toString()});
            return 1.0;
        }
        return 0.0;
    }

    private long estimateDocCountBasedOnTime(long currentDocCount, GroupRequest parameter, TableMetadataManager tableMetadataManager, String table) {
        Interval queryInterval = new PeriodSelector(parameter.getFilters()).analyze();
        long minutes = queryInterval.toDuration().getStandardMinutes();
        double days = (double)minutes / (double)TimeUnit.DAYS.toMinutes(1L);
        Table tableMetadata = tableMetadataManager.get(table);
        int maxDays = 0;
        if (tableMetadata != null) {
            maxDays = tableMetadata.getTtl();
        }
        if (maxDays == 0) {
            maxDays = 30;
        }
        if (days > (double)maxDays) {
            return currentDocCount * (long)maxDays;
        }
        return (long)((double)currentDocCount * days);
    }

    private long extractMaxDocCount(Map<String, FieldMetadata> metaMap) {
        return metaMap.values().stream().map(x -> x.getEstimationData() == null ? 0L : x.getEstimationData().getCount()).max(Comparator.naturalOrder()).orElse(0L);
    }

    private long estimateDocCountWithFilters(long currentDocCount, Map<String, FieldMetadata> metaMap, List<Filter> filters) {
        if (com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty(filters)) {
            return currentDocCount;
        }
        String cacheKey = this.getRequestCacheKey();
        double overallFilterMultiplier = 1.0;
        for (Filter filter : filters) {
            String filterField = filter.getField();
            FieldMetadata fieldMetadata = metaMap.get(filterField);
            if (null == fieldMetadata || null == fieldMetadata.getEstimationData()) {
                log.warn("cacheKey:{} msg:NO_FIELD_ESTIMATION_DATA field:{}", (Object)cacheKey, (Object)filterField);
                continue;
            }
            log.debug("cacheKey:{} msg:FILTER_ESTIMATION_STARTED filter:{} mapping:{}", new Object[]{cacheKey, filter, fieldMetadata});
            double currentFilterMultiplier = (Double)fieldMetadata.getEstimationData().accept(this.getDocCountWithFilterEstimationDataVisitor(filter, cacheKey));
            log.debug("cacheKey:{} msg:FILTER_ESTIMATION_COMPLETED field:{} fieldMultiplier:{} overallOldMultiplier:{} overallNewMultiplier:{}", new Object[]{cacheKey, filterField, currentFilterMultiplier, overallFilterMultiplier, overallFilterMultiplier * currentFilterMultiplier});
            overallFilterMultiplier *= currentFilterMultiplier;
        }
        return (long)((double)currentDocCount * overallFilterMultiplier);
    }

    private EstimationDataVisitor<Double> getDocCountWithFilterEstimationDataVisitor(final Filter filter, final String cacheKey) {
        return new EstimationDataVisitor<Double>(){

            public Double visit(FixedEstimationData fixedEstimationData) {
                return (Double)filter.accept((FilterVisitor)GroupAction.this.getFixedFilterVisitorAdapter(fixedEstimationData));
            }

            public Double visit(PercentileEstimationData percentileEstimationData) {
                double[] percentiles = percentileEstimationData.getValues();
                long numMatches = percentileEstimationData.getCount();
                return (Double)filter.accept((FilterVisitor)GroupAction.this.getPercentileFilterVisitorAdapter(percentiles, cacheKey, numMatches));
            }

            public Double visit(CardinalityEstimationData cardinalityEstimationData) {
                return (Double)filter.accept((FilterVisitor)GroupAction.this.getCardinalityFilterVisitorAdapter(cardinalityEstimationData));
            }

            public Double visit(TermHistogramEstimationData termEstimationData) {
                long totalCount = termEstimationData.getCount();
                return (Double)filter.accept((FilterVisitor)GroupAction.this.getTermHistogramFilterVisitorAdapter(termEstimationData, totalCount));
            }
        };
    }

    private FilterVisitorAdapter<Double> getFixedFilterVisitorAdapter(final FixedEstimationData fixedEstimationData) {
        return new FilterVisitorAdapter<Double>(Double.valueOf(1.0)){

            public Double visit(EqualsFilter equalsFilter) {
                return 1.0 / Utils.ensureOne(fixedEstimationData.getCount());
            }

            public Double visit(NotEqualsFilter notEqualsFilter) {
                double numerator = Utils.ensurePositive(fixedEstimationData.getCount() - 1L);
                return numerator / Utils.ensureOne(fixedEstimationData.getCount());
            }

            public Double visit(ContainsFilter stringContainsFilterElement) {
                return 1.0 / Utils.ensureOne(fixedEstimationData.getCount());
            }

            public Double visit(InFilter inFilter) {
                return Utils.ensurePositive(inFilter.getValues().size()) / Utils.ensureOne(fixedEstimationData.getCount());
            }

            public Double visit(NotInFilter notInFilter) {
                return Utils.ensurePositive(fixedEstimationData.getCount() - (long)notInFilter.getValues().size()) / Utils.ensureOne(fixedEstimationData.getCount());
            }
        };
    }

    private FilterVisitorAdapter<Double> getPercentileFilterVisitorAdapter(final double[] percentiles, final String cacheKey, final long numMatches) {
        return new FilterVisitorAdapter<Double>(Double.valueOf(1.0)){

            public Double visit(BetweenFilter betweenFilter) {
                int minBound = IntStream.rangeClosed(0, 9).filter(i -> betweenFilter.getFrom().doubleValue() <= percentiles[i]).findFirst().orElse(0);
                int maxBound = IntStream.rangeClosed(0, 9).filter(i -> betweenFilter.getTo().doubleValue() < percentiles[i]).findFirst().orElse(9);
                int numBuckets = maxBound - minBound + 1;
                double result = (double)numBuckets / 10.0;
                log.debug("cacheKey:{} Between filter: {} percentiles[{}] = {} to percentiles[{}] = {} buckets {} multiplier {}", new Object[]{cacheKey, betweenFilter, minBound, percentiles[minBound], maxBound, percentiles[maxBound], numBuckets, result});
                return result;
            }

            public Double visit(EqualsFilter equalsFilter) {
                Long value = (Long)equalsFilter.getValue();
                int minBound = IntStream.rangeClosed(0, 9).filter(i -> (double)value.longValue() <= percentiles[i]).findFirst().orElse(0);
                int maxBound = IntStream.rangeClosed(0, 9).filter(i -> (double)value.longValue() < percentiles[i]).findFirst().orElse(9);
                int numBuckets = maxBound - minBound + 1;
                double result = (double)numBuckets / 10.0;
                log.debug("cacheKey:{} EqualsFilter:{} numMatches:{} multiplier:{}", new Object[]{cacheKey, equalsFilter, numMatches, result});
                return result;
            }

            public Double visit(NotEqualsFilter notEqualsFilter) {
                log.debug("cacheKey:{} NotEqualsFilter:{} multiplier: 1.0", (Object)cacheKey, (Object)notEqualsFilter);
                return 1.0;
            }

            public Double visit(GreaterThanFilter greaterThanFilter) {
                int minBound = IntStream.rangeClosed(0, 9).filter(i -> percentiles[i] > greaterThanFilter.getValue().doubleValue()).findFirst().orElse(0);
                double result = (double)(10 - minBound - 1) / 10.0;
                log.debug("cacheKey:{} GreaterThanFilter: {} percentiles[{}] = {} multiplier: {}", new Object[]{cacheKey, greaterThanFilter, minBound, percentiles[minBound], result});
                return result;
            }

            public Double visit(GreaterEqualFilter greaterEqualFilter) {
                int minBound = IntStream.rangeClosed(0, 9).filter(i -> percentiles[i] >= greaterEqualFilter.getValue().doubleValue()).findFirst().orElse(0);
                double result = (double)(10 - minBound - 1) / 10.0;
                log.debug("cacheKey:{} GreaterEqualsFilter:{} percentiles[{}] = {} multiplier: {}", new Object[]{cacheKey, greaterEqualFilter, minBound, percentiles[minBound], result});
                return result;
            }

            public Double visit(LessThanFilter lessThanFilter) {
                int minBound = 9 - IntStream.rangeClosed(0, 9).filter(i -> percentiles[9 - i] < lessThanFilter.getValue().doubleValue()).findFirst().orElse(0);
                double result = ((double)minBound + 1.0) / 10.0;
                log.debug("cacheKey:{} LessThanFilter:{} percentiles[{}] = {} multiplier: {}", new Object[]{cacheKey, lessThanFilter, minBound, percentiles[minBound], result});
                return result;
            }

            public Double visit(LessEqualFilter lessEqualFilter) {
                int minBound = 9 - IntStream.rangeClosed(0, 9).filter(i -> percentiles[9 - i] <= lessEqualFilter.getValue().doubleValue()).findFirst().orElse(0);
                double result = ((double)minBound + 1.0) / 10.0;
                log.debug("cacheKey:{} LessEqualsFilter: {} percentiles[{}] = {} multiplier: {}", new Object[]{cacheKey, lessEqualFilter, minBound, percentiles[minBound], result});
                return result;
            }
        };
    }

    private FilterVisitorAdapter<Double> getCardinalityFilterVisitorAdapter(final CardinalityEstimationData cardinalityEstimationData) {
        return new FilterVisitorAdapter<Double>(Double.valueOf(1.0)){

            public Double visit(EqualsFilter equalsFilter) {
                return 1.0 / Utils.ensureOne(cardinalityEstimationData.getCardinality());
            }

            public Double visit(NotEqualsFilter notEqualsFilter) {
                double numerator = Utils.ensurePositive(cardinalityEstimationData.getCardinality() - 1L);
                return numerator / Utils.ensureOne(cardinalityEstimationData.getCardinality());
            }

            public Double visit(ContainsFilter stringContainsFilterElement) {
                return 1.0 / Utils.ensureOne(cardinalityEstimationData.getCardinality());
            }

            public Double visit(InFilter inFilter) {
                return Utils.ensurePositive(inFilter.getValues().size()) / Utils.ensureOne(cardinalityEstimationData.getCardinality());
            }

            public Double visit(NotInFilter notInFilter) {
                return Utils.ensurePositive(cardinalityEstimationData.getCardinality() - (long)notInFilter.getValues().size()) / Utils.ensureOne(cardinalityEstimationData.getCardinality());
            }
        };
    }

    private FilterVisitorAdapter<Double> getTermHistogramFilterVisitorAdapter(final TermHistogramEstimationData termEstimationData, final long totalCount) {
        return new FilterVisitorAdapter<Double>(Double.valueOf(1.0)){

            public Double visit(EqualsFilter equalsFilter) {
                if (!(equalsFilter.getValue() instanceof String) || !termEstimationData.getTermCounts().containsKey(equalsFilter.getValue())) {
                    return 1.0;
                }
                long matchingDocCount = (Long)termEstimationData.getTermCounts().get(equalsFilter.getValue());
                return (double)matchingDocCount / (double)totalCount;
            }

            public Double visit(NotEqualsFilter notEqualsFilter) {
                if (!(notEqualsFilter.getValue() instanceof String) || !termEstimationData.getTermCounts().containsKey(notEqualsFilter.getValue())) {
                    return 1.0;
                }
                long matchingDocCount = (Long)termEstimationData.getTermCounts().get(notEqualsFilter.getValue());
                return (double)(totalCount - matchingDocCount) / (double)totalCount;
            }

            public Double visit(InFilter inFilter) {
                if (!GroupAction.this.isObjectInstanceOfString(inFilter.getValues())) {
                    return 1.0;
                }
                long matchingDocCount = 0L;
                for (Object value : inFilter.getValues()) {
                    Long count = (Long)termEstimationData.getTermCounts().get(value);
                    matchingDocCount += GroupAction.this.getValidCount(count).longValue();
                }
                return (double)matchingDocCount / (double)totalCount;
            }

            public Double visit(NotInFilter notInFilter) {
                if (!GroupAction.this.isObjectInstanceOfString(notInFilter.getValues())) {
                    return 1.0;
                }
                long matchingDocCount = 0L;
                for (Object value : notInFilter.getValues()) {
                    Long count = (Long)termEstimationData.getTermCounts().get(value);
                    matchingDocCount += GroupAction.this.getValidCount(count).longValue();
                }
                return (double)(totalCount - matchingDocCount) / (double)totalCount;
            }
        };
    }

    private boolean isObjectInstanceOfString(List<Object> objects) {
        for (Object object : CollectionUtils.nullSafeList(objects)) {
            if (object instanceof String) continue;
            return false;
        }
        return true;
    }

    private Long getValidCount(Long count) {
        return count == null ? 0L : count;
    }

    private AbstractAggregationBuilder buildAggregation() {
        return Utils.buildTermsAggregation(((GroupRequest)this.getParameter()).getNesting().stream().map(x -> new ResultSort(x, ResultSort.Order.asc)).collect(Collectors.toList()), !com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty((String)((GroupRequest)this.getParameter()).getUniqueCountOn()) ? Sets.newHashSet((Object[])new AggregationBuilder[]{Utils.buildCardinalityAggregation(((GroupRequest)this.getParameter()).getUniqueCountOn())}) : Sets.newHashSet());
    }

    private Map<String, Object> getMap(List<String> fields, Aggregations aggregations) {
        String field = fields.get(0);
        ArrayList<String> remainingFields = fields.size() > 1 ? fields.subList(1, fields.size()) : new ArrayList<String>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        HashMap levelCount = Maps.newHashMap();
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (fields.size() == 1) {
                if (!com.flipkart.foxtrot.common.util.CollectionUtils.isNullOrEmpty((String)((GroupRequest)this.getParameter()).getUniqueCountOn())) {
                    String key = Utils.sanitizeFieldForAggregation(((GroupRequest)this.getParameter()).getUniqueCountOn());
                    Cardinality cardinality = (Cardinality)bucket.getAggregations().get(key);
                    levelCount.put(String.valueOf(bucket.getKey()), cardinality.getValue());
                    continue;
                }
                levelCount.put(String.valueOf(bucket.getKey()), bucket.getDocCount());
                continue;
            }
            levelCount.put(String.valueOf(bucket.getKey()), this.getMap(remainingFields, bucket.getAggregations()));
        }
        return levelCount;
    }

    private void validateCardinality(GroupRequest parameter) {
        QueryStore queryStore = this.getQueryStore();
        if (queryStore instanceof ElasticsearchQueryStore && ((ElasticsearchQueryStore)queryStore).getCardinalityConfig().isEnabled()) {
            double probability = 0.0;
            try {
                TableFieldMapping fieldMappings = this.getTableMetadataManager().getFieldMappings(parameter.getTable(), true, false);
                if (null == fieldMappings) {
                    fieldMappings = TableFieldMapping.builder().mappings(Collections.emptySet()).table(parameter.getTable()).build();
                }
                probability = this.estimateProbability(fieldMappings, parameter);
            }
            catch (Exception e) {
                log.error("Error running estimation", (Throwable)e);
            }
            if (probability > 0.5) {
                String content = this.requestString();
                log.warn("Blocked query as it might have screwed up the cluster. Probability: {} Query: {}", (Object)probability, (Object)content);
                throw FoxtrotExceptions.createCardinalityOverflow((ActionRequest)parameter, content, (String)parameter.getNesting().get(0), probability);
            }
            log.info("Allowing group by with probability {} for query: {}", (Object)probability, (Object)parameter);
        }
    }
}

