/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.distinct.DistinctRequest;
import com.flipkart.foxtrot.common.distinct.DistinctResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyticsProvider(opcode="distinct", request=DistinctRequest.class, response=DistinctResponse.class, cacheable=true)
public class DistinctAction
extends Action<DistinctRequest> {
    private static final Logger logger = LoggerFactory.getLogger(DistinctAction.class);

    public DistinctAction(DistinctRequest parameter, AnalyticsLoader analyticsLoader) {
        super(parameter, analyticsLoader);
    }

    @Override
    public void preprocess() {
        ((DistinctRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((DistinctRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((DistinctRequest)this.getParameter()).getTable();
    }

    @Override
    public String getRequestCacheKey() {
        long filterHashKey = 0L;
        DistinctRequest query = (DistinctRequest)this.getParameter();
        if (null != query.getFilters()) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        for (int i = 0; i < query.getNesting().size(); ++i) {
            filterHashKey += (long)(31 * ((ResultSort)query.getNesting().get(i)).hashCode() * (i + 1));
        }
        return String.format("%s-%d", query.getTable(), filterHashKey);
    }

    @Override
    public void validateImpl(DistinctRequest parameter) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((Collection)parameter.getNesting())) {
            validationErrors.add("At least one nesting parameter is required");
        } else {
            for (ResultSort resultSort : com.collections.CollectionUtils.nullSafeList((List)parameter.getNesting())) {
                if (CollectionUtils.isNullOrEmpty((String)resultSort.getField())) {
                    validationErrors.add("nested parameter cannot have null name");
                }
                if (resultSort.getOrder() != null) continue;
                validationErrors.add("nested parameter cannot have null sorting order");
            }
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse execute(DistinctRequest request) {
        SearchRequestBuilder query;
        try {
            query = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(request.getTable(), (ActionRequest)request)).setIndicesOptions(Utils.indicesOptions());
            query.setQuery(new ElasticSearchQueryGenerator().genFilter(request.getFilters())).setSize(10000).addAggregation((AggregationBuilder)Utils.buildTermsAggregation(request.getNesting(), Sets.newHashSet()));
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)request, e);
        }
        try {
            SearchResponse response = (SearchResponse)query.execute().actionGet(this.getGetQueryTimeout());
            return this.getResponse((ActionResponse)response, (DistinctRequest)this.getParameter());
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)request, (Exception)((Object)e));
        }
    }

    public SearchRequestBuilder getRequestBuilder(DistinctRequest request) {
        SearchRequestBuilder query;
        try {
            query = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(request.getTable(), (ActionRequest)request)).setIndicesOptions(Utils.indicesOptions());
            query.setQuery(new ElasticSearchQueryGenerator().genFilter(request.getFilters())).setSize(10000).addAggregation((AggregationBuilder)Utils.buildTermsAggregation(request.getNesting(), Sets.newHashSet()));
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)request, e);
        }
        return query;
    }

    @Override
    public com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse response, DistinctRequest parameter) {
        Aggregations aggregations = ((SearchResponse)response).getAggregations();
        if (aggregations == null) {
            logger.error("Null response for Group. Request : {}", (Object)parameter);
            return new DistinctResponse(new ArrayList(), new ArrayList());
        }
        return this.getDistinctResponse(parameter, aggregations);
    }

    private DistinctResponse getDistinctResponse(DistinctRequest request, Aggregations aggregations) {
        DistinctResponse response = new DistinctResponse();
        List<String> headerList = request.getNesting().stream().map(ResultSort::getField).collect(Collectors.toList());
        response.setHeaders(headerList);
        ArrayList<List<String>> responseList = new ArrayList<List<String>>();
        this.flatten(null, headerList, responseList, aggregations);
        response.setResult(responseList);
        return response;
    }

    private void flatten(String parentKey, List<String> fields, List<List<String>> responseList, Aggregations aggregations) {
        String field = fields.get(0);
        ArrayList<String> remainingFields = fields.size() > 1 ? fields.subList(1, fields.size()) : new ArrayList<String>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (fields.size() == 1) {
                responseList.add(this.getValueList(parentKey, String.valueOf(bucket.getKey())));
                continue;
            }
            this.flatten(this.getProperKey(parentKey, String.valueOf(bucket.getKey())), remainingFields, responseList, bucket.getAggregations());
        }
    }

    private String getProperKey(String parentKey, String currentKey) {
        return parentKey == null ? currentKey : parentKey + "_--&--_" + currentKey;
    }

    private List<String> getValueList(String parentKey, String currentKey) {
        String finalValue = this.getProperKey(parentKey, currentKey);
        String[] valuesList = finalValue.split("_--&--_");
        return Arrays.asList(valuesList);
    }
}

