/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.ActionValidationResponse;
import com.flipkart.foxtrot.core.cache.Cache;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.common.AsyncDataToken;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.querystore.ActionEvaluationResponse;
import com.flipkart.foxtrot.core.querystore.ActionExecutionObserver;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(QueryExecutor.class);
    private final AnalyticsLoader analyticsLoader;
    private final ExecutorService executorService;
    private final List<ActionExecutionObserver> executionObservers;

    @Inject
    public QueryExecutor(AnalyticsLoader analyticsLoader, ExecutorService executorService, List<ActionExecutionObserver> executionObservers) {
        this.analyticsLoader = analyticsLoader;
        this.executorService = executorService;
        this.executionObservers = executionObservers;
    }

    public <T extends ActionRequest> ActionValidationResponse validate(T request) {
        return this.resolve(request).validate();
    }

    public <T extends ActionRequest> ActionResponse execute(T request) {
        ActionResponse actionResponse;
        ActionEvaluationResponse evaluationResponse;
        Action action;
        Stopwatch stopwatch;
        block5: {
            stopwatch = Stopwatch.createStarted();
            action = null;
            evaluationResponse = null;
            action = this.resolve(request);
            ActionResponse cachedData = this.readCachedData(this.analyticsLoader.getCacheManager(), request, action);
            if (cachedData == null) break block5;
            cachedData.setFromCache(true);
            evaluationResponse = ActionEvaluationResponse.success(action, request, cachedData, stopwatch.elapsed(TimeUnit.MILLISECONDS), true);
            ActionResponse actionResponse2 = cachedData;
            this.notifyObserverPostExec(evaluationResponse);
            return actionResponse2;
        }
        try {
            this.notifyObserverPreExec(request);
            ActionResponse response = action.execute();
            evaluationResponse = ActionEvaluationResponse.success(action, request, response, stopwatch.elapsed(TimeUnit.MILLISECONDS), false);
            actionResponse = response;
        }
        catch (FoxtrotException e) {
            try {
                evaluationResponse = ActionEvaluationResponse.failure(action, request, e, stopwatch.elapsed(TimeUnit.MILLISECONDS));
                throw e;
            }
            catch (Throwable throwable) {
                this.notifyObserverPostExec(evaluationResponse);
                throw throwable;
            }
        }
        this.notifyObserverPostExec(evaluationResponse);
        return actionResponse;
    }

    public <T extends ActionRequest> AsyncDataToken executeAsync(T request) {
        Action action = this.resolve(request);
        String cacheKey = action.cacheKey();
        AsyncDataToken dataToken = new AsyncDataToken(request.getOpcode(), cacheKey);
        ActionResponse response = this.readCachedData(this.analyticsLoader.getCacheManager(), request, action);
        if (null != response) {
            return dataToken;
        }
        this.executorService.submit(() -> {
            ActionResponse execute = this.execute(request);
            this.analyticsLoader.getCacheManager().getCacheFor(dataToken.getAction()).put(dataToken.getKey(), execute);
        });
        return dataToken;
    }

    public <T extends ActionRequest> Action resolve(T request) {
        Action<T> action = this.analyticsLoader.getAction(request);
        if (null == action) {
            throw FoxtrotExceptions.createUnresolvableActionException(request);
        }
        return action;
    }

    private void notifyObserverPreExec(ActionRequest request) {
        if (null == this.executionObservers) {
            return;
        }
        this.executionObservers.forEach(actionExecutionObserver -> actionExecutionObserver.preExecution(request));
    }

    private void notifyObserverPostExec(ActionEvaluationResponse evaluationResponse) {
        if (null == this.executionObservers) {
            return;
        }
        this.executionObservers.forEach(actionExecutionObserver -> actionExecutionObserver.postExecution(evaluationResponse));
    }

    private ActionResponse readCachedData(CacheManager cacheManager, ActionRequest request, Action action) {
        Cache cache = cacheManager.getCacheFor(request.getOpcode());
        if (null != cache) {
            String cacheKey = action.cacheKey();
            if (cache.has(cacheKey)) {
                log.info("Cache hit for key: {}", (Object)cacheKey);
                return cache.get(cacheKey);
            }
            log.info("Cache miss for key: {}", (Object)cacheKey);
        }
        return null;
    }
}

