/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.jobs.optimization;

import com.collections.CollectionUtils;
import com.flipkart.foxtrot.core.jobs.BaseJobManager;
import com.flipkart.foxtrot.core.jobs.optimization.EsIndexOptimizationConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.util.MetricUtil;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=40)
public class EsIndexOptimizationManager
extends BaseJobManager {
    private static final int BATCH_SIZE = 5;
    private static final int SEGMENTS_TO_OPTIMIZE_TO = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EsIndexOptimizationManager.class.getSimpleName());
    private final ElasticsearchConnection elasticsearchConnection;
    private final EsIndexOptimizationConfig esIndexOptimizationConfig;

    @Inject
    public EsIndexOptimizationManager(ScheduledExecutorService scheduledExecutorService, EsIndexOptimizationConfig esIndexOptimizationConfig, ElasticsearchConnection elasticsearchConnection, HazelcastConnection hazelcastConnection) {
        super(esIndexOptimizationConfig, scheduledExecutorService, hazelcastConnection);
        this.esIndexOptimizationConfig = esIndexOptimizationConfig;
        this.elasticsearchConnection = elasticsearchConnection;
    }

    @Override
    protected void runImpl(LockingTaskExecutor executor, Instant lockAtMostUntil) {
        executor.executeWithLock(() -> {
            try {
                IndicesSegmentsRequest indicesSegmentsRequest = new IndicesSegmentsRequest();
                IndicesSegmentResponse indicesSegmentResponse = (IndicesSegmentResponse)this.elasticsearchConnection.getClient().admin().indices().segments(indicesSegmentsRequest).actionGet();
                HashSet indicesToOptimize = Sets.newHashSet();
                Map segmentResponseIndices = indicesSegmentResponse.getIndices();
                for (Map.Entry entry : segmentResponseIndices.entrySet()) {
                    String index = (String)entry.getKey();
                    this.extractIndicesToOptimizeForIndex(index, (IndexSegments)entry.getValue(), indicesToOptimize);
                }
                this.optimizeIndices(indicesToOptimize);
                LOGGER.info("No of indexes optimized : {}", (Object)indicesToOptimize.size());
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while calling optimization API", (Throwable)e);
            }
        }, new LockConfiguration(this.esIndexOptimizationConfig.getJobName(), lockAtMostUntil));
    }

    private void optimizeIndices(Set<String> indicesToOptimize) {
        List batchOfIndicesToOptimize = CollectionUtils.partition(indicesToOptimize, (int)5);
        for (List indices : batchOfIndicesToOptimize) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.elasticsearchConnection.getClient().admin().indices().prepareForceMerge(indices.toArray(new String[0])).setMaxNumSegments(1).setFlush(true).setOnlyExpungeDeletes(false).execute().actionGet();
            LOGGER.info("No of indexes optimized : {}", (Object)indices.size());
            MetricUtil.getInstance().registerActionSuccess("indexesOptimized", CollectionUtils.mkString((Collection)indices, (String)","), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private void extractIndicesToOptimizeForIndex(String index, IndexSegments indexShardSegments, Set<String> indicesToOptimize) {
        String table = ElasticsearchUtils.getTableNameFromIndex(index);
        if (StringUtils.isEmpty((CharSequence)table)) {
            return;
        }
        String currentIndex = ElasticsearchUtils.getCurrentIndex(table, System.currentTimeMillis());
        String nextDayIndex = ElasticsearchUtils.getCurrentIndex(table, System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        if (index.equals(currentIndex) || index.equals(nextDayIndex)) {
            return;
        }
        Map indexShardSegmentsMap = indexShardSegments.getShards();
        for (Map.Entry indexShardSegmentsEntry : indexShardSegmentsMap.entrySet()) {
            List segments = ((ShardSegments)((IndexShardSegments)indexShardSegmentsEntry.getValue()).iterator().next()).getSegments();
            if (segments.size() <= 1) continue;
            indicesToOptimize.add(index);
            break;
        }
    }
}

