/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.email;

import com.flipkart.foxtrot.core.email.Email;
import com.flipkart.foxtrot.core.email.EmailConfig;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EmailClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailClient.class);
    private final EmailConfig emailConfig;
    private final Session session;

    @Inject
    public EmailClient(EmailConfig emailConfig) {
        this.emailConfig = emailConfig;
        Properties mailProps = new Properties();
        mailProps.put("mail.transport.protocol", "smtp");
        mailProps.put("mail.smtp.port", (Object)emailConfig.getPort());
        mailProps.put("mail.smtp.auth", (Object)false);
        mailProps.put("mail.smtp.host", emailConfig.getHost());
        mailProps.put("mail.smtp.startttls.enable", (Object)false);
        mailProps.put("mail.smtp.timeout", (Object)10000);
        mailProps.put("mail.smtp.connectiontimeout", (Object)10000);
        this.session = Session.getDefaultInstance((Properties)mailProps);
    }

    public boolean sendEmail(Email email) {
        if (Strings.isNullOrEmpty((String)this.emailConfig.getFrom())) {
            LOGGER.warn("Mail config not set properly. No mail will be sent.");
            return false;
        }
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)new InternetAddress(this.emailConfig.getFrom()));
            List<String> recipients = this.recipients(email);
            if (recipients.isEmpty()) {
                return false;
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)String.join((CharSequence)",", recipients)));
            message.setSubject(email.getSubject());
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-type", "text/html; charset=UTF-8");
            String content = email.getContent();
            if (null != content) {
                MimeBodyPart messageBodyPart = new MimeBodyPart(headers, content.getBytes(StandardCharsets.UTF_8));
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                message.setContent((Multipart)multipart);
            }
            Transport.send((Message)message, (String)this.emailConfig.getUser(), (String)this.emailConfig.getPassword());
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while sending the email :%s", (Throwable)e);
            return false;
        }
        return true;
    }

    private List<String> recipients(Email email) {
        List<String> emailRecipients = email.getRecipients();
        List<String> defaultRecipients = this.emailConfig.getEventNotificationEmails();
        ImmutableList.Builder recipientsBuilder = ImmutableList.builder();
        if (null != email.getRecipients()) {
            recipientsBuilder.addAll(emailRecipients);
        }
        if (null != defaultRecipients) {
            recipientsBuilder.addAll(defaultRecipients);
        }
        return recipientsBuilder.build();
    }
}

