/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.datastore.impl.hbase;

import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseConfig;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.util.TableUtil;
import io.dropwizard.lifecycle.Managed;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=0)
public class HbaseTableConnection
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger((String)HbaseTableConnection.class.getSimpleName());
    private static final String DEFAULT_FAMILY_NAME = "d";
    private final HbaseConfig hbaseConfig;
    private Configuration configuration;
    private Connection connection;
    private Admin hBaseAdmin;

    @Inject
    public HbaseTableConnection(Configuration configuration, HbaseConfig hbaseConfig) {
        this.configuration = configuration;
        this.hbaseConfig = hbaseConfig;
    }

    public synchronized Table getTable(com.flipkart.foxtrot.common.Table table) {
        try {
            if (this.hbaseConfig.isSecure() && UserGroupInformation.isSecurityEnabled()) {
                UserGroupInformation.getCurrentUser().reloginFromKeytab();
            }
            return this.connection.getTable(TableName.valueOf((String)TableUtil.getTableName(this.hbaseConfig, table)));
        }
        catch (Exception e) {
            throw FoxtrotExceptions.createConnectionException(table, e);
        }
    }

    public synchronized boolean isTableAvailable(com.flipkart.foxtrot.common.Table table) throws IOException {
        String tableName = TableUtil.getTableName(this.hbaseConfig, table);
        return this.hBaseAdmin.isTableAvailable(TableName.valueOf((String)tableName));
    }

    public synchronized void createTable(com.flipkart.foxtrot.common.Table table) throws IOException {
        String tableName = TableUtil.getTableName(this.hbaseConfig, table);
        HTableDescriptor hTableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor hColumnDescriptor = new HColumnDescriptor(DEFAULT_FAMILY_NAME);
        hColumnDescriptor.setCompressionType(Compression.Algorithm.GZ);
        hTableDescriptor.addFamily(hColumnDescriptor);
        this.hBaseAdmin.createTable(hTableDescriptor);
    }

    public String getHBaseTableName(com.flipkart.foxtrot.common.Table table) {
        return TableUtil.getTableName(this.hbaseConfig, table);
    }

    public void start() throws Exception {
        logger.info("Starting HBase Connection");
        this.connection = ConnectionFactory.createConnection((Configuration)this.configuration);
        this.hBaseAdmin = this.connection.getAdmin();
        logger.info("Started HBase Connection");
    }

    public void stop() throws Exception {
        this.connection.close();
        this.hBaseAdmin.close();
    }

    public HbaseConfig getHbaseConfig() {
        return this.hbaseConfig;
    }
}

