/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.datastore.impl.hbase;

import com.flipkart.foxtrot.core.datastore.impl.hbase.HbaseConfig;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HBaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(HBaseUtil.class);

    private HBaseUtil() {
    }

    public static Configuration create(HbaseConfig hbaseConfig) throws IOException {
        Configuration configuration = HBaseConfiguration.create();
        if (HBaseUtil.isValidFile(hbaseConfig.getCoreSite())) {
            configuration.addResource(new File(hbaseConfig.getCoreSite()).toURI().toURL());
        }
        if (HBaseUtil.isValidFile(hbaseConfig.getHdfsSite())) {
            configuration.addResource(new File(hbaseConfig.getHdfsSite()).toURI().toURL());
        }
        if (HBaseUtil.isValidFile(hbaseConfig.getHbasePolicy())) {
            configuration.addResource(new File(hbaseConfig.getHbasePolicy()).toURI().toURL());
        }
        if (HBaseUtil.isValidFile(hbaseConfig.getHbaseSite())) {
            configuration.addResource(new File(hbaseConfig.getHbaseSite()).toURI().toURL());
        }
        if (hbaseConfig.isSecure() && HBaseUtil.isValidFile(hbaseConfig.getKeytabFileName())) {
            configuration.set("hbase.master.kerberos.principal", hbaseConfig.getAuthString());
            configuration.set("hadoop.kerberos.kinit.command", hbaseConfig.getKinitPath());
            UserGroupInformation.setConfiguration((Configuration)configuration);
            System.setProperty("java.security.krb5.conf", hbaseConfig.getKerberosConfigFile());
            UserGroupInformation.loginUserFromKeytab((String)hbaseConfig.getAuthString(), (String)hbaseConfig.getKeytabFileName());
            logger.info("Logged into Hbase with User: {}", (Object)UserGroupInformation.getLoginUser());
        }
        if (null != hbaseConfig.getHbaseZookeeperQuorum()) {
            configuration.set("hbase.zookeeper.quorum", hbaseConfig.getHbaseZookeeperQuorum());
        }
        if (!Strings.isNullOrEmpty((String)hbaseConfig.getHbaseZookeeperZnodeParent())) {
            configuration.set("zookeeper.znode.parent", hbaseConfig.getHbaseZookeeperZnodeParent());
        }
        if (null != hbaseConfig.getHbaseZookeeperClientPort()) {
            configuration.setInt("hbase.zookeeper.property.clientPort", hbaseConfig.getHbaseZookeeperClientPort().intValue());
        }
        return configuration;
    }

    public static boolean isValidFile(String fileName) {
        return fileName != null && !fileName.trim().isEmpty() && new File(fileName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(HbaseConfig hbaseConfig, String tableName) throws IOException {
        HTableDescriptor hTableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("d");
        columnDescriptor.setCompressionType(Compression.Algorithm.GZ);
        hTableDescriptor.addFamily(columnDescriptor);
        Configuration configuration = HBaseUtil.create(hbaseConfig);
        Connection connection = ConnectionFactory.createConnection((Configuration)configuration);
        Admin hBaseAdmin = null;
        try {
            hBaseAdmin = connection.getAdmin();
            hBaseAdmin.createTable(hTableDescriptor);
        }
        catch (Exception e) {
            logger.error("Could not create table: " + tableName, (Throwable)e);
        }
        finally {
            try {
                if (hBaseAdmin != null) {
                    hBaseAdmin.close();
                }
            }
            catch (Exception e) {
                logger.error("Error closing hbase admin", (Throwable)e);
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.error("Error closing hbase connection", (Throwable)e);
            }
        }
    }
}

