/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.common;

import com.flipkart.foxtrot.core.common.DataDeletionManagerConfig;
import com.flipkart.foxtrot.core.common.DataDeletionTask;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import io.dropwizard.lifecycle.Managed;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.hazelcast.HazelcastLockProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=25)
public class DataDeletionManager
implements Managed {
    private static final int MAX_TIME_TO_RUN_TASK_IN_HOURS = 2;
    private static final Logger logger = LoggerFactory.getLogger((String)DataDeletionManager.class.getSimpleName());
    private final DataDeletionManagerConfig config;
    private final QueryStore queryStore;
    private final ScheduledExecutorService scheduledExecutorService;
    private final HazelcastConnection hazelcastConnection;

    @Inject
    public DataDeletionManager(DataDeletionManagerConfig deletionManagerConfig, QueryStore queryStore, ScheduledExecutorService scheduledExecutorService, HazelcastConnection hazelcastConnection) {
        this.config = deletionManagerConfig;
        this.queryStore = queryStore;
        this.hazelcastConnection = hazelcastConnection;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void start() throws Exception {
        logger.info("Starting Deletion Manager");
        if (this.config.isActive()) {
            logger.info("Scheduling data deletion Job");
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                DefaultLockingTaskExecutor executor = new DefaultLockingTaskExecutor((LockProvider)new HazelcastLockProvider(this.hazelcastConnection.getHazelcast()));
                Instant lockAtMostUntil = Instant.now().plusSeconds(TimeUnit.HOURS.toSeconds(2L));
                executor.executeWithLock((Runnable)new DataDeletionTask(this.queryStore), new LockConfiguration("dataDeletion", lockAtMostUntil));
            }, this.config.getInitialDelay(), this.config.getInterval(), TimeUnit.SECONDS);
            logger.info("Scheduled data deletion Job");
        } else {
            logger.info("Not scheduling data deletion Job");
        }
        logger.info("Started Deletion Manager");
    }

    public void stop() throws Exception {
        logger.info("Stopped Deletion Manager");
    }
}

