/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionValidationResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.general.AnyFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsLoader;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Action<P extends ActionRequest> {
    private static final Logger logger = LoggerFactory.getLogger((String)Action.class.getSimpleName());
    private final TableMetadataManager tableMetadataManager;
    private final QueryStore queryStore;
    private final CacheManager cacheManager;
    private final ObjectMapper objectMapper;
    private P parameter;
    private ElasticsearchConnection connection;

    protected Action(P parameter, AnalyticsLoader analyticsLoader) {
        this.parameter = parameter;
        this.tableMetadataManager = analyticsLoader.getTableMetadataManager();
        this.queryStore = analyticsLoader.getQueryStore();
        this.cacheManager = analyticsLoader.getCacheManager();
        this.connection = analyticsLoader.getElasticsearchConnection();
        this.objectMapper = analyticsLoader.getObjectMapper();
    }

    public String cacheKey() {
        return String.format("%s-%d", this.getRequestCacheKey(), System.currentTimeMillis() / 30000L);
    }

    private void preProcessRequest() {
        if (this.parameter.getFilters() == null) {
            this.parameter.setFilters((List)Lists.newArrayList((Object[])new Filter[]{new AnyFilter()}));
        }
        this.preprocess();
        this.parameter.setFilters(this.checkAndAddTemporalBoundary(this.parameter.getFilters()));
        this.validateBase(this.parameter);
        this.validateImpl(this.parameter);
    }

    public abstract void preprocess();

    public ActionValidationResponse validate() {
        try {
            this.preProcessRequest();
        }
        catch (MalformedQueryException e) {
            return ActionValidationResponse.builder().processedRequest(this.parameter).validationErrors(e.getReasons()).build();
        }
        catch (Exception e) {
            return ActionValidationResponse.builder().processedRequest(this.parameter).validationErrors(Collections.singletonList(e.getMessage())).build();
        }
        return ActionValidationResponse.builder().processedRequest(this.parameter).validationErrors(Collections.emptyList()).build();
    }

    public com.flipkart.foxtrot.common.ActionResponse execute() {
        this.preProcessRequest();
        return this.execute(this.parameter);
    }

    public long getGetQueryTimeout() {
        if (this.getConnection().getConfig() == null) {
            return 10000L;
        }
        return this.getConnection().getConfig().getGetQueryTimeout();
    }

    private void validateBase(P parameter) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!CollectionUtils.isNullOrEmpty((Collection)parameter.getFilters())) {
            for (Filter filter : parameter.getFilters()) {
                Set errors = filter.validate();
                if (CollectionUtils.isNullOrEmpty((Collection)errors)) continue;
                validationErrors.addAll(errors);
            }
        }
        if (!CollectionUtils.isNullOrEmpty(validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException(parameter, validationErrors);
        }
    }

    public abstract String getMetricKey();

    public abstract String getRequestCacheKey();

    public abstract ActionRequestBuilder getRequestBuilder(P var1);

    public abstract com.flipkart.foxtrot.common.ActionResponse getResponse(ActionResponse var1, P var2);

    public abstract void validateImpl(P var1);

    public abstract com.flipkart.foxtrot.common.ActionResponse execute(P var1);

    protected P getParameter() {
        return this.parameter;
    }

    public ElasticsearchConnection getConnection() {
        return this.connection;
    }

    public TableMetadataManager getTableMetadataManager() {
        return this.tableMetadataManager;
    }

    public QueryStore getQueryStore() {
        return this.queryStore;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected Filter getDefaultTimeSpan() {
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        return lessThanFilter;
    }

    protected String requestString() {
        try {
            return this.objectMapper.writeValueAsString(this.parameter);
        }
        catch (JsonProcessingException e) {
            logger.error("Error serializing request: ", (Throwable)e);
            return "";
        }
    }

    private List<Filter> checkAndAddTemporalBoundary(List<Filter> filters) {
        if (null != filters) {
            for (Filter filter : filters) {
                if (!filter.isFilterTemporal()) continue;
                return filters;
            }
        }
        filters = null == filters ? Lists.newArrayList() : Lists.newArrayList((Iterable)filters);
        filters.add(this.getDefaultTimeSpan());
        return filters;
    }
}

