/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cardinality;

import com.flipkart.foxtrot.core.jobs.BaseJobConfig;
import java.beans.ConstructorProperties;
import javax.ws.rs.DefaultValue;
import org.apache.commons.lang3.StringUtils;

public class CardinalityConfig
extends BaseJobConfig {
    private static final String JOB_NAME = "CardinalityConfigJob";
    private String enabled;
    private String batchSize;
    @DefaultValue(value="50000")
    private long maxCardinality;

    public CardinalityConfig(String enabled, String batchSize) {
        this.enabled = enabled;
        this.batchSize = batchSize;
    }

    public boolean isEnabled() {
        if (StringUtils.isEmpty((CharSequence)this.enabled)) {
            return false;
        }
        return Boolean.valueOf(this.enabled);
    }

    public int getSubListSize() {
        if (StringUtils.isEmpty((CharSequence)this.batchSize)) {
            return 50;
        }
        return Integer.parseInt(this.batchSize);
    }

    @Override
    public String getJobName() {
        return JOB_NAME;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public long getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxCardinality(long maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardinalityConfig)) {
            return false;
        }
        CardinalityConfig other = (CardinalityConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$enabled = this.getEnabled();
        String other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) {
            return false;
        }
        String this$batchSize = this.getBatchSize();
        String other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !this$batchSize.equals(other$batchSize)) {
            return false;
        }
        return this.getMaxCardinality() == other.getMaxCardinality();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CardinalityConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : $enabled.hashCode());
        String $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : $batchSize.hashCode());
        long $maxCardinality = this.getMaxCardinality();
        result = result * 59 + (int)($maxCardinality >>> 32 ^ $maxCardinality);
        return result;
    }

    @Override
    public String toString() {
        return "CardinalityConfig(enabled=" + this.getEnabled() + ", batchSize=" + this.getBatchSize() + ", maxCardinality=" + this.getMaxCardinality() + ")";
    }

    @ConstructorProperties(value={"enabled", "batchSize", "maxCardinality"})
    public CardinalityConfig(String enabled, String batchSize, long maxCardinality) {
        this.enabled = enabled;
        this.batchSize = batchSize;
        this.maxCardinality = maxCardinality;
    }

    public CardinalityConfig() {
    }
}

