/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cardinality;

import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.cardinality.CardinalityConfig;
import com.flipkart.foxtrot.core.jobs.BaseJobManager;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;

@Singleton
@Order(value=35)
public class CardinalityCalculationManager
extends BaseJobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CardinalityCalculationManager.class.getSimpleName());
    private static final int MAX_TIME_TO_RUN_JOB = 120;
    private final TableMetadataManager tableMetadataManager;
    private final CardinalityConfig cardinalityConfig;

    @Inject
    public CardinalityCalculationManager(TableMetadataManager tableMetadataManager, CardinalityConfig cardinalityConfig, HazelcastConnection hazelcastConnection, ScheduledExecutorService scheduledExecutorService) {
        super(cardinalityConfig, scheduledExecutorService, hazelcastConnection);
        this.tableMetadataManager = tableMetadataManager;
        this.cardinalityConfig = cardinalityConfig;
    }

    @Override
    protected void runImpl(LockingTaskExecutor executor, Instant lockAtMostUntil) {
        executor.executeWithLock(() -> {
            try {
                int maxTimeToRunJob = 120;
                if (this.cardinalityConfig.getMaxTimeToRunJobInMinutes() != 0) {
                    maxTimeToRunJob = this.cardinalityConfig.getMaxTimeToRunJobInMinutes();
                }
                Instant start = Instant.now();
                Set tables = this.tableMetadataManager.get().stream().map(Table::getName).collect(Collectors.toSet());
                for (String table : tables) {
                    Instant now;
                    Duration timeElapsed;
                    if (!this.tableMetadataManager.cardinalityCacheContains(table)) {
                        this.tableMetadataManager.getFieldMappings(table, true, true);
                        LOGGER.info("Cardinality calculated for table: {}", (Object)table);
                    }
                    if ((timeElapsed = Duration.between(start, now = Instant.now())).compareTo(Duration.ofMinutes(maxTimeToRunJob)) <= 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while calculating cardinality {}", (Throwable)e);
            }
        }, new LockConfiguration(this.cardinalityConfig.getJobName(), lockAtMostUntil));
    }
}

