/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cache;

import com.flipkart.foxtrot.core.cache.Cache;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CacheManager {
    private final Map<String, Cache> cacheMap = new HashMap<String, Cache>();
    private CacheFactory cacheFactory;

    @Inject
    public CacheManager(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public void create(String name) {
        if (!this.cacheMap.containsKey(name)) {
            this.cacheMap.put(name, this.cacheFactory.create(name));
        }
    }

    public Cache getCacheFor(String name) {
        return this.cacheMap.get(name);
    }
}

