/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.table.impl;

import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConfig;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import io.appform.testcontainers.commons.ContainerUtils;
import io.appform.testcontainers.elasticsearch.config.ElasticsearchContainerConfiguration;
import io.appform.testcontainers.elasticsearch.utils.ElasticsearchContainerUtils;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;

public class ElasticsearchTestUtils {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchTestUtils.class);

    public static synchronized ElasticsearchConnection getConnection() throws Exception {
        ElasticsearchContainerHolder.containerLoaded = true;
        ElasticsearchConnection elasticsearchConnection = new ElasticsearchConnection(ElasticsearchContainerHolder.getElasticsearchConfig());
        elasticsearchConnection.start();
        return elasticsearchConnection;
    }

    public static void cleanupIndices(ElasticsearchConnection elasticsearchConnection) {
        try {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest("_all");
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)elasticsearchConnection.getClient().admin().indices().delete(deleteIndexRequest).get();
            log.info("Delete index response: {}", (Object)deleteIndexResponse);
        }
        catch (Exception e) {
            log.error("Index Cleanup failed", (Throwable)e);
        }
    }

    private static class ElasticsearchContainerHolder {
        private static boolean containerLoaded;
        private static ElasticsearchConfig elasticsearchConfig;

        private ElasticsearchContainerHolder() {
        }

        public static ElasticsearchConfig getElasticsearchConfig() {
            return elasticsearchConfig;
        }

        static {
            try {
                ElasticsearchContainerConfiguration configuration = new ElasticsearchContainerConfiguration();
                configuration.setClusterRamMb(100);
                GenericContainer esContainer = new FixedHostPortGenericContainer(configuration.getDockerImage()).withExposedPorts(new Integer[]{configuration.getHttpPort(), configuration.getTransportPort()}).withEnv("cluster.name", "elasticsearch").withEnv("discovery.type", "single-node").withEnv("ES_JAVA_OPTS", ElasticsearchContainerUtils.getJavaOpts((ElasticsearchContainerConfiguration)configuration)).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).waitingFor(ElasticsearchContainerUtils.getCompositeWaitStrategy((ElasticsearchContainerConfiguration)configuration)).withStartupTimeout(configuration.getTimeoutDuration());
                esContainer.start();
                Integer mappedPort = esContainer.getMappedPort(configuration.getTransportPort());
                elasticsearchConfig = new ElasticsearchConfig();
                elasticsearchConfig.setHosts(Collections.singletonList(configuration.getHost()));
                elasticsearchConfig.setPort(mappedPort);
                elasticsearchConfig.setCluster("elasticsearch");
                elasticsearchConfig.setTableNamePrefix("foxtrot");
            }
            catch (Exception e) {
                log.error("Error in initializing es test container , error :", (Throwable)e);
                throw e;
            }
        }
    }
}

