/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.trend.TrendRequest;
import com.flipkart.foxtrot.common.trend.TrendResponse;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.ErrorCode;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TrendActionTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getTrendDocuments(TrendActionTest.getMapper());
        TrendActionTest.getQueryStore().save("test-table", documents);
        TrendActionTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    private void filterNonZeroCounts(List<TrendResponse.Count> counts) {
        counts.removeIf(count -> count.getCount() == 0L);
    }

    @Test
    public void testTrendActionNullField() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        trendRequest.setField(null);
        try {
            TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (FoxtrotException e) {
            Assert.assertEquals((Object)ErrorCode.MALFORMED_QUERY, (Object)e.getCode());
        }
    }

    @Test
    public void testTrendActionFieldAll() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        trendRequest.setField("all");
        trendRequest.setValues(Collections.emptyList());
        TrendResponse expectedResponse = new TrendResponse();
        expectedResponse.setTrends(new HashMap());
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionEmptyField() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        trendRequest.setField("");
        trendRequest.setValues(Collections.emptyList());
        try {
            TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.MALFORMED_QUERY, (Object)ex.getCode());
        }
    }

    @Test
    public void testTrendActionFieldWithSpecialCharacters() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        trendRequest.setField("!@!41242$");
        trendRequest.setValues(Collections.emptyList());
        TrendResponse expectedResponse = new TrendResponse();
        expectedResponse.setTrends(new HashMap());
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionNullTable() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable(null);
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setField("os");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        try {
            TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest);
            Assert.fail();
        }
        catch (FoxtrotException ex) {
            Assert.assertEquals((Object)ErrorCode.MALFORMED_QUERY, (Object)ex.getCode());
        }
    }

    @Test
    public void testTrendActionWithField() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setField("os");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 6L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 1L));
        trends.put("android", counts);
        counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397673000000L, 1L));
        counts.add(new TrendResponse.Count((Number)1397932200000L, 1L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 2L));
        trends.put("ios", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("android"));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("ios"));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionWithFieldZeroTo() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setField("os");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 6L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 1L));
        trends.put("android", counts);
        counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397673000000L, 1L));
        counts.add(new TrendResponse.Count((Number)1397932200000L, 1L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 2L));
        trends.put("ios", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("android"));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("ios"));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionWithFieldZeroFrom() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setField("os");
        trendRequest.setFilters(Collections.singletonList(betweenFilter));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 6L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 1L));
        trends.put("android", counts);
        counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397673000000L, 1L));
        counts.add(new TrendResponse.Count((Number)1397932200000L, 1L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 2L));
        trends.put("ios", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("android"));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("ios"));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionWithFieldWithValues() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        trendRequest.setField("os");
        trendRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{betweenFilter}));
        trendRequest.setValues(Arrays.asList("android"));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 6L));
        counts.add(new TrendResponse.Count((Number)1398623400000L, 1L));
        trends.put("android", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        this.filterNonZeroCounts((List)actualResponse.getTrends().get("android"));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionWithFieldWithFilterWithValues() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        trendRequest.setField("os");
        trendRequest.setValues(Arrays.asList("android"));
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("version");
        equalsFilter.setValue((Object)1);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        trendRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter, lessThanFilter}));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 2L));
        trends.put("android", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionWithFieldWithFilter() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        trendRequest.setField("os");
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("version");
        equalsFilter.setValue((Object)1);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        trendRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter, lessThanFilter}));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 2L));
        trends.put("android", counts);
        counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397673000000L, 1L));
        trends.put("ios", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void testTrendActionWithFieldWithFilterWithInterval() throws FoxtrotException, JsonProcessingException {
        TrendRequest trendRequest = new TrendRequest();
        trendRequest.setTable("test-table");
        trendRequest.setField("os");
        trendRequest.setPeriod(Period.days);
        EqualsFilter equalsFilter = new EqualsFilter();
        equalsFilter.setField("version");
        equalsFilter.setValue((Object)1);
        LessThanFilter lessThanFilter = new LessThanFilter();
        lessThanFilter.setTemporal(true);
        lessThanFilter.setField("_timestamp");
        lessThanFilter.setValue((Number)System.currentTimeMillis());
        trendRequest.setFilters((List)Lists.newArrayList((Object[])new Filter[]{equalsFilter, lessThanFilter}));
        TrendResponse expectedResponse = new TrendResponse();
        HashMap trends = Maps.newHashMap();
        ArrayList counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397586600000L, 2L));
        trends.put("android", counts);
        counts = Lists.newArrayList();
        counts.add(new TrendResponse.Count((Number)1397673000000L, 1L));
        trends.put("ios", counts);
        expectedResponse.setTrends((Map)trends);
        TrendResponse actualResponse = (TrendResponse)TrendResponse.class.cast(TrendActionTest.getQueryExecutor().execute((ActionRequest)trendRequest));
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
    }
}

