/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.stats.AnalyticsRequestFlags;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.Stat;
import com.flipkart.foxtrot.common.stats.StatsTrendRequest;
import com.flipkart.foxtrot.common.stats.StatsTrendResponse;
import com.flipkart.foxtrot.common.stats.StatsTrendValue;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.dropwizard.jackson.Jackson;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StatsTrendActionTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getStatsTrendDocuments(StatsTrendActionTest.getMapper());
        StatsTrendActionTest.getQueryStore().save("test-table", documents);
        StatsTrendActionTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test
    public void testStatsTrendActionWithoutNesting() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)5L, (long)statsTrendResponse.getResult().size());
        Assert.assertEquals((long)8L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertEquals((long)7L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getPercentiles().size());
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionWithoutNestingSkipPercentile() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setFlags(Collections.singleton(AnalyticsRequestFlags.STATS_SKIP_PERCENTILES));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)5L, (long)statsTrendResponse.getResult().size());
        Assert.assertEquals((long)8L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertNull((Object)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getPercentiles());
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionNoExtendedStat() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setStats(EnumSet.allOf(Stat.class).stream().filter(x -> !x.isExtended()).collect(Collectors.toSet()));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)5L, (long)statsTrendResponse.getResult().size());
        Assert.assertEquals((long)5L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertEquals((long)7L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getPercentiles().size());
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionOnlyCountStat() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.COUNT));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().containsKey("count"));
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionOnlyMaxStat() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.MAX));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().containsKey("max"));
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionOnlyMinStat() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.MIN));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().containsKey("min"));
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionOnlyAvgStat() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.AVG));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().containsKey("avg"));
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionOnlySumStat() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setStats(Collections.singleton(Stat.SUM));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().containsKey("sum"));
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionOnlyOnePercentile() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setPercentiles(Collections.singletonList(5.0));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getPercentiles().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getPercentiles().containsKey(5.0));
    }

    @Test
    public void testStatsTrendActionWithNesting() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os"}));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNull((Object)statsTrendResponse.getResult());
        Assert.assertNotNull((Object)statsTrendResponse.getBuckets());
        Assert.assertEquals((long)3L, (long)statsTrendResponse.getBuckets().size());
    }

    @Test
    public void testStatsTrendActionWithMultiLevelNesting() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNull((Object)statsTrendResponse.getResult());
        Assert.assertNotNull((Object)statsTrendResponse.getBuckets());
        Assert.assertEquals((long)3L, (long)statsTrendResponse.getBuckets().size());
        Assert.assertEquals((long)1L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().size());
        Assert.assertEquals((long)2L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(1)).getBuckets().size());
        Assert.assertEquals((long)1L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(2)).getBuckets().size());
        Assert.assertNotNull((Object)((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().get(0)).getResult()).get(0)).getPercentiles());
    }

    @Test
    public void testStatsTrendActionWithMultiLevelNestingSkipPercentile() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        request.setFlags(Collections.singleton(AnalyticsRequestFlags.STATS_SKIP_PERCENTILES));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        try {
            System.out.println(Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)statsTrendResponse));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNull((Object)statsTrendResponse.getResult());
        Assert.assertNotNull((Object)statsTrendResponse.getBuckets());
        Assert.assertEquals((long)3L, (long)statsTrendResponse.getBuckets().size());
        Assert.assertEquals((long)1L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().size());
        Assert.assertEquals((long)2L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(1)).getBuckets().size());
        Assert.assertEquals((long)1L, (long)((BucketResponse)statsTrendResponse.getBuckets().get(2)).getBuckets().size());
        Assert.assertNull((Object)((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().get(0)).getResult()).get(0)).getPercentiles());
    }

    @Test
    public void testStatsTrendActionWithNoFilter() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        Assert.assertNull((Object)statsTrendResponse);
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsTrendActionNullTable() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable(null);
        request.setTimestamp("_timestamp");
        request.setField("battery");
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request);
    }

    @Test(expected=MalformedQueryException.class)
    public void testStatsTrendActionNullField() throws FoxtrotException, JsonProcessingException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField(null);
        request.setNesting((List)Lists.newArrayList((Object[])new String[]{"os", "version"}));
        StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request);
    }

    @Test
    public void testStatsTrendActionTextField() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("os");
        request.setStats(Collections.singleton(Stat.AVG));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        this.filterNonZeroCounts(statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse);
        Assert.assertNotNull((Object)statsTrendResponse.getResult());
        Assert.assertEquals((long)1L, (long)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().size());
        Assert.assertTrue((boolean)((StatsTrendValue)statsTrendResponse.getResult().get(0)).getStats().containsKey("count"));
        Assert.assertNull((Object)statsTrendResponse.getBuckets());
    }

    @Test
    public void testStatsTrendActionTextFieldNested() throws FoxtrotException {
        StatsTrendRequest request = new StatsTrendRequest();
        request.setTable("test-table");
        request.setTimestamp("_timestamp");
        request.setField("os");
        request.setNesting((List)ImmutableList.of((Object)"os", (Object)"device"));
        request.setStats(Collections.singleton(Stat.AVG));
        BetweenFilter betweenFilter = new BetweenFilter();
        betweenFilter.setFrom((Number)1L);
        betweenFilter.setTo((Number)System.currentTimeMillis());
        betweenFilter.setTemporal(true);
        betweenFilter.setField("_timestamp");
        request.setFilters(Collections.singletonList(betweenFilter));
        StatsTrendResponse statsTrendResponse = (StatsTrendResponse)StatsTrendResponse.class.cast(StatsTrendActionTest.getQueryExecutor().execute((ActionRequest)request));
        try {
            System.out.println(Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)statsTrendResponse));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        Assert.assertNull((Object)statsTrendResponse.getResult());
        Assert.assertNotNull((Object)statsTrendResponse.getBuckets());
        Assert.assertNull((Object)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getResult());
        Assert.assertNotNull((Object)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets());
        Assert.assertEquals((Object)1L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().get(0)).getResult()).get(0)).getStats().get("count"));
        Assert.assertEquals((Object)0L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().get(0)).getResult()).get(2)).getStats().get("count"));
        Assert.assertEquals((Object)0L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().get(0)).getResult()).get(12)).getStats().get("count"));
        Assert.assertEquals((Object)1L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(0)).getBuckets().get(0)).getResult()).get(13)).getStats().get("count"));
        Assert.assertEquals((Object)1L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(1)).getBuckets().get(0)).getResult()).get(0)).getStats().get("count"));
        Assert.assertEquals((Object)1L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(1)).getBuckets().get(1)).getResult()).get(0)).getStats().get("count"));
        Assert.assertEquals((Object)1L, ((StatsTrendValue)((List)((BucketResponse)((BucketResponse)statsTrendResponse.getBuckets().get(2)).getBuckets().get(0)).getResult()).get(0)).getStats().get("count"));
    }

    private void filterNonZeroCounts(StatsTrendResponse statsTrendResponse) {
        statsTrendResponse.getResult().removeIf(statsTrendValue -> statsTrendValue.getStats() == null || statsTrendValue.getStats().containsKey("count") && ((Number)statsTrendValue.getStats().get("count")).equals(0L));
    }
}

