/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.Document;
import com.flipkart.foxtrot.common.count.CountRequest;
import com.flipkart.foxtrot.common.count.CountResponse;
import com.flipkart.foxtrot.common.query.MultiQueryRequest;
import com.flipkart.foxtrot.common.query.MultiQueryResponse;
import com.flipkart.foxtrot.common.query.Query;
import com.flipkart.foxtrot.common.query.QueryResponse;
import com.flipkart.foxtrot.common.query.ResultSort;
import com.flipkart.foxtrot.core.TestUtils;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.querystore.actions.ActionTest;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiQueryActionTest
extends ActionTest {
    @BeforeClass
    public static void setUp() throws Exception {
        List<Document> documents = TestUtils.getQueryDocuments(MultiQueryActionTest.getMapper());
        MultiQueryActionTest.getQueryStore().save("test-table", documents);
        MultiQueryActionTest.getElasticsearchConnection().getClient().admin().indices().prepareRefresh(new String[]{"*"}).execute().actionGet();
    }

    @Test
    public void testMultiQuery() throws FoxtrotException, JsonProcessingException {
        HashMap requests = Maps.newHashMap();
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.asc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        requests.put("1", query);
        CountRequest countRequest = new CountRequest();
        countRequest.setTable("test-table");
        countRequest.setField("os");
        countRequest.setDistinct(false);
        requests.put("2", countRequest);
        MultiQueryRequest multiQueryRequest = new MultiQueryRequest((Map)requests);
        ActionResponse actionResponse = MultiQueryActionTest.getQueryExecutor().execute((ActionRequest)multiQueryRequest);
        MultiQueryResponse multiQueryResponse = null;
        if (actionResponse instanceof MultiQueryResponse) {
            multiQueryResponse = (MultiQueryResponse)actionResponse;
        }
        Assert.assertNotNull(multiQueryResponse);
        QueryResponse queryResponse = (QueryResponse)multiQueryResponse.getResponses().get("1");
        CountResponse countResponse = (CountResponse)multiQueryResponse.getResponses().get("2");
        Assert.assertEquals((long)9L, (long)countResponse.getCount());
    }

    @Test
    public void testQueryNoFilterAscending() throws FoxtrotException, JsonProcessingException {
        HashMap requests = Maps.newHashMap();
        Query query = new Query();
        query.setTable("test-table");
        ResultSort resultSort = new ResultSort();
        resultSort.setOrder(ResultSort.Order.asc);
        resultSort.setField("_timestamp");
        query.setSort(resultSort);
        requests.put("1", query);
        requests.put("2", query);
        MultiQueryRequest multiQueryRequest = new MultiQueryRequest((Map)requests);
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(TestUtils.getDocument("W", 1397658117001L, new Object[]{"os", "android", "device", "nexus", "battery", 99}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("X", 1397658117002L, new Object[]{"os", "android", "device", "nexus", "battery", 74}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("Y", 1397658117003L, new Object[]{"os", "android", "device", "nexus", "battery", 48}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("Z", 1397658117004L, new Object[]{"os", "android", "device", "nexus", "battery", 24}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("A", 1397658118000L, new Object[]{"os", "android", "version", 1, "device", "nexus"}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("B", 1397658118001L, new Object[]{"os", "android", "version", 1, "device", "galaxy"}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("C", 1397658118002L, new Object[]{"os", "android", "version", 2, "device", "nexus"}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("D", 1397658118003L, new Object[]{"os", "ios", "version", 1, "device", "iphone"}, MultiQueryActionTest.getMapper()));
        documents.add(TestUtils.getDocument("E", 1397658118004L, new Object[]{"os", "ios", "version", 2, "device", "ipad"}, MultiQueryActionTest.getMapper()));
        MultiQueryResponse multiQueryResponse = (MultiQueryResponse)MultiQueryResponse.class.cast(MultiQueryActionTest.getQueryExecutor().execute((ActionRequest)multiQueryRequest));
        for (Map.Entry response : multiQueryResponse.getResponses().entrySet()) {
            this.compare(documents, ((QueryResponse)response.getValue()).getDocuments());
        }
    }

    public void compare(List<Document> expectedDocuments, List<Document> actualDocuments) {
        Assert.assertEquals((long)expectedDocuments.size(), (long)actualDocuments.size());
        for (int i = 0; i < expectedDocuments.size(); ++i) {
            Document expected = expectedDocuments.get(i);
            Document actual = actualDocuments.get(i);
            Assert.assertNotNull((Object)expected);
            Assert.assertNotNull((Object)actual);
            Assert.assertNotNull((String)"Actual document Id should not be null", (Object)actual.getId());
            Assert.assertNotNull((String)"Actual document data should not be null", (Object)actual.getData());
            Assert.assertEquals((String)"Actual Doc Id should match expected Doc Id", (Object)expected.getId(), (Object)actual.getId());
            Assert.assertEquals((String)"Actual Doc Timestamp should match expected Doc Timestamp", (long)expected.getTimestamp(), (long)actual.getTimestamp());
            Map expectedMap = (Map)MultiQueryActionTest.getMapper().convertValue((Object)expected.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            Map actualMap = (Map)MultiQueryActionTest.getMapper().convertValue((Object)actual.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            Assert.assertEquals((String)"Actual data should match expected data", (Object)expectedMap, (Object)actualMap);
        }
    }
}

